/*
 * Decompiled with CFR 0.152.
 */
package vmm.surface.parametric;

import vmm.core.Complex;
import vmm.core.IntegerParam;
import vmm.core.RealParamAnimateable;
import vmm.core.View;
import vmm.core3D.ComplexVector3D;
import vmm.core3D.GridTransformMatrix;
import vmm.core3D.Vector3D;
import vmm.surface.parametric.WeierstrassMinimalSurface;

public class Skew_K_noid
extends WeierstrassMinimalSurface {
    private IntegerParam exponent = new IntegerParam("vmm.surface.parametric.Skew_K_noid.MainEx", 2);
    private RealParamAnimateable aa = new RealParamAnimateable("vmm.surface.parametric.Skew_K_noid.aa", 0.4, 0.0, 0.93);
    private int ex;
    private int e_odd;
    private int j0;
    private double AA;
    private double r1;
    private double rex;
    private double re_e;
    private double mob;
    private Complex q1;

    public Skew_K_noid() {
        this.afp.reset(0.0, 0.0, 0.0);
        this.addParameter(this.aa);
        this.aa.setMaximumValueForInput(0.95);
        this.aa.setMinimumValueForInput(0.0);
        this.addParameter(this.exponent);
        this.exponent.setMinimumValueForInput(2);
        this.setDefaultViewpoint(new Vector3D(-2.0, 14.0, -50.0));
        this.setDefaultOrientation(1);
        this.setDefaultWindow(-4.0, 4.0, -3.0, 3.0);
        this.uPatchCount.setValueAndDefault(12);
        this.vPatchCount.setValueAndDefault(20);
        this.umin.reset(-2.5);
        this.umax.reset(0.0);
        this.vmin.reset(-1.5707963267948966);
        this.vmax.reset(1.5707963267948966);
        this.umin.setMaximumValueForInput(-0.05);
        this.removeParameter(this.umax);
        this.removeParameter(this.vmax);
        this.removeParameter(this.vmin);
        this.canShowConjugateSurface = true;
    }

    public View getDefaultView() {
        WeierstrassMinimalSurface.WMSView wMSView = new WeierstrassMinimalSurface.WMSView(this);
        wMSView.setGridSpacing(12);
        return wMSView;
    }

    protected void createData() {
        super.createData();
        this.data.discardGridTransforms();
        if (!this.inAssociateMorph) {
            int n;
            GridTransformMatrix[] gridTransformMatrixArray = new GridTransformMatrix[this.ex * 4];
            gridTransformMatrixArray[0] = new GridTransformMatrix();
            if (this.flag0) {
                gridTransformMatrixArray[1] = new GridTransformMatrix().scale(1.0, -1.0, 1.0);
                this.data.addGridTransform(gridTransformMatrixArray[1]);
            } else if (this.flag05) {
                gridTransformMatrixArray[1] = new GridTransformMatrix().scale(-1.0, 1.0, -1.0).reverse();
                this.data.addGridTransform(gridTransformMatrixArray[1]);
            }
            if (this.flag0 || this.flag05) {
                for (n = 1; n < this.ex; ++n) {
                    gridTransformMatrixArray[2 * n] = new GridTransformMatrix(gridTransformMatrixArray[2 * n - 2]).rotateZ(360.0 / (double)this.ex);
                    this.data.addGridTransform(gridTransformMatrixArray[2 * n]);
                    gridTransformMatrixArray[2 * n + 1] = new GridTransformMatrix(gridTransformMatrixArray[2 * n - 1]).rotateZ(360.0 / (double)this.ex);
                    this.data.addGridTransform(gridTransformMatrixArray[2 * n + 1]);
                }
            }
            if (this.flag0) {
                for (n = 0; n < 2 * this.ex; ++n) {
                    gridTransformMatrixArray[2 * this.ex + n] = new GridTransformMatrix(gridTransformMatrixArray[n]).scale(1.0, 1.0, -1.0);
                    this.data.addGridTransform(gridTransformMatrixArray[2 * this.ex + n]);
                }
            }
        }
    }

    protected Complex domainGrid(double d, double d2) {
        double d3 = Math.exp(d);
        Complex complex = new Complex(d3 * Math.cos(d2), d3 * Math.sin(d2));
        Complex complex2 = new Complex(-complex.re + 1.0, -complex.im);
        Complex complex3 = new Complex(complex.im, -complex.re - 1.0);
        complex2.assignDivide(complex3);
        complex2 = complex2.mobius1_1(this.mob);
        complex = complex2.logNearer(I_C);
        complex.assignTimes(1.0 / (double)this.ex);
        return complex.exponential();
    }

    protected void zeroIndex() {
        double d = 10.0;
        for (int i = 0; i < this.vcount; ++i) {
            double d2 = this.domainGrid(this.umax.getValue(), this.vmin.getValue() + (double)i * this.dv).r();
            if (!(d2 <= d)) continue;
            d = d2;
            this.j0 = i;
        }
    }

    protected Complex gauss(Complex complex) {
        Complex complex2 = complex.integerPower(this.ex - 1);
        Complex complex3 = complex.times(complex2);
        Complex complex4 = complex3.times(-this.rex);
        complex4.re += 1.0;
        complex3.re -= this.rex;
        complex3 = complex2.times(complex3).dividedBy(complex4);
        return complex3;
    }

    protected Complex hPrime(Complex complex) {
        Complex complex2 = complex.integerPower(this.ex - 1);
        Complex complex3 = complex.times(complex2);
        Complex complex4 = complex3.times(complex3);
        complex4.re += 1.0;
        Complex complex5 = complex4.times(-this.re_e);
        complex5.assignPlus(complex3);
        complex5.assignTimes(complex2);
        complex4.re -= 4.0 * this.re_e * complex3.re;
        complex4.im -= 4.0 * this.re_e * complex3.im;
        complex4.assignTimes(complex4);
        complex4.assignTimes(this.r1);
        return complex5.dividedBy(complex4);
    }

    protected void redoConstants() {
        super.redoConstants();
        this.AA = Math.sqrt(this.aa.getValue());
        this.ex = this.exponent.getValue();
        this.rex = Math.pow(this.AA, this.ex);
        this.re_e = this.rex / (this.rex * this.rex + 1.0);
        this.r1 = 1.0 / (1.0 - this.AA * this.AA * this.AA * this.AA) * Math.sqrt(2.0 / (double)this.ex);
        double d = 2.0 * this.re_e;
        double d2 = Math.sqrt(1.0 - d * d);
        this.mob = Math.sqrt((1.0 - d2) / (1.0 - d) / 2.0);
        this.zeroIndex();
    }

    protected ComplexVector3D getCenter() {
        ComplexVector3D complexVector3D = new ComplexVector3D(this.helperArray[this.ucount - 1][this.j0]);
        complexVector3D = complexVector3D.plus(this.ComplexVectorOneStepIntegrator(this.domainGrid(this.umax.getValue(), this.vmin.getValue() + (double)this.j0 * this.dv), del));
        if (!this.inAssociateMorph) {
            complexVector3D.z = new Complex(this.helperArray[this.ucount - 1][0].z);
        }
        return complexVector3D;
    }

    public Vector3D surfacePoint(double d, double d2) {
        int n = (int)Math.floor(0.25 + (d - this.umin.getValue()) / this.du);
        int n2 = (int)Math.floor(0.25 + (d2 - this.vmin.getValue()) / this.dv);
        ComplexVector3D complexVector3D = new ComplexVector3D(this.helperArray[n][n2].plus(this.ComplexVectorOneStepIntegrator(this.domainGrid(this.umin.getValue() + (double)n * this.du, this.vmin.getValue() + (double)n2 * this.dv), this.domainGrid(d, d2))));
        ComplexVector3D complexVector3D2 = new ComplexVector3D(complexVector3D.y.minus(complexVector3D.x), complexVector3D.y.plus(complexVector3D.x).times(I_C), complexVector3D.z);
        if (n == this.ucount - 1 && n2 == this.j0) {
            complexVector3D2 = new ComplexVector3D(ZERO_C, ZERO_C, complexVector3D2.z);
        }
        if (this.AFP == 0.0) {
            return complexVector3D2.re();
        }
        return complexVector3D2.re().times(Math.cos(this.AFP)).plus(complexVector3D2.im().times(Math.sin(this.AFP)));
    }

    public void createIntegrationGrid() {
        double d = this.umin.getValue();
        double d2 = this.vmin.getValue();
    }
}

