/*
 * Decompiled with CFR 0.152.
 */
package vmm.surface.parametric;

import java.awt.Color;
import vmm.core.Complex;
import vmm.core.RealParamAnimateable;
import vmm.core.View;
import vmm.core3D.ComplexVector3D;
import vmm.core3D.GridTransformMatrix;
import vmm.core3D.Vector3D;
import vmm.surface.parametric.WeierstrassMinimalSurface;

public class SchwarzPDsurface
extends WeierstrassMinimalSurface {
    private RealParamAnimateable aa = new RealParamAnimateable("vmm.surface.parametric.SchwarzPDsurface.aa", 0.2, 0.48, 0.02);
    private RealParamAnimateable bb = new RealParamAnimateable("vmm.surface.parametric.SchwarzPDsurface.bb", 0.6, 0.52, 0.98);
    private int um;
    private int vm;
    private double Phi1;
    private double Phi2;
    private double rp1;
    private double RP2;
    private double r1_;
    private double R2_;
    private double scale;
    private Complex xWidth;
    private Complex yWidth;
    private Complex zWidth;
    private Vector3D centerRE;
    private Vector3D centerRE_;
    private Vector3D centerIM;
    private Vector3D trans;

    public SchwarzPDsurface() {
        this.addParameter(this.bb);
        this.bb.setMaximumValueForInput(0.99);
        this.bb.setMinimumValueForInput(0.05);
        this.addParameter(this.aa);
        this.aa.setMaximumValueForInput(0.95);
        this.aa.setMinimumValueForInput(0.02);
        this.setDefaultOrientation(1);
        this.setDefaultViewUp(new Vector3D(-0.045, 0.4, 0.915));
        this.setDefaultViewpoint(new Vector3D(12.0, -44.0, 20.0));
        this.setDefaultWindow(-3.0, 3.0, -2.8, 2.2);
        this.uPatchCount.setValueAndDefault(12);
        this.vPatchCount.setValueAndDefault(12);
        this.umin.reset(0.005);
        this.umax.reset(0.995);
        this.vmin.reset(0.0);
        this.vmax.reset(1.0);
        this.removeParameter(this.vmin);
        this.removeParameter(this.vmax);
        this.removeParameter(this.umin);
        this.removeParameter(this.umax);
        this.iFirstInHelper = false;
        this.wantsToSeeDomain = false;
        this.wantsToSeeGaussImage = false;
        if (this.wantsToSeeGaussImage) {
            this.wantsToSeeDomain = true;
        }
        if (this.wantsToSeeDomain) {
            this.setDefaultViewUp(new Vector3D(0.0, 0.0, 1.0));
            this.setDefaultViewpoint(new Vector3D(0.0, 0.0, 40.0));
        }
        this.multipleCopyOptions = new int[]{2};
        this.canShowConjugateSurface = true;
    }

    public View getDefaultView() {
        WeierstrassMinimalSurface.WMSView wMSView = new WeierstrassMinimalSurface.WMSView(this);
        wMSView.setGridSpacing(12);
        float f = 0.2f;
        wMSView.getLightSettings().setAmbientLight(new Color(f, f, f));
        wMSView.getLightSettings().setSpecularExponent(100);
        wMSView.getLightSettings().setSpecularRatio(0.8f);
        return wMSView;
    }

    protected void createData() {
        super.createData();
        this.computePeriodData();
        this.data.discardGridTransforms();
        GridTransformMatrix[] gridTransformMatrixArray = new GridTransformMatrix[64];
        gridTransformMatrixArray[0] = new GridTransformMatrix();
        GridTransformMatrix gridTransformMatrix = new GridTransformMatrix();
        gridTransformMatrixArray[1] = new GridTransformMatrix().scale(-1.0, -1.0, -1.0).reverse();
        if (!this.wantsToSeeDomain) {
            this.data.addGridTransform(gridTransformMatrixArray[1]);
            if (!this.inAssociateMorph) {
                int n;
                if (this.flag0) {
                    gridTransformMatrix = new GridTransformMatrix().scale(-1.0, -1.0, 1.0);
                    this.trans = new Vector3D(this.centerRE.x, this.centerRE.y, 0.0);
                    gridTransformMatrixArray[2] = new GridTransformMatrix(gridTransformMatrixArray[0]).leftMultiplyBy(gridTransformMatrix).translate(this.trans);
                    gridTransformMatrixArray[3] = new GridTransformMatrix(gridTransformMatrixArray[1]).leftMultiplyBy(gridTransformMatrix).translate(this.trans);
                    this.data.addGridTransform(gridTransformMatrixArray[2]);
                    this.data.addGridTransform(gridTransformMatrixArray[3]);
                    gridTransformMatrix = new GridTransformMatrix().scale(1.0, -1.0, -1.0);
                    this.trans = new Vector3D(0.0, this.centerRE.y, this.centerRE.z);
                    for (n = 0; n < 4; ++n) {
                        gridTransformMatrixArray[4 + n] = new GridTransformMatrix(gridTransformMatrixArray[n]).leftMultiplyBy(gridTransformMatrix).translate(this.trans);
                        this.data.addGridTransform(gridTransformMatrixArray[4 + n]);
                    }
                    gridTransformMatrix = new GridTransformMatrix().scale(-1.0, -1.0, -1.0);
                    for (n = 0; n < 8; ++n) {
                        gridTransformMatrixArray[8 + n] = new GridTransformMatrix(gridTransformMatrixArray[n]).leftMultiplyBy(gridTransformMatrix).translate(this.centerRE);
                        this.data.addGridTransform(gridTransformMatrixArray[8 + n]);
                    }
                    this.trans = new Vector3D(this.centerRE.x, this.centerRE.y, -this.centerRE.z);
                    for (n = 0; n < 4; ++n) {
                        gridTransformMatrixArray[16 + n] = new GridTransformMatrix(gridTransformMatrixArray[n]).leftMultiplyBy(gridTransformMatrix).translate(this.trans);
                        this.data.addGridTransform(gridTransformMatrixArray[16 + n]);
                        gridTransformMatrixArray[20 + n] = new GridTransformMatrix(gridTransformMatrixArray[12 + n]).leftMultiplyBy(gridTransformMatrix).translate(this.trans);
                        this.data.addGridTransform(gridTransformMatrixArray[20 + n]);
                    }
                    if (this.getNumberOfPieces() == 2) {
                        this.trans = new Vector3D(4.0 * this.xWidth.re, 0.0, 0.0);
                        for (n = 0; n < 24; ++n) {
                            gridTransformMatrixArray[24 + n] = new GridTransformMatrix(gridTransformMatrixArray[n]).translate(this.trans);
                            this.data.addGridTransform(gridTransformMatrixArray[24 + n]);
                        }
                    }
                }
                if (this.flag05) {
                    gridTransformMatrix = new GridTransformMatrix().scale(-1.0, -1.0, 1.0).reverse();
                    this.trans = new Vector3D(this.centerIM.x, this.centerIM.y, 0.0);
                    gridTransformMatrixArray[2] = new GridTransformMatrix(gridTransformMatrixArray[0]).leftMultiplyBy(gridTransformMatrix).translate(this.trans);
                    gridTransformMatrixArray[3] = new GridTransformMatrix(gridTransformMatrixArray[1]).leftMultiplyBy(gridTransformMatrix).translate(this.trans);
                    this.data.addGridTransform(gridTransformMatrixArray[2]);
                    this.data.addGridTransform(gridTransformMatrixArray[3]);
                    gridTransformMatrix = new GridTransformMatrix().scale(1.0, -1.0, -1.0).reverse();
                    this.trans = new Vector3D(0.0, this.centerIM.y, this.centerIM.z);
                    gridTransformMatrixArray[4] = new GridTransformMatrix(gridTransformMatrixArray[0]).leftMultiplyBy(gridTransformMatrix).translate(this.trans);
                    gridTransformMatrixArray[5] = new GridTransformMatrix(gridTransformMatrixArray[1]).leftMultiplyBy(gridTransformMatrix).translate(this.trans);
                    this.data.addGridTransform(gridTransformMatrixArray[4]);
                    this.data.addGridTransform(gridTransformMatrixArray[5]);
                    gridTransformMatrix = new GridTransformMatrix().scale(-1.0, 1.0, -1.0);
                    this.trans = new Vector3D(this.centerIM.x, 0.0, this.centerIM.z);
                    gridTransformMatrixArray[6] = new GridTransformMatrix(gridTransformMatrixArray[0]).leftMultiplyBy(gridTransformMatrix).translate(this.trans);
                    gridTransformMatrixArray[7] = new GridTransformMatrix(gridTransformMatrixArray[1]).leftMultiplyBy(gridTransformMatrix).translate(this.trans);
                    this.data.addGridTransform(gridTransformMatrixArray[6]);
                    this.data.addGridTransform(gridTransformMatrixArray[7]);
                    gridTransformMatrix = new GridTransformMatrix().scale(1.0, -1.0, -1.0).reverse();
                    this.trans = new Vector3D(0.0, -this.centerIM.y, -this.centerIM.z);
                    gridTransformMatrixArray[8] = new GridTransformMatrix(gridTransformMatrixArray[0]).leftMultiplyBy(gridTransformMatrix).translate(this.trans);
                    gridTransformMatrixArray[9] = new GridTransformMatrix(gridTransformMatrixArray[1]).leftMultiplyBy(gridTransformMatrix).translate(this.trans);
                    this.data.addGridTransform(gridTransformMatrixArray[8]);
                    this.data.addGridTransform(gridTransformMatrixArray[9]);
                    this.trans = new Vector3D(2.0 * this.centerIM.x, 0.0, 2.0 * this.centerIM.z);
                    gridTransformMatrixArray[10] = new GridTransformMatrix(gridTransformMatrixArray[8]).translate(this.trans);
                    gridTransformMatrixArray[11] = new GridTransformMatrix(gridTransformMatrixArray[9]).translate(this.trans);
                    this.data.addGridTransform(gridTransformMatrixArray[10]);
                    this.data.addGridTransform(gridTransformMatrixArray[11]);
                    gridTransformMatrix = new GridTransformMatrix().scale(-1.0, 1.0, -1.0).reverse();
                    this.trans = new Vector3D(this.centerIM.x, 0.0, -1.0 * this.centerIM.z);
                    gridTransformMatrixArray[12] = new GridTransformMatrix(gridTransformMatrixArray[8]).leftMultiplyBy(gridTransformMatrix).translate(this.trans);
                    gridTransformMatrixArray[13] = new GridTransformMatrix(gridTransformMatrixArray[9]).leftMultiplyBy(gridTransformMatrix).translate(this.trans);
                    this.data.addGridTransform(gridTransformMatrixArray[12]);
                    this.data.addGridTransform(gridTransformMatrixArray[13]);
                    this.trans = new Vector3D(0.0, -2.0 * this.centerIM.y, 0.0);
                    gridTransformMatrixArray[14] = new GridTransformMatrix(gridTransformMatrixArray[0]).translate(this.trans);
                    gridTransformMatrixArray[15] = new GridTransformMatrix(gridTransformMatrixArray[1]).translate(this.trans);
                    this.data.addGridTransform(gridTransformMatrixArray[14]);
                    this.data.addGridTransform(gridTransformMatrixArray[15]);
                    if (this.getNumberOfPieces() == 2) {
                        gridTransformMatrix = new GridTransformMatrix().scale(-1.0, -1.0, 1.0).reverse();
                        this.trans = new Vector3D(-this.centerIM.x, -this.centerIM.y, 0.0);
                        for (n = 0; n < 16; ++n) {
                            gridTransformMatrixArray[16 + n] = new GridTransformMatrix(gridTransformMatrixArray[n]).leftMultiplyBy(gridTransformMatrix).translate(this.trans);
                            this.data.addGridTransform(gridTransformMatrixArray[16 + n]);
                        }
                    }
                }
            }
        }
    }

    public static double paramRescale(double d) {
        double d2 = Math.sin(1.5707963267948966 * d);
        return d2 * d2;
    }

    protected Complex domainGrid(double d, double d2) {
        double d3 = 0.0;
        double d4 = Math.sin(1.5707963267948966 * d);
        if (d2 <= 0.3333333333333333) {
            d3 = -Math.PI + this.Phi1 * SchwarzPDsurface.paramRescale(3.0 * d2);
        } else if (d2 > 0.3333333333333333 && d2 <= 0.6666666666666666) {
            d3 = -Math.PI + this.Phi1 + (this.Phi2 - this.Phi1) * SchwarzPDsurface.paramRescale(3.0 * d2 - 1.0);
        } else if (d2 > 0.6666666666666666) {
            d3 = -Math.PI + this.Phi2 + (Math.PI - this.Phi2) * SchwarzPDsurface.paramRescale(3.0 * d2 - 2.0);
        }
        Complex complex = new Complex(d4 * Math.cos(d3), d4 * Math.sin(d3));
        if (this.wantsToSeeGaussImage) {
            complex = this.gauss(complex);
        }
        return complex;
    }

    protected Complex gauss(Complex complex) {
        Complex complex2 = complex.times(complex);
        Complex complex3 = new Complex(1.0 - complex2.re, -complex2.im);
        complex2.re = 1.0 + complex2.re;
        Complex complex4 = complex3.inverse().times(complex2);
        double d = -2.0 * complex4.im - this.r1_;
        complex4.im = 2.0 * complex4.re;
        complex4.re = d;
        Complex complex5 = complex4.times(-2.0 / (this.R2_ - this.r1_));
        complex5.re = -complex5.re - 1.0;
        complex5.im = -complex5.im;
        Complex complex6 = complex5.times(complex5);
        complex6.re -= 1.0;
        Complex complex7 = complex6.squareRootNearer(complex5).minus(complex5);
        return complex7.squareRootNearer(I1_C);
    }

    protected Complex hPrime(Complex complex) {
        Complex complex2 = complex.times(complex);
        complex2.re -= 1.0;
        Complex complex3 = this.gauss(complex);
        Complex complex4 = complex3.times(complex3);
        Complex complex5 = complex4.times(complex4);
        complex5.re -= 1.0;
        complex5.assignTimes(complex2);
        complex3 = complex5.inverse().times(complex4);
        complex3.assignTimes(this.scale);
        return complex3;
    }

    protected void redoConstants() {
        super.redoConstants();
        this.Phi1 = Math.PI * this.aa.getValue();
        this.Phi2 = Math.PI * this.bb.getValue();
        this.rp1 = Math.tan(this.Phi1 / 2.0);
        this.RP2 = Math.tan(this.Phi2 / 2.0);
        this.r1_ = this.rp1 - 1.0 / this.rp1;
        this.R2_ = this.RP2 - 1.0 / this.RP2;
        this.scale = Math.sqrt(Math.sqrt((0.1 + this.aa.getValue()) * (1.1 - this.bb.getValue())) / (this.bb.getValue() - this.aa.getValue()));
        this.um = 1;
        this.vm = 1;
    }

    protected ComplexVector3D getCenter() {
        ComplexVector3D complexVector3D = new ComplexVector3D(this.helperArray[0][0]);
        complexVector3D = complexVector3D.plus(this.helperArray[0][this.vcount - 1]).times(0.5);
        return complexVector3D;
    }

    public void computePeriodData() {
        ComplexVector3D complexVector3D;
        if (this.flag0) {
            complexVector3D = new ComplexVector3D(this.helperToMinimal(this.helperArray[this.ucount - 1][(int)Math.floor(this.vcount * 5 / 6)]));
            this.xWidth = complexVector3D.x;
            complexVector3D = new ComplexVector3D(this.helperToMinimal(this.helperArray[this.ucount - 1][(int)Math.floor(this.vcount / 2)]));
            this.zWidth = complexVector3D.z;
            complexVector3D = new ComplexVector3D(this.helperToMinimal(this.helperArray[this.ucount - 1][(int)Math.floor(this.vcount / 6)]));
            this.yWidth = complexVector3D.y;
            this.centerRE = new Vector3D(-2.0 * this.xWidth.re, -2.0 * this.yWidth.re, -2.0 * this.zWidth.re);
            this.centerRE_ = new Vector3D(2.0 * this.xWidth.re, 2.0 * this.yWidth.re, 2.0 * this.zWidth.re);
        }
        if (this.flag05) {
            complexVector3D = new ComplexVector3D(this.helperToMinimal(this.helperArray[this.ucount - 1][(int)Math.floor(this.vcount * 5 / 6)]));
            this.zWidth = complexVector3D.z;
            complexVector3D = new ComplexVector3D(this.helperToMinimal(this.helperArray[this.ucount - 1][(int)Math.floor(this.vcount / 2)]));
            this.yWidth = complexVector3D.y;
            complexVector3D = new ComplexVector3D(this.helperToMinimal(this.helperArray[this.ucount - 1][(int)Math.floor(this.vcount / 6)]));
            this.xWidth = complexVector3D.x;
            this.centerIM = new Vector3D(2.0 * this.xWidth.im, 2.0 * this.yWidth.im, 2.0 * this.zWidth.im);
        }
    }
}

