/*
 * Decompiled with CFR 0.152.
 */
package vmm.surface.parametric;

import java.awt.Color;
import vmm.core.Complex;
import vmm.core.Parameter;
import vmm.core.RealParamAnimateable;
import vmm.core.View;
import vmm.core3D.ComplexVector3D;
import vmm.core3D.GridTransformMatrix;
import vmm.core3D.Vector3D;
import vmm.surface.parametric.WeierstrassMinimalSurface;

public class SchwarzHsurface
extends WeierstrassMinimalSurface {
    private RealParamAnimateable aa = new RealParamAnimateable("vmm.surface.parametric.SchwarzHsurface.aa", 0.538, 0.05, 0.95);
    private double gbranch;
    private double a3;
    private double scale;
    private Vector3D trans;
    private Vector3D transY;
    private Vector3D transZ;
    private Vector3D surf_1;
    private Vector3D surf_2;
    private Vector3D surf_3;
    private Vector3D norm_3;
    private GridTransformMatrix Msym;
    protected double AFPold = 0.0;

    public SchwarzHsurface() {
        this.addParameter(this.aa);
        this.aa.setMaximumValueForInput(0.99);
        this.aa.setMinimumValueForInput(0.01);
        this.setDefaultOrientation(0);
        this.setDefaultViewUp(new Vector3D(-0.03, 0.87, 0.49));
        this.setDefaultViewpoint(new Vector3D(11.0, -24.0, 42.0));
        this.setDefaultWindow(-4.0, 4.0, -3.5, 3.1);
        this.uPatchCount.setValueAndDefault(18);
        this.vPatchCount.setValueAndDefault(12);
        this.umin.reset(0.005);
        this.umax.reset(0.9995);
        this.vmin.reset(0.0);
        this.vmax.reset(2.0);
        this.removeParameter(this.vmin);
        this.removeParameter(this.vmax);
        this.removeParameter(this.umin);
        this.removeParameter(this.umax);
        this.iFirstInHelper = false;
        this.iBeginMiddleInHelper = true;
        this.wantsToSeeDomain = false;
        this.wantsToSeeGaussImage = false;
        if (this.wantsToSeeGaussImage) {
            this.wantsToSeeDomain = true;
        }
        if (this.wantsToSeeDomain) {
            this.setDefaultViewUp(new Vector3D(0.0, 0.0, 1.0));
            this.setDefaultViewpoint(new Vector3D(0.0, 0.0, 40.0));
        }
        this.multipleCopyOptions = new int[]{2};
        this.canShowConjugateSurface = true;
    }

    public View getDefaultView() {
        WeierstrassMinimalSurface.WMSView wMSView = new WeierstrassMinimalSurface.WMSView(this);
        wMSView.setGridSpacing(12);
        float f = 0.2f;
        wMSView.getLightSettings().setAmbientLight(new Color(f, f, f));
        wMSView.getLightSettings().setSpecularExponent(100);
        wMSView.getLightSettings().setSpecularRatio(0.8f);
        return wMSView;
    }

    public void parameterChanged(Parameter parameter, Object object, Object object2) {
        boolean bl;
        super.parameterChanged(parameter, object, object2);
        this.AFP = this.afp.getValue();
        boolean bl2 = bl = parameter == this.afp && (this.AFP == 0.0 || this.AFPold == 0.0);
        if (parameter != this.afp || bl) {
            this.needsValueArray = true;
        }
        this.AFPold = this.AFP;
    }

    protected void createData() {
        block12: {
            GridTransformMatrix gridTransformMatrix;
            GridTransformMatrix gridTransformMatrix2;
            GridTransformMatrix gridTransformMatrix3;
            GridTransformMatrix[] gridTransformMatrixArray;
            block13: {
                int n;
                super.createData();
                this.computePeriodData();
                this.data.discardGridTransforms();
                gridTransformMatrixArray = new GridTransformMatrix[64];
                gridTransformMatrixArray[0] = new GridTransformMatrix();
                gridTransformMatrix3 = new GridTransformMatrix().scale(1.0, 1.0, -1.0);
                gridTransformMatrix2 = new GridTransformMatrix().scale(-1.0, 1.0, -1.0).reverse();
                gridTransformMatrix = new GridTransformMatrix().rotateZ(120.0);
                if (this.wantsToSeeDomain) break block12;
                if (this.flag0 && !this.inAssociateMorph) break block13;
                for (n = 0; n < 2; ++n) {
                    gridTransformMatrixArray[1 + n] = new GridTransformMatrix(gridTransformMatrixArray[n]).leftMultiplyBy(gridTransformMatrix);
                    this.data.addGridTransform(gridTransformMatrixArray[1 + n]);
                }
                for (n = 0; n < 3; ++n) {
                    gridTransformMatrixArray[3 + n] = new GridTransformMatrix(gridTransformMatrixArray[n]).scale(-1.0, -1.0, -1.0).reverse();
                    this.data.addGridTransform(gridTransformMatrixArray[3 + n]);
                }
                gridTransformMatrixArray[6] = new GridTransformMatrix(gridTransformMatrixArray[0]).scale(-1.0, -1.0, -1.0).reverse().translate(this.surf_1);
                this.data.addGridTransform(gridTransformMatrixArray[6]);
                gridTransformMatrixArray[7] = new GridTransformMatrix(gridTransformMatrixArray[4]).scale(-1.0, -1.0, -1.0).reverse().translate(this.surf_1);
                this.data.addGridTransform(gridTransformMatrixArray[7]);
                for (n = 0; n < 4; ++n) {
                    gridTransformMatrixArray[8 + n] = new GridTransformMatrix(gridTransformMatrixArray[6 + n]).leftMultiplyBy(gridTransformMatrix);
                    this.data.addGridTransform(gridTransformMatrixArray[8 + n]);
                }
                for (n = 0; n < 6; ++n) {
                    gridTransformMatrixArray[12 + n] = new GridTransformMatrix(gridTransformMatrixArray[6 + n]).scale(-1.0, -1.0, -1.0).reverse();
                    this.data.addGridTransform(gridTransformMatrixArray[12 + n]);
                }
                if (this.getNumberOfPieces() != 2) break block12;
                gridTransformMatrixArray[18] = new GridTransformMatrix(gridTransformMatrixArray[0]).leftMultiplyBy(this.Msym);
                this.data.addGridTransform(gridTransformMatrixArray[18]);
                gridTransformMatrixArray[19] = new GridTransformMatrix(gridTransformMatrixArray[7]).leftMultiplyBy(this.Msym);
                this.data.addGridTransform(gridTransformMatrixArray[19]);
                for (n = 0; n < 4; ++n) {
                    gridTransformMatrixArray[20 + n] = new GridTransformMatrix(gridTransformMatrixArray[18 + n]).leftMultiplyBy(gridTransformMatrix);
                    this.data.addGridTransform(gridTransformMatrixArray[20 + n]);
                }
                for (n = 0; n < 6; ++n) {
                    gridTransformMatrixArray[24 + n] = new GridTransformMatrix(gridTransformMatrixArray[18 + n]).scale(-1.0, -1.0, -1.0).reverse();
                    this.data.addGridTransform(gridTransformMatrixArray[24 + n]);
                }
                break block12;
            }
            if (this.flag0) {
                int n;
                gridTransformMatrixArray[1] = new GridTransformMatrix(gridTransformMatrixArray[0]).leftMultiplyBy(gridTransformMatrix);
                this.data.addGridTransform(gridTransformMatrixArray[1]);
                gridTransformMatrixArray[2] = new GridTransformMatrix(gridTransformMatrixArray[1]).leftMultiplyBy(gridTransformMatrix);
                this.data.addGridTransform(gridTransformMatrixArray[2]);
                for (n = 0; n < 3; ++n) {
                    gridTransformMatrixArray[3 + n] = new GridTransformMatrix(gridTransformMatrixArray[n]).leftMultiplyBy(gridTransformMatrix3).translate(this.transZ);
                    this.data.addGridTransform(gridTransformMatrixArray[3 + n]);
                }
                for (n = 0; n < 6; ++n) {
                    gridTransformMatrixArray[6 + n] = new GridTransformMatrix(gridTransformMatrixArray[n]).leftMultiplyBy(gridTransformMatrix2).translate(this.transY);
                    this.data.addGridTransform(gridTransformMatrixArray[6 + n]);
                }
                for (n = 0; n < 6; ++n) {
                    gridTransformMatrixArray[12 + n] = new GridTransformMatrix(gridTransformMatrixArray[6 + n]).leftMultiplyBy(gridTransformMatrix);
                    this.data.addGridTransform(gridTransformMatrixArray[12 + n]);
                }
                if (this.getNumberOfPieces() == 2) {
                    for (n = 0; n < 6; ++n) {
                        gridTransformMatrixArray[18 + n] = new GridTransformMatrix(gridTransformMatrixArray[12 + n]).leftMultiplyBy(gridTransformMatrix);
                        this.data.addGridTransform(gridTransformMatrixArray[18 + n]);
                    }
                }
            }
        }
    }

    public static double paramRescaleEnd(double d) {
        double d2 = Math.sin(1.5707963267948966 * d);
        return d2;
    }

    public static double paramRescaleStart(double d) {
        double d2 = 1.0 - Math.cos(1.5707963267948966 * d);
        return d2;
    }

    public static double paramRescaleBoth(double d) {
        double d2 = (1.0 - Math.cos(1.5707963267948966 * d)) / 2.0;
        return d2;
    }

    protected Complex domainGrid(double d, double d2) {
        double d3 = 4.8828125E-4;
        double d4 = 0.0;
        double d5 = 0.0;
        if (d <= 0.6666666666666666) {
            d5 = this.gbranch * SchwarzHsurface.paramRescaleBoth(3.0 * d);
        } else if (d <= 1.0) {
            d5 = this.gbranch + (1.0 - this.gbranch) * SchwarzHsurface.paramRescaleStart(3.0 * d - 2.0);
        }
        d4 = 2.0943951023931953 * SchwarzHsurface.paramRescaleBoth(d2);
        if (Math.abs(d - 0.6666666666666666) < d3) {
            if (d2 <= 2.0 * d3) {
                d4 = 2.0943951023931953 * SchwarzHsurface.paramRescaleBoth(d3 - 0.5 * (d3 - d2));
            } else if (2.0 - d2 <= 2.0 * d3) {
                d4 = 2.0943951023931953 * SchwarzHsurface.paramRescaleBoth(2.0 - d3 + 0.5 * (d3 - (2.0 - d2)));
            }
        }
        Complex complex = new Complex(d5 * Math.cos(d4), d5 * Math.sin(d4));
        if (this.wantsToSeeGaussImage) {
            complex = this.mu(complex);
        }
        return complex;
    }

    protected Complex gauss(Complex complex) {
        return new Complex(complex);
    }

    protected Complex mu(Complex complex) {
        Complex complex2 = new Complex(complex.integerPower(3));
        Complex complex3 = complex2.inverse();
        Complex complex4 = complex2.plus(complex3);
        complex4.re = -complex4.re + this.a3;
        complex4.im = -complex4.im;
        complex4.assignInvert();
        Complex complex5 = complex4.squareRootNearer(ONE_C);
        return complex5;
    }

    protected Complex hPrime(Complex complex) {
        Complex complex2 = this.mu(complex);
        complex2.assignDivide(complex);
        complex2.assignTimes(this.scale);
        return complex2;
    }

    protected void redoConstants() {
        super.redoConstants();
        this.gbranch = this.aa.getValue();
        this.a3 = this.gbranch * this.gbranch * this.gbranch;
        this.a3 += 1.0 / this.a3;
        this.scale = Math.sqrt(0.5 / this.gbranch);
    }

    protected ComplexVector3D getCenter() {
        double d = 0.5 / Math.sin(0.2617993877991494);
        Complex complex = new Complex(d * Math.cos(1.3089969389957472), d * Math.sin(1.3089969389957472));
        ComplexVector3D complexVector3D = new ComplexVector3D(this.helperToMinimal(this.helperArray[0][0]));
        ComplexVector3D complexVector3D2 = new ComplexVector3D(this.helperToMinimal(this.helperArray[0][(int)Math.floor(this.vcount / 2)]));
        ComplexVector3D complexVector3D3 = complexVector3D2.minus(complexVector3D);
        complexVector3D3.assignTimes(complex);
        complexVector3D3.assignPlus(complexVector3D);
        complexVector3D3.z.re = 0.0;
        ComplexVector3D complexVector3D4 = new ComplexVector3D(this.minimalToHelper(complexVector3D3));
        if (this.flag0 && !this.inAssociateMorph) {
            double d2 = this.AFP;
            complexVector3D = new ComplexVector3D(this.helperToMinimal(this.helperArray[(int)Math.floor((double)this.ucount * 2.0 / 3.0)][0]));
            complexVector3D2 = new ComplexVector3D(this.helperToMinimal(this.helperArray[(int)Math.floor((double)this.ucount * 2.0 / 3.0)][this.vcount - 1]));
            this.AFP = 0.0;
            this.surf_1 = this.surfacePoint(0.5, 0.0);
            Vector3D vector3D = this.surfacePoint(0.75, 0.0);
            this.surf_1.y = vector3D.y;
            this.AFP = 1.5707963267948966;
            vector3D = this.surfacePoint(0.75, 0.0);
            complexVector3D.x.re = this.surf_1.x;
            complexVector3D.y.re = this.surf_1.y;
            complexVector3D.z.re = this.surf_1.z;
            complexVector3D.z.im = vector3D.z;
            this.helperArray[(int)Math.floor((double)((double)this.ucount * 2.0 / 3.0))][0] = this.minimalToHelper(complexVector3D);
            this.surf_1.assignMinus(complexVector3D3.re());
            this.surf_1.z = 0.0;
            this.surf_2 = new Vector3D(0.5 * Math.sqrt(3.0) * this.surf_1.y, 0.5 * this.surf_1.y, 0.0);
            complexVector3D2.x.re = this.surf_2.x + complexVector3D3.x.re;
            complexVector3D2.y.re = this.surf_2.y + complexVector3D3.y.re;
            complexVector3D2.z.re = this.surf_2.z;
            complexVector3D2.z.im = -vector3D.z;
            this.helperArray[(int)Math.floor((double)((double)this.ucount * 2.0 / 3.0))][this.vcount - 1] = this.minimalToHelper(complexVector3D2);
            this.trans = this.surf_1.plus(this.surf_2).times(0.6666666666666666);
            complexVector3D3.x.re += this.trans.x;
            complexVector3D3.y.re += this.trans.y;
            complexVector3D3.z.re += this.trans.z;
            complexVector3D4 = this.minimalToHelper(complexVector3D3);
            this.AFP = d2;
        }
        return complexVector3D4;
    }

    public void computePeriodData() {
        ComplexVector3D complexVector3D = this.helperToMinimal(this.getCenter());
        this.surf_1 = this.surfacePoint(0.5, 0.0);
        this.surf_1.assignMinus(complexVector3D.re());
        this.transY = new Vector3D(2.0 * this.surf_1.x, 0.0, 0.0);
        this.surf_3 = this.surfacePoint(1.0, 1.0);
        this.surf_3.assignMinus(complexVector3D.re());
        this.transZ = new Vector3D(0.0, 0.0, 2.0 * this.surf_3.z);
        this.surf_1 = this.surfacePoint(0.6666666666666666, 0.0);
        this.surf_1.assignTimes(2.0);
        this.norm_3 = this.surfaceNormal(1.0, 1.0);
        double d = this.norm_3.dot(this.surf_3);
        this.trans = new Vector3D(this.surf_3.x - d * this.norm_3.x, this.surf_3.y - d * this.norm_3.y, this.surf_3.z - d * this.norm_3.z);
        this.trans.assignTimes(2.0);
        double d2 = Math.cos(2.0943951023931953);
        double d3 = Math.sin(2.0943951023931953);
        this.Msym = GridTransformMatrix.SetGridTransformMatrix(d2, d3, 0.0, this.trans.x, d3, -d2, 0.0, this.trans.y, 0.0, 0.0, -1.0, this.trans.z, true);
    }
}

