/*
 * Decompiled with CFR 0.152.
 */
package vmm.surface.parametric;

import java.awt.Color;
import vmm.core.Complex;
import vmm.core.View;
import vmm.core3D.ComplexVector3D;
import vmm.core3D.GridTransformMatrix;
import vmm.core3D.Vector3D;
import vmm.surface.parametric.WeierstrassMinimalSurface;

public class SchoenGyroid
extends WeierstrassMinimalSurface {
    private double Phi1;
    private double Phi2;
    private double rp1;
    private double RP2;
    private double r1_;
    private double R2_;
    private double scale;
    private Vector3D trans;
    private Vector3D transX;
    private Vector3D transY;
    private Vector3D transZ;
    private Vector3D N_6;
    private Vector3D N_2;
    private Vector3D N5_6;
    private Vector3D surf_6;
    private Vector3D surf_2;
    private Vector3D surf5_6;
    private Vector3D trans_6;
    private Vector3D trans_2;
    private Vector3D trans5_6;
    private GridTransformMatrix m_6;
    private GridTransformMatrix m_2;
    private GridTransformMatrix m5_6;

    public SchoenGyroid() {
        this.setDefaultOrientation(0);
        this.setDefaultViewUp(new Vector3D(-0.01, 0.69, 0.72));
        this.setDefaultViewpoint(new Vector3D(-25.0, -32.0, 29.0));
        this.setDefaultWindow(-3.0, 3.0, -2.8, 2.2);
        this.uPatchCount.setValueAndDefault(12);
        this.vPatchCount.setValueAndDefault(12);
        this.umin.reset(0.005);
        this.umax.reset(0.997);
        this.vmin.reset(0.0);
        this.vmax.reset(1.0);
        this.removeParameter(this.vmin);
        this.removeParameter(this.vmax);
        this.removeParameter(this.umin);
        this.removeParameter(this.umax);
        this.afp.setValue(0.9074490379894117);
        this.iFirstInHelper = false;
        this.wantsToSeeDomain = false;
        this.wantsToSeeGaussImage = false;
        if (this.wantsToSeeGaussImage) {
            this.wantsToSeeDomain = true;
        }
        if (this.wantsToSeeDomain) {
            this.setDefaultViewUp(new Vector3D(0.0, 0.0, 1.0));
            this.setDefaultViewpoint(new Vector3D(0.0, 0.0, 40.0));
        }
        this.multipleCopyOptions = new int[]{2};
    }

    public View getDefaultView() {
        WeierstrassMinimalSurface.WMSView wMSView = new WeierstrassMinimalSurface.WMSView(this);
        wMSView.setGridSpacing(12);
        float f = 0.25f;
        wMSView.getLightSettings().setAmbientLight(new Color(f, f, f));
        wMSView.getLightSettings().setSpecularExponent(95);
        wMSView.getLightSettings().setSpecularRatio(0.8f);
        return wMSView;
    }

    protected void createData() {
        super.createData();
        this.computePeriodData();
        this.data.discardGridTransforms();
        GridTransformMatrix[] gridTransformMatrixArray = new GridTransformMatrix[80];
        gridTransformMatrixArray[0] = new GridTransformMatrix();
        GridTransformMatrix gridTransformMatrix = new GridTransformMatrix();
        gridTransformMatrixArray[1] = new GridTransformMatrix().scale(-1.0, -1.0, -1.0).reverse();
        if (!this.wantsToSeeDomain) {
            this.data.addGridTransform(gridTransformMatrixArray[1]);
            gridTransformMatrix = new GridTransformMatrix().scale(-1.0, -1.0, 1.0);
            this.trans = new Vector3D(this.transZ.x, this.transZ.y, 0.0);
            gridTransformMatrixArray[2] = new GridTransformMatrix(gridTransformMatrixArray[0]).leftMultiplyBy(gridTransformMatrix).translate(this.trans);
            gridTransformMatrixArray[3] = new GridTransformMatrix(gridTransformMatrixArray[1]).leftMultiplyBy(gridTransformMatrix).translate(this.trans);
            this.data.addGridTransform(gridTransformMatrixArray[2]);
            this.data.addGridTransform(gridTransformMatrixArray[3]);
            this.trans = new Vector3D(-this.transZ.x, -this.transZ.y, 0.0);
            gridTransformMatrixArray[4] = new GridTransformMatrix(gridTransformMatrixArray[0]).leftMultiplyBy(gridTransformMatrix).translate(this.trans);
            gridTransformMatrixArray[5] = new GridTransformMatrix(gridTransformMatrixArray[1]).leftMultiplyBy(gridTransformMatrix).translate(this.trans);
            this.data.addGridTransform(gridTransformMatrixArray[4]);
            this.data.addGridTransform(gridTransformMatrixArray[5]);
            gridTransformMatrix = new GridTransformMatrix().scale(-1.0, 1.0, -1.0);
            this.trans = new Vector3D(this.transY.x, 0.0, this.transY.z);
            gridTransformMatrixArray[6] = new GridTransformMatrix(gridTransformMatrixArray[0]).leftMultiplyBy(gridTransformMatrix).translate(this.trans);
            gridTransformMatrixArray[7] = new GridTransformMatrix(gridTransformMatrixArray[1]).leftMultiplyBy(gridTransformMatrix).translate(this.trans);
            this.data.addGridTransform(gridTransformMatrixArray[6]);
            this.data.addGridTransform(gridTransformMatrixArray[7]);
            this.trans = new Vector3D(-this.transY.x, 0.0, -this.transY.z);
            gridTransformMatrixArray[8] = new GridTransformMatrix(gridTransformMatrixArray[0]).leftMultiplyBy(gridTransformMatrix).translate(this.trans);
            gridTransformMatrixArray[9] = new GridTransformMatrix(gridTransformMatrixArray[1]).leftMultiplyBy(gridTransformMatrix).translate(this.trans);
            this.data.addGridTransform(gridTransformMatrixArray[8]);
            this.data.addGridTransform(gridTransformMatrixArray[9]);
            gridTransformMatrix = new GridTransformMatrix().scale(1.0, -1.0, -1.0);
            this.trans = new Vector3D(0.0, this.transX.y, this.transX.z);
            gridTransformMatrixArray[10] = new GridTransformMatrix(gridTransformMatrixArray[0]).leftMultiplyBy(gridTransformMatrix).translate(this.trans);
            gridTransformMatrixArray[11] = new GridTransformMatrix(gridTransformMatrixArray[1]).leftMultiplyBy(gridTransformMatrix).translate(this.trans);
            this.data.addGridTransform(gridTransformMatrixArray[10]);
            this.data.addGridTransform(gridTransformMatrixArray[11]);
            this.trans = new Vector3D(0.0, -this.transX.y, -this.transX.z);
            gridTransformMatrixArray[12] = new GridTransformMatrix(gridTransformMatrixArray[0]).leftMultiplyBy(gridTransformMatrix).translate(this.trans);
            gridTransformMatrixArray[13] = new GridTransformMatrix(gridTransformMatrixArray[1]).leftMultiplyBy(gridTransformMatrix).translate(this.trans);
            this.data.addGridTransform(gridTransformMatrixArray[12]);
            this.data.addGridTransform(gridTransformMatrixArray[13]);
            gridTransformMatrixArray[14] = new GridTransformMatrix(gridTransformMatrixArray[0]).leftMultiplyBy(this.m_6).translate(this.trans_6);
            gridTransformMatrixArray[15] = new GridTransformMatrix(gridTransformMatrixArray[1]).leftMultiplyBy(this.m_6).translate(this.trans_6);
            this.data.addGridTransform(gridTransformMatrixArray[14]);
            this.data.addGridTransform(gridTransformMatrixArray[15]);
            this.trans = new Vector3D(this.trans_6.negated());
            gridTransformMatrixArray[16] = new GridTransformMatrix(gridTransformMatrixArray[0]).leftMultiplyBy(this.m_6).translate(this.trans);
            gridTransformMatrixArray[17] = new GridTransformMatrix(gridTransformMatrixArray[1]).leftMultiplyBy(this.m_6).translate(this.trans);
            this.data.addGridTransform(gridTransformMatrixArray[16]);
            this.data.addGridTransform(gridTransformMatrixArray[17]);
            gridTransformMatrixArray[18] = new GridTransformMatrix(gridTransformMatrixArray[0]).leftMultiplyBy(this.m_2).translate(this.trans_2);
            gridTransformMatrixArray[19] = new GridTransformMatrix(gridTransformMatrixArray[1]).leftMultiplyBy(this.m_2).translate(this.trans_2);
            this.data.addGridTransform(gridTransformMatrixArray[18]);
            this.data.addGridTransform(gridTransformMatrixArray[19]);
            this.trans = new Vector3D(this.trans_2.negated());
            gridTransformMatrixArray[20] = new GridTransformMatrix(gridTransformMatrixArray[0]).leftMultiplyBy(this.m_2).translate(this.trans);
            gridTransformMatrixArray[21] = new GridTransformMatrix(gridTransformMatrixArray[1]).leftMultiplyBy(this.m_2).translate(this.trans);
            this.data.addGridTransform(gridTransformMatrixArray[20]);
            this.data.addGridTransform(gridTransformMatrixArray[21]);
            gridTransformMatrixArray[22] = new GridTransformMatrix(gridTransformMatrixArray[0]).leftMultiplyBy(this.m5_6).translate(this.trans5_6);
            gridTransformMatrixArray[23] = new GridTransformMatrix(gridTransformMatrixArray[1]).leftMultiplyBy(this.m5_6).translate(this.trans5_6);
            this.data.addGridTransform(gridTransformMatrixArray[22]);
            this.data.addGridTransform(gridTransformMatrixArray[23]);
            this.trans = new Vector3D(this.trans5_6.negated());
            gridTransformMatrixArray[24] = new GridTransformMatrix(gridTransformMatrixArray[0]).leftMultiplyBy(this.m5_6).translate(this.trans);
            gridTransformMatrixArray[25] = new GridTransformMatrix(gridTransformMatrixArray[1]).leftMultiplyBy(this.m5_6).translate(this.trans);
            this.data.addGridTransform(gridTransformMatrixArray[24]);
            this.data.addGridTransform(gridTransformMatrixArray[25]);
            if (this.getNumberOfPieces() == 2) {
                this.trans = new Vector3D(this.trans_2.negated());
                gridTransformMatrixArray[26] = new GridTransformMatrix(gridTransformMatrixArray[12]).leftMultiplyBy(this.m_2).translate(this.trans);
                gridTransformMatrixArray[27] = new GridTransformMatrix(gridTransformMatrixArray[13]).leftMultiplyBy(this.m_2).translate(this.trans);
                this.data.addGridTransform(gridTransformMatrixArray[26]);
                this.data.addGridTransform(gridTransformMatrixArray[27]);
                gridTransformMatrixArray[28] = new GridTransformMatrix(gridTransformMatrixArray[2]).leftMultiplyBy(this.m_6).translate(this.trans_6);
                gridTransformMatrixArray[29] = new GridTransformMatrix(gridTransformMatrixArray[3]).leftMultiplyBy(this.m_6).translate(this.trans_6);
                this.data.addGridTransform(gridTransformMatrixArray[28]);
                this.data.addGridTransform(gridTransformMatrixArray[29]);
                gridTransformMatrixArray[30] = new GridTransformMatrix(gridTransformMatrixArray[6]).leftMultiplyBy(this.m5_6).translate(this.trans5_6);
                gridTransformMatrixArray[31] = new GridTransformMatrix(gridTransformMatrixArray[7]).leftMultiplyBy(this.m5_6).translate(this.trans5_6);
                this.data.addGridTransform(gridTransformMatrixArray[30]);
                this.data.addGridTransform(gridTransformMatrixArray[31]);
                gridTransformMatrixArray[32] = new GridTransformMatrix(gridTransformMatrixArray[6]).leftMultiplyBy(this.m_6).translate(this.trans_6);
                gridTransformMatrixArray[33] = new GridTransformMatrix(gridTransformMatrixArray[7]).leftMultiplyBy(this.m_6).translate(this.trans_6);
                this.data.addGridTransform(gridTransformMatrixArray[32]);
                this.data.addGridTransform(gridTransformMatrixArray[33]);
                gridTransformMatrixArray[34] = new GridTransformMatrix(gridTransformMatrixArray[4]).leftMultiplyBy(this.m_2).translate(this.trans_2);
                gridTransformMatrixArray[35] = new GridTransformMatrix(gridTransformMatrixArray[5]).leftMultiplyBy(this.m_2).translate(this.trans_2);
                this.data.addGridTransform(gridTransformMatrixArray[34]);
                this.data.addGridTransform(gridTransformMatrixArray[35]);
            }
            if (!this.inAssociateMorph) {
                // empty if block
            }
        }
    }

    public static double paramRescale(double d) {
        double d2 = Math.sin(1.5707963267948966 * d);
        return d2 * d2;
    }

    protected Complex domainGrid(double d, double d2) {
        double d3 = 0.0;
        double d4 = Math.sin(1.5707963267948966 * d);
        if (d2 <= 0.3333333333333333) {
            d3 = -Math.PI + this.Phi1 * SchoenGyroid.paramRescale(3.0 * d2);
        } else if (d2 > 0.3333333333333333 && d2 <= 0.6666666666666666) {
            d3 = -Math.PI + this.Phi1 + (this.Phi2 - this.Phi1) * SchoenGyroid.paramRescale(3.0 * d2 - 1.0);
        } else if (d2 > 0.6666666666666666) {
            d3 = -Math.PI + this.Phi2 + (Math.PI - this.Phi2) * SchoenGyroid.paramRescale(3.0 * d2 - 2.0);
        }
        Complex complex = new Complex(d4 * Math.cos(d3), d4 * Math.sin(d3));
        if (this.wantsToSeeGaussImage) {
            complex = this.gauss(complex);
        }
        return complex;
    }

    protected Complex gauss(Complex complex) {
        Complex complex2 = complex.times(complex);
        Complex complex3 = new Complex(1.0 - complex2.re, -complex2.im);
        complex2.re = 1.0 + complex2.re;
        Complex complex4 = complex3.inverse().times(complex2);
        double d = -2.0 * complex4.im - this.r1_;
        complex4.im = 2.0 * complex4.re;
        complex4.re = d;
        Complex complex5 = complex4.times(-2.0 / (this.R2_ - this.r1_));
        complex5.re = -complex5.re - 1.0;
        complex5.im = -complex5.im;
        Complex complex6 = complex5.times(complex5);
        complex6.re -= 1.0;
        Complex complex7 = complex6.squareRootNearer(complex5).minus(complex5);
        return complex7.squareRootNearer(I1_C);
    }

    protected Complex hPrime(Complex complex) {
        Complex complex2 = complex.times(complex);
        complex2.re -= 1.0;
        Complex complex3 = this.gauss(complex);
        Complex complex4 = complex3.times(complex3);
        Complex complex5 = complex4.times(complex4);
        complex5.re -= 1.0;
        complex5.assignTimes(complex2);
        complex3 = complex5.inverse().times(complex4);
        complex3.assignTimes(this.scale);
        return complex3;
    }

    protected void redoConstants() {
        super.redoConstants();
        this.AFP = this.afp.getValue();
        this.Phi1 = 1.0471975511965976;
        this.Phi2 = 2.0943951023931953;
        this.rp1 = Math.tan(this.Phi1 / 2.0);
        this.RP2 = Math.tan(this.Phi2 / 2.0);
        this.r1_ = this.rp1 - 1.0 / this.rp1;
        this.R2_ = this.RP2 - 1.0 / this.RP2;
        this.scale = 1.0;
    }

    protected ComplexVector3D getCenter() {
        ComplexVector3D complexVector3D = new ComplexVector3D(this.helperArray[0][0]);
        complexVector3D = complexVector3D.plus(this.helperArray[0][this.vcount - 1]).times(0.5);
        return complexVector3D;
    }

    public void computePeriodData() {
        ComplexVector3D complexVector3D = new ComplexVector3D(this.helperToMinimal(this.helperArray[this.ucount - 1][(int)Math.floor(0.0)]));
        this.transZ = complexVector3D.re().times(2.0 * Math.cos(this.AFP)).plus(complexVector3D.im().times(2.0 * Math.sin(this.AFP)));
        complexVector3D = new ComplexVector3D(this.helperToMinimal(this.helperArray[this.ucount - 1][(int)Math.floor((double)this.vcount * 1.0 / 3.0)]));
        this.transX = complexVector3D.re().times(2.0 * Math.cos(this.AFP)).plus(complexVector3D.im().times(2.0 * Math.sin(this.AFP)));
        complexVector3D = new ComplexVector3D(this.helperToMinimal(this.helperArray[this.ucount - 1][(int)Math.floor((double)this.vcount * 2.0 / 3.0)]));
        this.transY = complexVector3D.re().times(2.0 * Math.cos(this.AFP)).plus(complexVector3D.im().times(2.0 * Math.sin(this.AFP)));
        this.surf_6 = this.surfacePoint(this.umax.getValue(), 0.16666666666666666);
        this.N_6 = this.surfaceNormal(this.umax.getValue(), 0.16666666666666666);
        double d = this.surf_6.dot(this.N_6);
        this.trans_6 = this.surf_6.linComb(2.0, -2.0 * d, this.N_6);
        this.m_6 = GridTransformMatrix.SetGridTransformMatrix(0.0, 0.0, 1.0, 0.0, 0.0, 1.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, true);
        this.surf_2 = this.surfacePoint(this.umax.getValue(), 0.5);
        this.N_2 = this.surfaceNormal(this.umax.getValue(), 0.5);
        d = this.surf_2.dot(this.N_2);
        this.trans_2 = this.surf_2.linComb(2.0, -2.0 * d, this.N_2);
        this.m_2 = GridTransformMatrix.SetGridTransformMatrix(0.0, -1.0, 0.0, 0.0, -1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, true);
        this.surf5_6 = this.surfacePoint(this.umax.getValue(), 0.8333333333333334);
        this.N5_6 = this.surfaceNormal(this.umax.getValue(), 0.8333333333333334);
        d = this.surf5_6.dot(this.N5_6);
        this.trans5_6 = this.surf5_6.linComb(2.0, -2.0 * d, this.N5_6);
        this.m5_6 = GridTransformMatrix.SetGridTransformMatrix(1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 1.0, 0.0, 0.0, true);
    }
}

