/*
 * Decompiled with CFR 0.152.
 */
package vmm.surface.parametric;

import java.awt.Color;
import vmm.core.Complex;
import vmm.core.RealParamAnimateable;
import vmm.core.View;
import vmm.core3D.ComplexVector3D;
import vmm.core3D.GridTransformMatrix;
import vmm.core3D.Vector3D;
import vmm.surface.parametric.WeierstrassMinimalSurface;

public class SchoenCLPsurface
extends WeierstrassMinimalSurface {
    private RealParamAnimateable aa = new RealParamAnimateable("vmm.surface.parametric.SchoenCLPsurface.aa", 0.6, 0.52, 0.98);
    private RealParamAnimateable bb = new RealParamAnimateable("vmm.surface.parametric.SchoenCLPsurface.bb", 0.2, 0.48, 0.02);
    private int um;
    private int vm;
    private double alpha;
    private double beta;
    private double c2a;
    private double c2b;
    private double coeff;
    private double coecc;
    private double scale;
    private Complex ccff;
    private Vector3D surf_1;
    private Vector3D surf_2;

    public SchoenCLPsurface() {
        this.addParameter(this.bb);
        this.bb.setMaximumValueForInput(0.95);
        this.bb.setMinimumValueForInput(0.02);
        this.addParameter(this.aa);
        this.aa.setMaximumValueForInput(0.99);
        this.aa.setMinimumValueForInput(0.05);
        this.setDefaultViewUp(new Vector3D(-0.57, 0.6, 0.58));
        this.setDefaultViewpoint(new Vector3D(15.0, -25.0, 40.0));
        this.setDefaultWindow(-5.0, 5.0, -4.0, 4.0);
        this.uPatchCount.setValueAndDefault(12);
        this.vPatchCount.setValueAndDefault(24);
        this.umin.reset(0.005);
        this.umax.reset(0.999);
        this.vmin.reset(-1.0);
        this.vmax.reset(1.0);
        this.removeParameter(this.vmin);
        this.removeParameter(this.vmax);
        this.removeParameter(this.umin);
        this.removeParameter(this.umax);
        this.iFirstInHelper = false;
        this.wantsToSeeDomain = false;
        this.wantsToSeeGaussImage = false;
        if (this.wantsToSeeGaussImage) {
            this.wantsToSeeDomain = true;
        }
        if (this.wantsToSeeDomain) {
            this.setDefaultViewUp(new Vector3D(0.0, 0.0, 1.0));
            this.setDefaultViewpoint(new Vector3D(0.0, 0.0, 40.0));
        }
        this.multipleCopyOptions = new int[]{2};
        this.canShowConjugateSurface = true;
    }

    public View getDefaultView() {
        WeierstrassMinimalSurface.WMSView wMSView = new WeierstrassMinimalSurface.WMSView(this);
        wMSView.setGridSpacing(12);
        this.setDefaultOrientation(1);
        float f = 0.2f;
        wMSView.getLightSettings().setAmbientLight(new Color(f, f, f));
        wMSView.getLightSettings().setSpecularExponent(100);
        wMSView.getLightSettings().setSpecularRatio(0.8f);
        return wMSView;
    }

    protected void createData() {
        super.createData();
        this.computePeriodData();
        this.data.discardGridTransforms();
        GridTransformMatrix[] gridTransformMatrixArray = new GridTransformMatrix[64];
        gridTransformMatrixArray[0] = new GridTransformMatrix();
        GridTransformMatrix gridTransformMatrix = new GridTransformMatrix();
        gridTransformMatrixArray[1] = new GridTransformMatrix().scale(-1.0, -1.0, 1.0);
        if (!this.wantsToSeeDomain) {
            int n;
            this.data.addGridTransform(gridTransformMatrixArray[1]);
            for (n = 0; n < 2; ++n) {
                gridTransformMatrixArray[2 + n] = new GridTransformMatrix(gridTransformMatrixArray[n]).scale(-1.0, -1.0, -1.0).reverse().translate(this.surf_1);
                this.data.addGridTransform(gridTransformMatrixArray[2 + n]);
            }
            if (!this.inAssociateMorph && (this.flag0 || this.flag05)) {
                gridTransformMatrix = new GridTransformMatrix().scale(-1.0, -1.0, 1.0).reverse().translate(this.surf_1.x, this.surf_1.y, 0.0);
                for (n = 0; n < 4; ++n) {
                    gridTransformMatrixArray[4 + n] = new GridTransformMatrix(gridTransformMatrixArray[n]).leftMultiplyBy(gridTransformMatrix);
                    this.data.addGridTransform(gridTransformMatrixArray[4 + n]);
                }
                gridTransformMatrix = new GridTransformMatrix().scale(-1.0, -1.0, 1.0);
                for (n = 0; n < 4; ++n) {
                    gridTransformMatrixArray[8 + n] = new GridTransformMatrix(gridTransformMatrixArray[2 + n]).leftMultiplyBy(gridTransformMatrix);
                    this.data.addGridTransform(gridTransformMatrixArray[8 + n]);
                }
                if (this.getNumberOfPieces() == 2) {
                    if (this.flag0) {
                        gridTransformMatrix = new GridTransformMatrix().scale(1.0, 1.0, -1.0).translate(0.0, 0.0, this.surf_2.z);
                    } else if (this.flag05) {
                        gridTransformMatrix = new GridTransformMatrix().scale(1.0, 1.0, -1.0).translate(this.surf_2.x, this.surf_2.y, this.surf_2.z);
                    }
                    for (n = 0; n < 12; ++n) {
                        gridTransformMatrixArray[12 + n] = new GridTransformMatrix(gridTransformMatrixArray[n]).leftMultiplyBy(gridTransformMatrix);
                        this.data.addGridTransform(gridTransformMatrixArray[12 + n]);
                    }
                }
            }
        }
    }

    public static double paramRescaleEnd(double d) {
        double d2 = Math.sin(1.5707963267948966 * d);
        return d2;
    }

    public static double paramRescaleStart(double d) {
        double d2 = 1.0 - Math.cos(1.5707963267948966 * d);
        return d2;
    }

    public static double paramRescaleBoth(double d) {
        double d2 = (1.0 - Math.cos(Math.PI * d)) / 2.0;
        return d2;
    }

    public static double paramRescaleMiddle(double d) {
        double d2 = (1.0 + d * Math.abs(d)) / 2.0;
        return d2;
    }

    protected Complex domainGrid(double d, double d2) {
        boolean bl = false;
        double d3 = 0.0;
        double d4 = SchoenCLPsurface.paramRescaleEnd(d);
        if (d2 < 0.0) {
            d2 = -d2;
            bl = true;
        }
        if (d2 <= 0.3333333333333333) {
            d3 = this.beta * SchoenCLPsurface.paramRescaleEnd(3.0 * d2);
        } else if (d2 <= 0.6666666666666666) {
            d3 = this.beta - (this.beta - this.alpha) * SchoenCLPsurface.paramRescaleBoth(3.0 * d2 - 1.0);
        } else if (d2 <= 1.0) {
            d3 = this.alpha + (1.5707963267948966 - this.alpha) * SchoenCLPsurface.paramRescaleStart(3.0 * d2 - 2.0);
        }
        Complex complex = new Complex(d4 * Math.cos(d3), d4 * Math.sin(d3));
        if (this.wantsToSeeGaussImage) {
            complex = this.mu(complex);
        }
        if (bl) {
            complex = complex.conj();
        }
        return complex.conj();
    }

    protected Complex gauss(Complex complex) {
        return complex;
    }

    protected Complex mu(Complex complex) {
        boolean bl = false;
        if (complex.im < 0.0) {
            complex = complex.conj();
            bl = true;
        }
        Complex complex2 = complex.times(complex);
        Complex complex3 = complex2.inverse();
        complex3.assignPlus(complex2);
        Complex complex4 = complex3.minus(2.0 * this.c2a);
        complex3.re -= 2.0 * this.c2b;
        complex3.assignTimes(complex4);
        complex4 = complex3.squareRootNearer(I_C);
        if (bl) {
            complex4 = complex4.conj();
        }
        return complex4;
    }

    protected Complex hPrime(Complex complex) {
        Complex complex2 = this.mu(complex);
        complex2.assignTimes(complex);
        complex2.assignInvert();
        return complex2;
    }

    protected void redoConstants() {
        super.redoConstants();
        this.alpha = 1.5707963267948966 * this.aa.getValue();
        this.beta = 1.5707963267948966 * this.bb.getValue();
        this.c2a = Math.cos(2.0 * this.alpha);
        this.c2b = Math.cos(2.0 * this.beta);
        this.coeff = 0.5 * (this.c2a - this.c2b);
        this.ccff = new Complex(0.0, -2.0 * this.coeff);
        this.coecc = this.c2a + this.c2b;
        this.scale = 1.0;
    }

    protected ComplexVector3D getCenter() {
        ComplexVector3D complexVector3D = new ComplexVector3D(this.helperArray[0][0]);
        complexVector3D = complexVector3D.plus(this.helperArray[0][this.vcount - 1]).times(0.5);
        return complexVector3D;
    }

    public void computePeriodData() {
        this.surf_1 = this.surfacePoint(this.umax.getValue(), 0.3333333333333333).times(2.0);
        this.surf_2 = this.surfacePoint(this.umax.getValue(), 0.6666666666666666).times(2.0);
    }
}

