/*
 * Decompiled with CFR 0.152.
 */
package vmm.surface.parametric;

import vmm.core.Complex;
import vmm.core.IntegerParam;
import vmm.core.RealParamAnimateable;
import vmm.core3D.ComplexVector3D;
import vmm.core3D.GridTransformMatrix;
import vmm.core3D.Vector3D;
import vmm.surface.parametric.WeierstrassMinimalSurface;

public class Scherk_Weierstrass
extends WeierstrassMinimalSurface {
    private IntegerParam exponent = new IntegerParam("vmm.surface.parametric.Scherk_Weierstrass.MainEx", 2);
    private RealParamAnimateable aa = new RealParamAnimateable("vmm.surface.parametric.Scherk_Weierstrass.aa", 0.0, 0.0, 0.9);
    private int ex;
    private int j0;
    private double AA;
    private double r1;
    private double rex;
    private double re_e;
    private double mob;

    public Scherk_Weierstrass() {
        this.setFramesForMorphing(12);
        this.afp.reset(0.0, 0.0, 0.0);
        this.addParameter(this.aa);
        this.addParameter(this.exponent);
        this.setDefaultViewpoint(new Vector3D(-7.0, 17.0, 47.0));
        this.setDefaultWindow(-4.0, 4.0, -3.0, 3.0);
        this.uPatchCount.setValueAndDefault(12);
        this.vPatchCount.setValueAndDefault(12);
        this.umin.reset(-3.5);
        this.umax.reset(0.0);
        this.vmin.reset(-1.5707963267948966);
        this.vmax.reset(1.5707963267948966);
        this.wantsToSeeDomain = false;
        if (this.wantsToSeeDomain) {
            this.setDefaultViewUp(new Vector3D(0.0, 0.0, 1.0));
            this.setDefaultViewpoint(new Vector3D(0.0, 0.0, 40.0));
        }
        this.removeParameter(this.umax);
        this.removeParameter(this.vmax);
        this.removeParameter(this.vmin);
        this.umin.setMaximumValueForInput(-0.05);
        this.iFirstInHelper = false;
        this.multipleCopyOptions = new int[]{2};
        this.canShowConjugateSurface = true;
    }

    protected void createData() {
        block16: {
            int n;
            super.createData();
            this.data.discardGridTransforms();
            if (this.inAssociateMorph || !this.flag0 && !this.flag05 || this.wantsToSeeDomain) break block16;
            GridTransformMatrix[] gridTransformMatrixArray = new GridTransformMatrix[this.ex * 8];
            gridTransformMatrixArray[0] = new GridTransformMatrix();
            if (this.flag0) {
                gridTransformMatrixArray[1] = new GridTransformMatrix().scale(1.0, -1.0, 1.0);
                this.data.addGridTransform(gridTransformMatrixArray[1]);
            } else if (this.flag05) {
                gridTransformMatrixArray[1] = new GridTransformMatrix().scale(-1.0, 1.0, -1.0).reverse();
                this.data.addGridTransform(gridTransformMatrixArray[1]);
            }
            for (n = 1; n < this.ex; ++n) {
                gridTransformMatrixArray[2 * n] = new GridTransformMatrix(gridTransformMatrixArray[2 * n - 2]).rotateZ(360.0 / (double)this.ex);
                this.data.addGridTransform(gridTransformMatrixArray[2 * n]);
                gridTransformMatrixArray[2 * n + 1] = new GridTransformMatrix(gridTransformMatrixArray[2 * n - 1]).rotateZ(360.0 / (double)this.ex);
                this.data.addGridTransform(gridTransformMatrixArray[2 * n + 1]);
            }
            if (this.flag0) {
                for (n = 0; n < 2 * this.ex; ++n) {
                    gridTransformMatrixArray[2 * this.ex + n] = new GridTransformMatrix(gridTransformMatrixArray[n]).scale(1.0, 1.0, -1.0);
                    this.data.addGridTransform(gridTransformMatrixArray[2 * this.ex + n]);
                }
            }
            if (this.flag05) {
                for (n = 0; n < 2 * this.ex; ++n) {
                    gridTransformMatrixArray[2 * this.ex + n] = new GridTransformMatrix(gridTransformMatrixArray[n]).scale(-1.0, -1.0, 1.0).reverse().translate(this.halfPeriod.im().times(2.0));
                    this.data.addGridTransform(gridTransformMatrixArray[2 * this.ex + n]);
                }
            }
            if (this.getNumberOfPieces() == 2) {
                if (this.flag0) {
                    for (n = 0; n < 4 * this.ex; ++n) {
                        gridTransformMatrixArray[4 * this.ex + n] = new GridTransformMatrix(gridTransformMatrixArray[n]);
                        this.data.addGridTransform(gridTransformMatrixArray[4 * this.ex + n].translate(this.halfPeriod.re().times(2.0)));
                    }
                }
                if (this.flag05) {
                    if ((double)this.ex / 2.0 - Math.floor((double)this.ex / 2.0) == 0.0) {
                        for (n = 0; n < 4 * this.ex; ++n) {
                            gridTransformMatrixArray[4 * this.ex + n] = new GridTransformMatrix(gridTransformMatrixArray[n]).rotateZ(180.0);
                            this.data.addGridTransform(gridTransformMatrixArray[4 * this.ex + n].translate(this.halfPeriod.im().times(-2.0)));
                        }
                    } else {
                        for (n = 0; n < 4 * this.ex; n += 2) {
                            gridTransformMatrixArray[4 * this.ex + n] = new GridTransformMatrix(gridTransformMatrixArray[n + 2 * this.ex]).rotateZ(720.0 / (double)this.ex);
                            this.data.addGridTransform(gridTransformMatrixArray[4 * this.ex + n]);
                            gridTransformMatrixArray[4 * this.ex + n + 1] = new GridTransformMatrix(gridTransformMatrixArray[n + 1 + 2 * this.ex]).rotateZ(-720.0 / (double)this.ex);
                            this.data.addGridTransform(gridTransformMatrixArray[4 * this.ex + n + 1]);
                        }
                    }
                }
            }
        }
    }

    protected Complex domainGrid(double d, double d2) {
        double d3 = Math.exp(d);
        Complex complex = new Complex(d3 * Math.cos(d2), d3 * Math.sin(d2));
        Complex complex2 = new Complex(-complex.re + 1.0, -complex.im);
        Complex complex3 = new Complex(complex.im, -complex.re - 1.0);
        complex2.assignDivide(complex3);
        complex2 = complex2.mobius1_1(this.mob);
        if (complex2.r() < 1.0E-6) {
            complex.re = -7.0;
        } else {
            complex = complex2.logNearer(I1_C);
        }
        complex.re = Math.max(complex.re, -7.0);
        complex.assignTimes(1.0 / (double)this.ex);
        complex = complex.exponential();
        return complex;
    }

    protected void zeroIndex() {
        double d = 10.0;
        for (int i = 0; i < this.vcount; ++i) {
            Complex complex = this.domainGrid(this.umax.getValue(), this.vmin.getValue() + (double)i * this.dv);
            double d2 = complex.r();
            if (!(d2 <= d) || !(Math.abs(complex.im) < 1.0E-5)) continue;
            d = d2;
            this.j0 = i;
        }
    }

    protected Complex gauss(Complex complex) {
        return new Complex(complex.integerPower(this.ex - 1));
    }

    protected Complex hPrime(Complex complex) {
        Complex complex2 = complex.integerPower(this.ex);
        Complex complex3 = complex2.minus(4.0 * this.re_e);
        complex3.assignTimes(complex2);
        complex3.re += 1.0;
        complex3 = this.gauss(complex).dividedBy(complex3);
        complex3.assignTimes(this.r1);
        return complex3;
    }

    protected void redoConstants() {
        super.redoConstants();
        this.AA = Math.sqrt(Math.abs(this.aa.getValue()));
        this.ex = this.exponent.getValue();
        this.rex = 1.0;
        for (int i = 1; i < this.ex + 1; ++i) {
            this.rex *= this.AA;
        }
        this.re_e = this.rex / (this.rex * this.rex + 1.0);
        double d = 2.0 * this.re_e;
        double d2 = Math.sqrt(1.0 - d * d);
        this.mob = Math.sqrt((1.0 - d2) / (1.0 - d) / 2.0);
        this.r1 = 1.3 * Math.sqrt((double)this.ex / 2.0) * Math.exp(2.0 / (double)this.ex * Math.log(1.0 - this.AA * this.AA * this.AA * this.AA));
        this.zeroIndex();
        System.out.println(this.j0);
    }

    protected ComplexVector3D getCenter() {
        Complex complex = this.domainGrid(this.umax.getValue(), this.vmin.getValue() + (double)this.j0 * this.dv);
        System.out.println(complex.re);
        Complex complex2 = new Complex(0.005, 0.0);
        ComplexVector3D complexVector3D = new ComplexVector3D(this.helperArray[this.ucount - 1][this.j0]);
        complexVector3D = complexVector3D.plus(this.ComplexVectorIntegrator(complex, complex2, this.ex));
        ComplexVector3D complexVector3D2 = this.ComplexVectorIntegrator(complex2, complex2.times(I_C), this.ex);
        complexVector3D2 = complexVector3D2.plus(this.ComplexVectorIntegrator(complex2.times(I_C), complex2.times(-1.0), this.ex));
        complexVector3D = complexVector3D.plus(complexVector3D2.times(0.5));
        if (!this.inAssociateMorph && !this.wantsToSeeDomain) {
            complexVector3D.z = new Complex(this.helperArray[this.ucount - 1][0].z);
        }
        return complexVector3D;
    }

    public void computeHalfPeriod() {
        this.halfPeriod = new ComplexVector3D(this.helperArray[this.ucount - 1][0]);
        ComplexVector3D complexVector3D = new ComplexVector3D(this.helperArray[this.ucount - 1][this.vcount - 1]);
        this.halfPeriod = new ComplexVector3D(this.halfPeriod.y.minus(this.halfPeriod.x), this.halfPeriod.y.plus(this.halfPeriod.x).times(I_C), this.halfPeriod.z.times(2.0));
        complexVector3D = new ComplexVector3D(complexVector3D.y.minus(complexVector3D.x), complexVector3D.y.plus(complexVector3D.x).times(I_C), complexVector3D.z.times(2.0));
        this.halfPeriod.x.re = 0.0;
        this.halfPeriod.y.re = 0.0;
        this.halfPeriod.z.re = (this.halfPeriod.z.re - complexVector3D.z.re) / 2.0;
    }

    public Vector3D surfacePoint(double d, double d2) {
        int n = (int)Math.floor(0.25 + (d - this.umin.getValue()) / this.du);
        int n2 = (int)Math.floor(0.25 + (d2 - this.vmin.getValue()) / this.dv);
        ComplexVector3D complexVector3D = new ComplexVector3D(this.helperArray[n][n2].plus(this.ComplexVectorOneStepIntegrator(this.domainGrid(this.umin.getValue() + (double)n * this.du, this.vmin.getValue() + (double)n2 * this.dv), this.domainGrid(d, d2))));
        ComplexVector3D complexVector3D2 = new ComplexVector3D(complexVector3D.y.minus(complexVector3D.x), complexVector3D.y.plus(complexVector3D.x).times(I_C), complexVector3D.z);
        if (n == this.ucount - 1 && n2 == this.j0) {
            complexVector3D2 = new ComplexVector3D(ZERO_C, ZERO_C, complexVector3D2.z);
        }
        if (this.AFP == 0.0) {
            if (this.wantsToSeeDomain) {
                return new Vector3D(complexVector3D2.z.re, complexVector3D2.z.im, 0.0);
            }
            return complexVector3D2.re();
        }
        return complexVector3D2.re().times(Math.cos(this.AFP)).plus(complexVector3D2.im().times(Math.sin(this.AFP)));
    }
}

