/*
 * Decompiled with CFR 0.152.
 */
package vmm.surface.parametric;

import vmm.core.RealParamAnimateable;
import vmm.core3D.Vector3D;
import vmm.surface.parametric.SurfaceParametric;

public class Scherk
extends SurfaceParametric {
    private RealParamAnimateable aa = new RealParamAnimateable("genericParam.aa", 1.0, 1.0, 1.0);

    public Scherk() {
        this.uPatchCount.setValueAndDefault(10);
        this.vPatchCount.setValueAndDefault(10);
        this.umin.reset("-pi/2 + 0.01");
        this.umax.reset("pi/2 - 0.01");
        this.vmin.reset("-pi/2 + 0.01");
        this.vmax.reset("pi/2 - 0.01");
        this.setDefaultViewpoint(new Vector3D(10.0, 10.0, 10.0));
        this.setDefaultWindow(-5.0, 5.0, -5.0, 5.0);
        this.addParameter(this.aa);
    }

    public Vector3D surfacePoint(double d, double d2) {
        double d3 = this.aa.getValue();
        double d4 = d;
        double d5 = d2;
        double d6 = Math.log(Math.cos(d3 * d2) / Math.cos(d3 * d)) / d3;
        return new Vector3D(d4, d5, d6);
    }
}

