/*
 * Decompiled with CFR 0.152.
 */
package vmm.surface.parametric;

import java.awt.Color;
import vmm.core.Complex;
import vmm.core.Parameter;
import vmm.core.RealParamAnimateable;
import vmm.core.View;
import vmm.core3D.ComplexVector3D;
import vmm.core3D.GridTransformMatrix;
import vmm.core3D.Vector3D;
import vmm.surface.parametric.WeierstrassMinimalSurface;

public class Riemann
extends WeierstrassMinimalSurface {
    private RealParamAnimateable aa = new RealParamAnimateable("vmm.surface.parametric.Riemann.aa", 1.0, -2.0, 2.0);
    private int jP;
    private int um;
    private int vm;
    private double P;
    private double PL;
    private double r1;

    public Riemann() {
        this.addParameter(this.aa);
        this.setDefaultOrientation(0);
        this.setDefaultViewpoint(new Vector3D(50.0, -20.0, 1.0));
        this.setDefaultViewUp(new Vector3D(0.3, 0.85, 0.5));
        this.setDefaultWindow(-7.0, 7.7, -5.8, 6.3);
        this.uPatchCount.setValueAndDefault(12);
        this.vPatchCount.setValueAndDefault(24);
        this.umin.reset(0.0);
        this.umax.reset(Math.PI);
        this.vmax.reset(3.0);
        this.vmin.reset(-this.vmax.getValue());
        this.removeParameter(this.vmin);
        this.removeParameter(this.umax);
        this.removeParameter(this.umin);
        this.multipleCopyOptions = new int[]{2, 3};
        this.canShowConjugateSurface = true;
        this.wantsToSeeDomain = false;
        this.wantsToSeeGaussImage = false;
        if (this.wantsToSeeGaussImage) {
            this.wantsToSeeDomain = true;
        }
        if (this.wantsToSeeDomain) {
            this.setDefaultViewUp(new Vector3D(0.0, 0.0, 1.0));
            this.setDefaultViewpoint(new Vector3D(0.0, 0.0, 40.0));
        }
    }

    public View getDefaultView() {
        WeierstrassMinimalSurface.WMSView wMSView = new WeierstrassMinimalSurface.WMSView(this);
        wMSView.setGridSpacing(12);
        float f = 0.34f;
        wMSView.getLightSettings().setLight0(new Color(f, f, f));
        wMSView.getLightSettings().getDirectionalLight2().setItsColor(new Color(0.5f, 1.0f, 0.0f));
        wMSView.getLightSettings().getDirectionalLight2().setItsDirection(new Vector3D(0.66, -0.34, -0.66));
        wMSView.getLightSettings().getDirectionalLight3().setItsDirection(new Vector3D(0.57, 0.2, -0.8));
        wMSView.getLightSettings().setSpecularExponent(55);
        wMSView.getLightSettings().setSpecularRatio(0.5f);
        return wMSView;
    }

    public void parameterChanged(Parameter parameter, Object object, Object object2) {
        super.parameterChanged(parameter, object, object2);
        if (parameter == this.vmax) {
            this.vmin.reset(-this.vmax.getValue());
        }
    }

    protected void createData() {
        super.createData();
        this.data.discardGridTransforms();
        GridTransformMatrix[] gridTransformMatrixArray = new GridTransformMatrix[12];
        gridTransformMatrixArray[0] = new GridTransformMatrix();
        if (!this.inAssociateMorph && !this.wantsToSeeDomain) {
            int n;
            gridTransformMatrixArray[1] = new GridTransformMatrix().scale(-1.0, 1.0, -1.0).setReverseSurfaceOrientation(true);
            this.data.addGridTransform(gridTransformMatrixArray[1]);
            gridTransformMatrixArray[2] = new GridTransformMatrix().scale(1.0, -1.0, 1.0);
            this.data.addGridTransform(gridTransformMatrixArray[2]);
            gridTransformMatrixArray[3] = new GridTransformMatrix().scale(-1.0, -1.0, -1.0).setReverseSurfaceOrientation(true);
            this.data.addGridTransform(gridTransformMatrixArray[3]);
            if (this.getNumberOfPieces() == 2 || this.getNumberOfPieces() == 3) {
                for (n = 0; n < 4; ++n) {
                    if (this.flag0) {
                        gridTransformMatrixArray[n + 4] = new GridTransformMatrix(gridTransformMatrixArray[n]).translate(2.0 * this.halfPeriod.x.re, 0.0, 2.0 * this.halfPeriod.z.re);
                    } else if (this.flag05) {
                        gridTransformMatrixArray[n + 4] = new GridTransformMatrix(gridTransformMatrixArray[n]).translate(2.0 * this.halfPeriod.x.im, 0.0, 2.0 * this.halfPeriod.z.im);
                    }
                    this.data.addGridTransform(gridTransformMatrixArray[n + 4]);
                }
            }
            if (this.getNumberOfPieces() == 3) {
                for (n = 0; n < 4; ++n) {
                    if (this.flag0) {
                        gridTransformMatrixArray[n + 8] = new GridTransformMatrix(gridTransformMatrixArray[n]).translate(-2.0 * this.halfPeriod.x.re, 0.0, -2.0 * this.halfPeriod.z.re);
                    } else if (this.flag05) {
                        gridTransformMatrixArray[n + 8] = new GridTransformMatrix(gridTransformMatrixArray[n]).translate(-2.0 * this.halfPeriod.x.im, 0.0, -2.0 * this.halfPeriod.z.im);
                    }
                    this.data.addGridTransform(gridTransformMatrixArray[n + 8]);
                }
            }
        }
    }

    protected Complex domainGrid(double d, double d2) {
        double d3 = 0.03125;
        double d4 = Math.exp(d2);
        double d5 = d;
        if (d < this.umin.getValue() + d3 && Math.abs(d2 - this.PL) < d3) {
            d5 = d + (d3 - Math.abs(d2 - this.PL)) * ((-d + d3 + this.umin.getValue()) / d3);
        } else if (d > this.umax.getValue() - d3 && Math.abs(d2 + this.PL) < d3) {
            d5 = d - (d3 - Math.abs(d2 + this.PL)) * ((d + d3 - this.umax.getValue()) / d3);
        }
        Complex complex = new Complex(d4 * Math.cos(d5), d4 * Math.sin(d5));
        if (this.wantsToSeeGaussImage) {
            complex = this.hPrime(complex);
        }
        return complex;
    }

    protected void p_Index() {
        this.jP = (int)Math.floor((this.PL - this.vmin.getValue()) / (this.vmax.getValue() - this.vmin.getValue()) * (double)(this.vcount - 1));
    }

    protected Complex gauss(Complex complex) {
        return new Complex(complex);
    }

    protected Complex hPrime(Complex complex) {
        double d = complex.re * complex.re + complex.im * complex.im;
        Complex complex2 = new Complex(complex.re / d - complex.re + this.P - 1.0 / this.P, -complex.im * (1.0 / d + 1.0));
        Complex complex3 = complex2.squareRootNearer(I2_C);
        complex3.assignTimes(complex);
        complex3.assignInvert();
        complex3.assignTimes(this.r1);
        return complex3;
    }

    protected void redoConstants() {
        super.redoConstants();
        this.PL = this.aa.getValue();
        this.P = Math.exp(this.PL);
        this.r1 = 0.5;
        this.p_Index();
        this.um = (int)Math.floor((double)(this.ucount - 1) / 2.0);
        this.vm = (int)Math.floor((double)(this.vcount - 1) / 2.0);
    }

    protected ComplexVector3D getCenter() {
        if (this.inAssociateMorph) {
            return new ComplexVector3D(this.helperArray[this.um][this.vm]);
        }
        if (this.wantsToSeeDomain) {
            return new ComplexVector3D(this.helperArray[0][0].plus(this.helperArray[this.ucount - 1][0]).times(0.5));
        }
        ComplexVector3D complexVector3D = new ComplexVector3D(this.helperToMinimal(this.helperArray[0][this.jP + 19]));
        ComplexVector3D complexVector3D2 = new ComplexVector3D(this.helperToMinimal(this.helperArray[0][this.jP - 19]));
        Vector3D vector3D = new Vector3D(complexVector3D.re());
        Vector3D vector3D2 = new Vector3D(complexVector3D.im());
        Vector3D vector3D3 = new Vector3D(complexVector3D2.re());
        Vector3D vector3D4 = new Vector3D(complexVector3D2.im());
        Vector3D vector3D5 = new Vector3D(vector3D.x, vector3D3.y, vector3D.z);
        Vector3D vector3D6 = new Vector3D(vector3D4.x, vector3D2.y, vector3D4.z);
        ComplexVector3D complexVector3D3 = new ComplexVector3D(vector3D5, vector3D6);
        complexVector3D3 = this.minimalToHelper(complexVector3D3);
        return complexVector3D3;
    }

    public void computeHalfPeriod() {
        this.halfPeriod = new ComplexVector3D(this.helperToMinimal(this.helperArray[this.um][this.vm].times(2.0)));
        this.halfPeriod.y = ZERO_C;
    }

    public Vector3D surfacePoint(double d, double d2) {
        ComplexVector3D complexVector3D;
        int n = (int)Math.floor(0.25 + (d - this.umin.getValue()) / this.du);
        int n2 = (int)Math.floor(0.25 + (d2 - this.vmin.getValue()) / this.dv);
        if (!this.inAssociateMorph && !this.wantsToSeeDomain && n == 0 && n2 == this.jP) {
            complexVector3D = new ComplexVector3D(ComplexVector3D.ORIGIN);
        } else if (!this.inAssociateMorph && !this.wantsToSeeDomain && n == this.ucount - 1 && n2 == this.vcount - 1 - this.jP) {
            complexVector3D = new ComplexVector3D(this.halfPeriod);
        } else {
            ComplexVector3D complexVector3D2 = new ComplexVector3D(this.helperArray[n][n2].plus(this.ComplexVectorOneStepIntegrator(this.domainGrid(this.umin.getValue() + (double)n * this.du, this.vmin.getValue() + (double)n2 * this.dv), this.domainGrid(d, d2))));
            complexVector3D = this.helperToMinimal(complexVector3D2);
            if (!this.inAssociateMorph && !this.wantsToSeeDomain) {
                if (this.flag0) {
                    if (n == 0 && n2 <= this.jP || n == this.ucount - 1 && n2 >= this.vcount - 1 - this.jP) {
                        complexVector3D.y.assign(ZERO_C);
                    }
                    if (n == 0 && n2 > this.jP) {
                        complexVector3D.assign(ZERO_C, complexVector3D.y, ZERO_C);
                    }
                    if (n == this.ucount - 1 && n2 < this.vcount - 1 - this.jP) {
                        complexVector3D.assign(this.halfPeriod.x, complexVector3D.y, this.halfPeriod.z);
                    }
                }
                if (this.flag05) {
                    if (n == 0 && n2 > this.jP || n == this.ucount - 1 && n2 < this.vcount - 1 - this.jP) {
                        complexVector3D.y.assign(ZERO_C);
                    }
                    if (n == 0 && n2 < this.jP) {
                        complexVector3D.assign(ZERO_C, complexVector3D.y, ZERO_C);
                    }
                }
            }
        }
        if (this.AFP == 0.0) {
            if (this.wantsToSeeDomain) {
                return new Vector3D(complexVector3D.z.re, complexVector3D.z.im, 0.0);
            }
            return complexVector3D.re();
        }
        return complexVector3D.re().times(Math.cos(this.AFP)).plus(complexVector3D.im().times(Math.sin(this.AFP)));
    }
}

