/*
 * Decompiled with CFR 0.152.
 */
package vmm.surface.parametric;

import vmm.core.RealParamAnimateable;
import vmm.core3D.Vector3D;
import vmm.surface.parametric.SurfaceParametric;

public class ParametricBreather
extends SurfaceParametric {
    private RealParamAnimateable aa = new RealParamAnimateable("genericParam.aa", 0.4, 0.8, 0.4);

    public ParametricBreather() {
        this.uPatchCount.setValueAndDefault(24);
        this.vPatchCount.setValueAndDefault(24);
        this.umin.reset(-13.4, -10.0, -13.4);
        this.umax.reset(13.4, 10.0, 13.4);
        this.vmin.reset("-37.2", "-3*pi", "-37.2");
        this.vmax.reset("37.2", "3*pi", "37.2");
        this.setDefaultViewpoint(new Vector3D(10.0, -10.0, 10.5));
        this.setDefaultWindow(-5.5, 5.5, -5.5, 5.5);
        this.setDefaultOrientation(2);
        this.addParameter(this.aa);
    }

    private static double sinh(double d) {
        return 0.5 * (Math.exp(d) - Math.exp(-d));
    }

    private static double cosh(double d) {
        return 0.5 * (Math.exp(d) + Math.exp(-d));
    }

    public Vector3D surfacePoint(double d, double d2) {
        double d3 = this.aa.getValue();
        double d4 = 1.0 - d3 * d3;
        double d5 = Math.sqrt(d4);
        double d6 = d5 * d5 * ParametricBreather.cosh(d3 * d) * ParametricBreather.cosh(d3 * d);
        double d7 = d3 * d3 * Math.sin(d5 * d2) * Math.sin(d5 * d2);
        double d8 = d3 * (d6 + d7);
        double d9 = -d + 2.0 * d4 * ParametricBreather.cosh(d3 * d) * ParametricBreather.sinh(d3 * d) / d8;
        double d10 = 2.0 * d5 * ParametricBreather.cosh(d3 * d) * (-(d5 * Math.cos(d2) * Math.cos(d5 * d2)) - Math.sin(d2) * Math.sin(d5 * d2)) / d8;
        double d11 = 2.0 * d5 * ParametricBreather.cosh(d3 * d) * (-(d5 * Math.sin(d2) * Math.cos(d5 * d2)) + Math.cos(d2) * Math.sin(d5 * d2)) / d8;
        return new Vector3D(d9, d10, d11);
    }
}

