/*
 * Decompiled with CFR 0.152.
 */
package vmm.surface.parametric;

import vmm.core.RealParamAnimateable;
import vmm.core3D.Vector3D;
import vmm.surface.parametric.SurfaceParametric;

public class Paraboloid
extends SurfaceParametric {
    private RealParamAnimateable xRadius = new RealParamAnimateable("vmm.surface.parametric.Paraboloid.xRadius", 1.0, 1.0, 1.5);
    private RealParamAnimateable yRadius = new RealParamAnimateable("vmm.surface.parametric.Paraboloid.yRadius", 1.0, 1.5, 0.5);
    private RealParamAnimateable height = new RealParamAnimateable("vmm.surface.parametric.Paraboloid.height", 2.5, 2.5, 2.5);

    public Paraboloid() {
        this.umin.reset(0.0);
        this.umax.reset("2 * pi");
        this.vmin.reset(0.0);
        this.vmax.reset(1.0);
        this.addParameter(this.height);
        this.addParameter(this.yRadius);
        this.addParameter(this.xRadius);
        this.setDefaultWindow(-2.0, 2.0, -2.0, 2.0);
        this.setDefaultViewpoint(new Vector3D(20.0, 3.0, 7.0));
    }

    public Vector3D surfacePoint(double d, double d2) {
        double d3 = this.xRadius.getValue() * d2 * Math.cos(d);
        double d4 = this.yRadius.getValue() * d2 * Math.sin(d);
        double d5 = this.height.getValue() * d2 * d2 - this.height.getValue() / 2.0;
        return new Vector3D(d3, d4, d5);
    }
}

