/*
 * Decompiled with CFR 0.152.
 */
package vmm.surface.parametric;

import vmm.core.RealParamAnimateable;
import vmm.core3D.Vector3D;
import vmm.surface.parametric.SurfaceParametric;

public class MonkeySaddle
extends SurfaceParametric {
    private RealParamAnimateable aa = new RealParamAnimateable("genericParam.aa", 1.0, 1.0, 1.0);
    private RealParamAnimateable bb = new RealParamAnimateable("genericParam.bb", 1.0, 1.0, 1.0);
    private RealParamAnimateable cc = new RealParamAnimateable("genericParam.cc", 0.35, 0.0, 0.35);

    public MonkeySaddle() {
        this.uPatchCount.setValueAndDefault(12);
        this.vPatchCount.setValueAndDefault(10);
        this.umin.reset(-1.5);
        this.umax.reset(1.5);
        this.vmin.reset(-1.5);
        this.vmax.reset(1.5);
        this.setDefaultViewpoint(new Vector3D(6.64, -13.0, 9.3));
        this.setDefaultWindow(-2.5, 2.5, -2.5, 2.5);
        this.addParameter(this.cc);
        this.addParameter(this.bb);
        this.addParameter(this.aa);
    }

    public Vector3D surfacePoint(double d, double d2) {
        double d3 = this.aa.getValue() * d2;
        double d4 = this.bb.getValue() * d;
        double d5 = this.cc.getValue() * (d * d * d - 3.0 * d * d2 * d2);
        return new Vector3D(d3, d4, d5);
    }
}

