/*
 * Decompiled with CFR 0.152.
 */
package vmm.surface.parametric;

import vmm.core.RealParamAnimateable;
import vmm.core3D.Vector3D;
import vmm.surface.parametric.SurfaceParametric;

public class MoebiusStrip
extends SurfaceParametric {
    private RealParamAnimateable aa = new RealParamAnimateable("genericParam.aa", 1.5, 1.5, 1.5);
    private RealParamAnimateable bb = new RealParamAnimateable("genericParam.bb", 1.0, 1.0, 1.0);

    public MoebiusStrip() {
        this.setDefaultViewpoint(new Vector3D(10.0, -10.0, 10.0));
        this.setDefaultWindow(-2.0, 2.0, -2.0, 2.0);
        this.umin.reset("-0.3");
        this.umax.reset("0.3");
        this.vmin.reset("0.0");
        this.vmax.reset("2*pi", "0.3", "2*pi");
        this.uPatchCount.setValueAndDefault(3);
        this.vPatchCount.setValueAndDefault(21);
        this.setDefaultOrientation(2);
        this.addParameter(this.aa);
        this.addParameter(this.bb);
    }

    private static double sin(double d) {
        return Math.sin(d);
    }

    private static double cos(double d) {
        return Math.cos(d);
    }

    public Vector3D surfacePoint(double d, double d2) {
        double d3 = this.aa.getValue();
        double d4 = Math.round(this.bb.getValue());
        return new Vector3D(d3 * (MoebiusStrip.cos(d2) + d * MoebiusStrip.cos(d4 * d2 / 2.0) * MoebiusStrip.cos(d2)), d3 * (MoebiusStrip.sin(d2) + d * MoebiusStrip.cos(d4 * d2 / 2.0) * MoebiusStrip.sin(d2)), d3 * d * MoebiusStrip.sin(d4 * d2 / 2.0));
    }
}

