/*
 * Decompiled with CFR 0.152.
 */
package vmm.surface.parametric;

import java.awt.event.ActionEvent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import vmm.actions.AbstractActionVMM;
import vmm.actions.ActionList;
import vmm.core.BasicAnimator;
import vmm.core.Complex;
import vmm.core.I18n;
import vmm.core.RealParamAnimateable;
import vmm.core.View;
import vmm.core3D.ComplexVector3D;
import vmm.core3D.GridTransformMatrix;
import vmm.core3D.Vector3D;
import vmm.surface.parametric.WeierstrassMinimalSurface;

public class LopezRosNoGo
extends WeierstrassMinimalSurface {
    private RealParamAnimateable pos = new RealParamAnimateable("vmm.surface.parametric.LopezRosNoGo.pos", 3.0, 7.0, 1.01);
    private RealParamAnimateable lrp = new RealParamAnimateable("vmm.surface.parametric.LopezRosNoGo.lrp", 1.06, 1.0, 1.0);
    boolean in2ndMorph = false;
    private double LRP;
    private double POS;
    private double r1;
    private Complex q1;

    public LopezRosNoGo() {
        this.setFramesForMorphing(20);
        this.afp.reset(0.0, 0.0, 0.0);
        this.addParameter(this.pos);
        this.pos.setMinimumValueForInput(0.1);
        this.pos.setMaximumValueForInput(10.0);
        this.addParameter(this.lrp);
        this.setDefaultViewpoint(new Vector3D(25.0, 50.0, 50.0));
        this.setDefaultViewpoint(new Vector3D(-62.0, -40.0, 10.0));
        this.setDefaultWindow(-4.0, 4.0, -3.0, 3.0);
        this.uPatchCount.setValueAndDefault(24);
        this.vPatchCount.setValueAndDefault(12);
        this.umin.reset(-1.7, -1.7, -1.7);
        this.umax.reset(2.0, 2.6, 1.6);
        this.vmin.reset(-0.9999);
        this.vmax.reset(0.9999);
        this.removeParameter(this.vmax);
        this.removeParameter(this.vmin);
        this.wantsToSeeDomain = false;
        if (this.wantsToSeeDomain) {
            this.setDefaultViewUp(new Vector3D(0.0, 0.0, 1.0));
            this.setDefaultViewpoint(new Vector3D(0.0, 0.0, 40.0));
        }
        this.canShowConjugateSurface = false;
    }

    protected void createData() {
        super.createData();
        this.data.discardGridTransforms();
        GridTransformMatrix gridTransformMatrix = new GridTransformMatrix();
        if (!this.inAssociateMorph && !this.wantsToSeeDomain) {
            if (this.flag0) {
                gridTransformMatrix = new GridTransformMatrix().scale(-1.0, 1.0, -1.0).reverse();
            } else if (this.flag05) {
                // empty if block
            }
            this.data.addGridTransform(gridTransformMatrix);
        }
    }

    protected Complex domainGrid(double d, double d2) {
        double d3 = Math.exp(d * Math.abs(d));
        double d4 = Math.PI * Math.sin(d2 * Math.PI / 2.0);
        Complex complex = new Complex(d3 * Math.cos(d4) + 1.0, d3 * Math.sin(d4));
        Complex complex2 = complex.squareRootNearer(ONE_C);
        return complex2.times(this.POS);
    }

    protected double closingLRP(double d) {
        return 1.0 / Math.sqrt((3.0 * d * d - 2.0) * d * d - 1.0);
    }

    protected Complex gauss(Complex complex) {
        Complex complex2 = complex.times(complex);
        complex2.re = this.LRP * (complex2.re - 1.0);
        complex2.im = this.LRP * complex2.im;
        return complex2;
    }

    protected Complex hPrime(Complex complex) {
        Complex complex2 = complex.times(complex);
        complex2.re = this.r1 * (complex2.re - this.POS * this.POS);
        complex2.im = this.r1 * complex2.im;
        complex2.assignTimes(complex2);
        return this.gauss(complex).dividedBy(complex2);
    }

    protected void redoConstants() {
        super.redoConstants();
        this.POS = this.pos.getValue() / 10.0;
        this.POS = Math.exp(this.POS * this.POS);
        this.r1 = Math.sqrt(8.0 / this.pos.getValue());
        double d = this.closingLRP(this.POS);
        this.LRP = this.lrp.getValue();
        if (!this.in2ndMorph) {
            this.LRP = d;
        } else {
            this.r1 = this.r1 * Math.sqrt(this.pos.getValue() / 3.5) * 1.1;
        }
    }

    protected ComplexVector3D getCenter() {
        if (this.inAssociateMorph || this.wantsToSeeDomain) {
            int n = (int)Math.floor((double)(this.ucount - 1) / 2.0);
            int n2 = (int)Math.floor((double)(this.vcount - 1) / 2.0);
            return new ComplexVector3D(this.helperArray[n][n2]);
        }
        ComplexVector3D complexVector3D = new ComplexVector3D(this.helperArray[this.ucount - 1][this.vcount - 1]);
        return complexVector3D.plus(this.helperArray[this.ucount - 1][0]).times(0.5);
    }

    public Vector3D surfacePoint(double d, double d2) {
        int n = (int)Math.floor(0.25 + (d - this.umin.getValue()) / this.du);
        int n2 = (int)Math.floor(0.25 + (d2 - this.vmin.getValue()) / this.dv);
        Complex complex = this.domainGrid(d, d2);
        ComplexVector3D complexVector3D = new ComplexVector3D(this.helperArray[n][n2].plus(this.ComplexVectorOneStepIntegrator(this.domainGrid(this.umin.getValue() + (double)n * this.du, this.vmin.getValue() + (double)n2 * this.dv), complex)));
        ComplexVector3D complexVector3D2 = this.helperToMinimal(complexVector3D);
        if (complex.r() < 1.01 * this.distFrom0 && !this.inAssociateMorph && !this.wantsToSeeDomain) {
            complexVector3D2.x = new Complex(ZERO_C);
            complexVector3D2.z = new Complex(ZERO_C);
            complexVector3D2.y = new Complex(this.helperArray[0][n2].y.plus(this.helperArray[0][n2].x).times(I_C));
        }
        if (this.wantsToSeeDomain) {
            return new Vector3D(complexVector3D2.z.re, complexVector3D2.z.im, 0.0);
        }
        if (this.AFP == 0.0) {
            return complexVector3D2.re();
        }
        return complexVector3D2.re().times(Math.cos(this.AFP)).plus(complexVector3D2.im().times(Math.sin(this.AFP)));
    }

    public ActionList getAdditionalAnimationsForView(final View view) {
        ActionList actionList = super.getAdditionalAnimationsForView(view);
        actionList.add(new AbstractActionVMM(I18n.tr("vmm.surface.parametric.LopezRosNoGo.PeriodOpenMorph")){

            public void actionPerformed(ActionEvent actionEvent) {
                BasicAnimator basicAnimator = new BasicAnimator();
                basicAnimator.setLooping(2);
                basicAnimator.setUseFilmstrip(LopezRosNoGo.this.getUseFilmstripForMorphing());
                basicAnimator.setFrames(LopezRosNoGo.this.getFramesForMorphing());
                basicAnimator.setMillisecondsPerFrame(200);
                basicAnimator.addWithCustomLimits(LopezRosNoGo.this.pos, 3.5, 1.0);
                basicAnimator.addWithCustomValue(LopezRosNoGo.this.lrp, 1.05);
                basicAnimator.addChangeListener(new ChangeListener(){

                    public void stateChanged(ChangeEvent changeEvent) {
                        LopezRosNoGo.this.in2ndMorph = ((BasicAnimator)changeEvent.getSource()).isRunning();
                    }
                });
                view.getDisplay().installAnimation(basicAnimator);
            }
        });
        return actionList;
    }
}

