/*
 * Decompiled with CFR 0.152.
 */
package vmm.surface.parametric;

import vmm.core.RealParamAnimateable;
import vmm.core3D.Vector3D;
import vmm.surface.parametric.SurfaceParametric;

public class LissajousSurface
extends SurfaceParametric {
    private RealParamAnimateable aa = new RealParamAnimateable("genericParam.aa", "1", "1", "1");
    private RealParamAnimateable bb = new RealParamAnimateable("genericParam.bb", "1", "1", "1");
    private RealParamAnimateable cc = new RealParamAnimateable("genericParam.cc", "1", "1", "1");
    private RealParamAnimateable dd = new RealParamAnimateable("genericParam.dd", "0.0", "0.0", "pi/2");

    public LissajousSurface() {
        this.uPatchCount.setValueAndDefault(18);
        this.vPatchCount.setValueAndDefault(18);
        this.umin.reset("-pi");
        this.umax.reset("pi");
        this.vmin.reset("-pi");
        this.vmax.reset("pi");
        this.setDefaultViewpoint(new Vector3D(-4.25, -0.67, 8.7));
        this.setDefaultWindow(-2.0, 2.0, -2.0, 2.0);
        this.addParameter(this.aa);
        this.addParameter(this.bb);
        this.addParameter(this.cc);
        this.addParameter(this.dd);
    }

    private static double sin(double d) {
        return Math.sin(d);
    }

    public Vector3D surfacePoint(double d, double d2) {
        double d3 = Math.round(this.aa.getValue());
        double d4 = Math.round(this.bb.getValue());
        double d5 = Math.round(this.cc.getValue());
        double d6 = this.dd.getValue();
        double d7 = d3 * LissajousSurface.sin(d);
        double d8 = d4 * LissajousSurface.sin(d2);
        double d9 = d5 * LissajousSurface.sin(d6 - d3 * d - d4 * d2);
        return new Vector3D(d7, d8, d9);
    }
}

