/*
 * Decompiled with CFR 0.152.
 */
package vmm.surface.parametric;

import java.awt.Color;
import java.awt.event.ActionEvent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import vmm.actions.AbstractActionVMM;
import vmm.actions.ActionList;
import vmm.core.BasicAnimator;
import vmm.core.Complex;
import vmm.core.I18n;
import vmm.core.Parameter;
import vmm.core.RealParamAnimateable;
import vmm.core.View;
import vmm.core3D.ComplexVector3D;
import vmm.core3D.GridTransformMatrix;
import vmm.core3D.Vector3D;
import vmm.surface.parametric.WeierstrassMinimalSurface;

public class LidinoidHfamily
extends WeierstrassMinimalSurface {
    private RealParamAnimateable aa = new RealParamAnimateable("vmm.surface.parametric.LidinoidHfamily.aa", 0.5353, 0.3, 0.8);
    private RealParamAnimateable bb = new RealParamAnimateable("vmm.surface.parametric.LidinoidHfamily.bb", 0.7139918, 0.5, 0.9);
    private boolean adaptAFP = true;
    private double gbranch;
    private double a3;
    private double scale;
    private Vector3D trans;
    private Vector3D transY;
    private Vector3D transZ;
    private Vector3D surf_1;
    private Vector3D surf_2;
    private Vector3D surf_3;
    private Vector3D norm_3;
    private GridTransformMatrix Msym;

    public LidinoidHfamily() {
        this.addParameter(this.bb);
        this.bb.setMaximumValueForInput(4.0);
        this.bb.setMinimumValueForInput(0.0);
        this.addParameter(this.aa);
        this.aa.setMaximumValueForInput(0.99);
        this.aa.setMinimumValueForInput(0.01);
        this.setDefaultOrientation(0);
        this.setDefaultViewUp(new Vector3D(-0.52, 0.84, -0.15));
        this.setDefaultViewpoint(new Vector3D(-13.0, 0.33, 47.4));
        this.setDefaultWindow(-4.0, 4.0, -3.5, 3.1);
        this.uPatchCount.setValueAndDefault(18);
        this.vPatchCount.setValueAndDefault(12);
        this.umin.reset(0.005);
        this.umax.reset(0.9995);
        this.vmin.reset(0.0);
        this.vmax.reset(2.0);
        this.removeParameter(this.vmin);
        this.removeParameter(this.vmax);
        this.removeParameter(this.umin);
        this.removeParameter(this.umax);
        this.afp.reset(1.1215356968016763);
        this.iFirstInHelper = false;
        this.iBeginMiddleInHelper = true;
        this.wantsToSeeDomain = false;
        this.wantsToSeeGaussImage = false;
        if (this.wantsToSeeGaussImage) {
            this.wantsToSeeDomain = true;
        }
        if (this.wantsToSeeDomain) {
            this.setDefaultViewUp(new Vector3D(0.0, 0.0, 1.0));
            this.setDefaultViewpoint(new Vector3D(0.0, 0.0, 40.0));
        }
        this.multipleCopyOptions = new int[]{2, 3};
    }

    public View getDefaultView() {
        WeierstrassMinimalSurface.WMSView wMSView = new WeierstrassMinimalSurface.WMSView(this);
        wMSView.setGridSpacing(12);
        float f = 0.2f;
        wMSView.getLightSettings().setAmbientLight(new Color(f, f, f));
        wMSView.getLightSettings().setSpecularExponent(100);
        wMSView.getLightSettings().setSpecularRatio(0.8f);
        return wMSView;
    }

    public void parameterChanged(Parameter parameter, Object object, Object object2) {
        super.parameterChanged(parameter, object, object2);
        if (parameter == this.afp) {
            // empty if block
        }
        this.adaptAFP = false;
        if (this.needsValueArray) {
            this.adaptAFP = true;
        }
    }

    protected void createData() {
        super.createData();
        this.data.discardGridTransforms();
        this.computePeriodData();
        GridTransformMatrix[] gridTransformMatrixArray = new GridTransformMatrix[64];
        gridTransformMatrixArray[0] = new GridTransformMatrix();
        GridTransformMatrix gridTransformMatrix = new GridTransformMatrix().rotateZ(120.0);
        if (!this.wantsToSeeDomain) {
            int n;
            for (n = 0; n < 2; ++n) {
                gridTransformMatrixArray[1 + n] = new GridTransformMatrix(gridTransformMatrixArray[n]).leftMultiplyBy(gridTransformMatrix);
                this.data.addGridTransform(gridTransformMatrixArray[1 + n]);
            }
            for (n = 0; n < 3; ++n) {
                gridTransformMatrixArray[3 + n] = new GridTransformMatrix(gridTransformMatrixArray[n]).scale(-1.0, -1.0, -1.0).reverse();
                this.data.addGridTransform(gridTransformMatrixArray[3 + n]);
            }
            gridTransformMatrixArray[6] = new GridTransformMatrix(gridTransformMatrixArray[0]).scale(-1.0, -1.0, -1.0).reverse().translate(this.surf_1);
            this.data.addGridTransform(gridTransformMatrixArray[6]);
            gridTransformMatrixArray[7] = new GridTransformMatrix(gridTransformMatrixArray[4]).scale(-1.0, -1.0, -1.0).reverse().translate(this.surf_1);
            this.data.addGridTransform(gridTransformMatrixArray[7]);
            for (n = 0; n < 4; ++n) {
                gridTransformMatrixArray[8 + n] = new GridTransformMatrix(gridTransformMatrixArray[6 + n]).leftMultiplyBy(gridTransformMatrix);
                this.data.addGridTransform(gridTransformMatrixArray[8 + n]);
            }
            for (n = 0; n < 6; ++n) {
                gridTransformMatrixArray[12 + n] = new GridTransformMatrix(gridTransformMatrixArray[6 + n]).scale(-1.0, -1.0, -1.0).reverse();
                this.data.addGridTransform(gridTransformMatrixArray[12 + n]);
            }
            if (this.getNumberOfPieces() == 2 || this.getNumberOfPieces() == 3) {
                gridTransformMatrixArray[18] = new GridTransformMatrix(gridTransformMatrixArray[0]).leftMultiplyBy(this.Msym);
                this.data.addGridTransform(gridTransformMatrixArray[18]);
                gridTransformMatrixArray[19] = new GridTransformMatrix(gridTransformMatrixArray[7]).leftMultiplyBy(this.Msym);
                this.data.addGridTransform(gridTransformMatrixArray[19]);
                for (n = 0; n < 4; ++n) {
                    gridTransformMatrixArray[20 + n] = new GridTransformMatrix(gridTransformMatrixArray[18 + n]).leftMultiplyBy(gridTransformMatrix);
                    this.data.addGridTransform(gridTransformMatrixArray[20 + n]);
                }
                for (n = 0; n < 6; ++n) {
                    gridTransformMatrixArray[24 + n] = new GridTransformMatrix(gridTransformMatrixArray[18 + n]).scale(-1.0, -1.0, -1.0).reverse();
                    this.data.addGridTransform(gridTransformMatrixArray[24 + n]);
                }
            }
            if (this.getNumberOfPieces() == 3 && !this.inAssociateMorph) {
                gridTransformMatrixArray[30] = new GridTransformMatrix(gridTransformMatrixArray[6]).leftMultiplyBy(this.Msym);
                this.data.addGridTransform(gridTransformMatrixArray[30]);
                gridTransformMatrixArray[31] = new GridTransformMatrix(gridTransformMatrixArray[4]).leftMultiplyBy(this.Msym);
                this.data.addGridTransform(gridTransformMatrixArray[31]);
                for (n = 0; n < 4; ++n) {
                    gridTransformMatrixArray[32 + n] = new GridTransformMatrix(gridTransformMatrixArray[30 + n]).leftMultiplyBy(gridTransformMatrix);
                    this.data.addGridTransform(gridTransformMatrixArray[32 + n]);
                }
            }
        }
    }

    public static double paramRescaleEnd(double d) {
        double d2 = Math.sin(1.5707963267948966 * d);
        return d2;
    }

    public static double paramRescaleStart(double d) {
        double d2 = 1.0 - Math.cos(1.5707963267948966 * d);
        return d2;
    }

    public static double paramRescaleBoth(double d) {
        double d2 = (1.0 - Math.cos(1.5707963267948966 * d)) / 2.0;
        return d2;
    }

    protected Complex domainGrid(double d, double d2) {
        double d3 = 4.8828125E-4;
        double d4 = 0.0;
        double d5 = 0.0;
        if (d <= 0.6666666666666666) {
            d5 = this.gbranch * LidinoidHfamily.paramRescaleBoth(3.0 * d);
        } else if (d <= 1.0) {
            d5 = this.gbranch + (1.0 - this.gbranch) * LidinoidHfamily.paramRescaleStart(3.0 * d - 2.0);
        }
        d4 = 2.0943951023931953 * LidinoidHfamily.paramRescaleBoth(d2);
        if (Math.abs(d - 0.6666666666666666) < d3) {
            if (d2 <= 2.0 * d3) {
                d4 = 2.0943951023931953 * LidinoidHfamily.paramRescaleBoth(d3 - 0.5 * (d3 - d2));
            } else if (2.0 - d2 <= 2.0 * d3) {
                d4 = 2.0943951023931953 * LidinoidHfamily.paramRescaleBoth(2.0 - d3 + 0.5 * (d3 - (2.0 - d2)));
            }
        }
        Complex complex = new Complex(d5 * Math.cos(d4), d5 * Math.sin(d4));
        if (this.wantsToSeeGaussImage) {
            complex = this.mu(complex);
        }
        return complex;
    }

    protected Complex gauss(Complex complex) {
        return new Complex(complex);
    }

    protected Complex mu(Complex complex) {
        Complex complex2 = new Complex(complex.integerPower(3));
        Complex complex3 = complex2.inverse();
        Complex complex4 = complex2.plus(complex3);
        complex4.re = -complex4.re + this.a3;
        complex4.im = -complex4.im;
        complex4.assignInvert();
        Complex complex5 = complex4.squareRootNearer(ONE_C);
        return complex5;
    }

    protected Complex hPrime(Complex complex) {
        Complex complex2 = this.mu(complex);
        complex2.assignDivide(complex);
        complex2.assignTimes(this.scale);
        return complex2;
    }

    protected void redoConstants() {
        super.redoConstants();
        this.gbranch = this.aa.getValue();
        this.a3 = this.gbranch * this.gbranch * this.gbranch;
        this.a3 += 1.0 / this.a3;
        this.scale = Math.sqrt(0.5 / this.gbranch);
    }

    protected double findGoodAFP(double d) {
        double d2 = 1.119977781004761;
        double d3 = 0.0;
        if (d <= 0.5353) {
            d3 = (d - 0.3) / 0.2353;
            d2 = 1.1215356968016763 * d3 + 1.070485915738271 * (1.0 - d3);
        } else {
            d3 = (d - 0.8) / -0.26470000000000005;
            d2 = 1.1215356968016763 * d3 + 1.212304476704785 * (1.0 - d3);
        }
        return d2;
    }

    protected ComplexVector3D getCenter() {
        double d = 0.5 / Math.sin(0.2617993877991494);
        Complex complex = new Complex(d * Math.cos(1.3089969389957472), d * Math.sin(1.3089969389957472));
        ComplexVector3D complexVector3D = new ComplexVector3D(this.helperToMinimal(this.helperArray[0][0]));
        ComplexVector3D complexVector3D2 = new ComplexVector3D(this.helperToMinimal(this.helperArray[0][(int)Math.floor(this.vcount / 2)]));
        ComplexVector3D complexVector3D3 = complexVector3D2.minus(complexVector3D);
        complexVector3D3.assignTimes(complex);
        complexVector3D3.assignPlus(complexVector3D);
        complexVector3D3.z.re = 0.0;
        ComplexVector3D complexVector3D4 = new ComplexVector3D(this.minimalToHelper(complexVector3D3));
        return complexVector3D4;
    }

    public void computePeriodData() {
        this.surf_1 = this.surfacePoint(0.5, 0.0);
        this.transY = new Vector3D(2.0 * this.surf_1.x, 0.0, 0.0);
        this.surf_3 = this.surfacePoint(1.0, 1.0);
        this.transZ = new Vector3D(0.0, 0.0, 2.0 * this.surf_3.z);
        this.surf_1 = this.surfacePoint(0.6666666666666666, 0.0);
        this.surf_1.assignTimes(2.0);
        this.norm_3 = this.surfaceNormal(1.0, 1.0);
        double d = this.norm_3.dot(this.surf_3);
        this.trans = new Vector3D(this.surf_3.x - d * this.norm_3.x, this.surf_3.y - d * this.norm_3.y, this.surf_3.z - d * this.norm_3.z);
        this.trans.assignTimes(2.0);
        double d2 = Math.cos(2.0943951023931953);
        double d3 = Math.sin(2.0943951023931953);
        this.Msym = GridTransformMatrix.SetGridTransformMatrix(d2, d3, 0.0, this.trans.x, d3, -d2, 0.0, this.trans.y, 0.0, 0.0, -1.0, this.trans.z, false);
    }

    protected double closePeriodWithAFP() {
        double d = this.AFP;
        Vector3D vector3D = this.surfaceNormal(1.0, 1.0);
        this.AFP = 0.0;
        Vector3D vector3D2 = this.surfacePoint(0.6666666666666666, 0.0);
        this.AFP = 1.5707963267948966;
        Vector3D vector3D3 = this.surfacePoint(0.6666666666666666, 0.0);
        double d2 = vector3D.dot(vector3D2);
        double d3 = vector3D.dot(vector3D3);
        double d4 = 1.5707963267948966 - Math.atan(-d3 / d2);
        this.AFP = d;
        return d4;
    }

    public void createHelperArray() {
        super.createHelperArray();
        double d = this.closePeriodWithAFP();
        if (this.adaptAFP) {
            this.afp.setValue(d);
            this.AFP = this.afp.getValue();
        }
        this.adaptAFP = true;
    }

    public ActionList getAdditionalAnimationsForView(final View view) {
        ActionList actionList = super.getAdditionalAnimationsForView(view);
        actionList.add(new AbstractActionVMM(I18n.tr("vmm.surface.parametric.LidinoidHfamily.AssociateMorph")){

            public void actionPerformed(ActionEvent actionEvent) {
                BasicAnimator basicAnimator = new BasicAnimator();
                basicAnimator.setLooping(2);
                LidinoidHfamily.this.needsValueArray = true;
                LidinoidHfamily.this.createHelperArray();
                basicAnimator.setUseFilmstrip(LidinoidHfamily.this.getUseFilmstripForMorphing());
                final int n = LidinoidHfamily.this.getFramesForMorphing();
                LidinoidHfamily.this.setFramesForMorphing(24);
                basicAnimator.setFrames(LidinoidHfamily.this.getFramesForMorphing());
                basicAnimator.setMillisecondsPerFrame(200);
                double d = 1.5707963267948966 * LidinoidHfamily.this.bb.getAnimationStart();
                double d2 = 1.5707963267948966 * LidinoidHfamily.this.bb.getAnimationEnd();
                basicAnimator.addWithCustomLimits(LidinoidHfamily.this.afp, d, d2);
                view.setShowAxes(true);
                basicAnimator.addChangeListener(new ChangeListener(){

                    public void stateChanged(ChangeEvent changeEvent) {
                        if (((BasicAnimator)changeEvent.getSource()).isRunning()) {
                            LidinoidHfamily.this.inAssociateMorph = true;
                        } else {
                            LidinoidHfamily.this.inAssociateMorph = false;
                            LidinoidHfamily.this.needsValueArray = true;
                            LidinoidHfamily.this.createHelperArray();
                            LidinoidHfamily.this.setFramesForMorphing(n);
                            view.setShowAxes(false);
                        }
                    }
                });
                view.getDisplay().installAnimation(basicAnimator);
            }
        });
        return actionList;
    }
}

