/*
 * Decompiled with CFR 0.152.
 */
package vmm.surface.parametric;

import vmm.core.Complex;
import vmm.core.RealParamAnimateable;
import vmm.core3D.Vector3D;
import vmm.surface.parametric.SurfaceParametric;

public class Kusner_Dihedral_Symmetric
extends SurfaceParametric {
    private RealParamAnimateable aa = new RealParamAnimateable("genericParam.aa", "0", "0", "pi / 2");
    private RealParamAnimateable bb = new RealParamAnimateable("genericParam.bb", 4.0, 4.0, 4.0);

    public Kusner_Dihedral_Symmetric() {
        this.uPatchCount.setValueAndDefault(8);
        this.vPatchCount.setValueAndDefault(34);
        this.setDefaultViewpoint(new Vector3D(0.0, 0.0, 17.3));
        this.setDefaultWindow(-1.25, 1.25, -1.25, 1.25);
        this.addParameter(this.aa);
        this.addParameter(this.bb);
        this.umin.reset(Math.log(0.002));
        this.umax.reset(-0.45);
        this.vmin.reset(0.0);
        this.vmax.reset("2*pi");
        this.addParameter(this.aa);
        this.addParameter(this.bb);
    }

    private static Complex Pow(Complex complex, int n) {
        Complex complex2 = new Complex(complex);
        for (int i = 2; i <= n; ++i) {
            complex2 = complex2.times(complex);
        }
        return complex2;
    }

    public Vector3D surfacePoint(double d, double d2) {
        double d3 = this.aa.getValue();
        double d4 = this.bb.getValue();
        int n = Math.max(Math.round((int)d4), 2);
        int n2 = n - 1;
        Complex complex = new Complex(2.0 * Math.sqrt(2 * n - 1) / (double)n2, 0.0);
        Complex complex2 = new Complex(0.0, (double)n2 / (double)n);
        double d5 = Math.cos(d3);
        double d6 = Math.sin(d3);
        Complex complex3 = new Complex(1.0, 0.0);
        Complex complex4 = new Complex(0.0, 1.0);
        Complex complex5 = new Complex(Math.exp(d) * Math.cos(d2), Math.exp(d) * Math.sin(d2));
        Complex complex6 = new Complex();
        Complex complex7 = new Complex();
        complex6 = Kusner_Dihedral_Symmetric.Pow(complex5, n2);
        complex7 = complex3.dividedBy(complex6);
        Complex complex8 = new Complex();
        Complex complex9 = new Complex();
        complex8 = complex6.plus(complex7);
        complex9 = complex6.minus(complex7);
        complex6 = complex6.times(complex5);
        complex7 = complex7.dividedBy(complex5);
        Complex complex10 = new Complex();
        Complex complex11 = new Complex();
        complex10 = complex6.plus(complex7);
        complex11 = complex6.minus(complex7);
        Complex complex12 = new Complex();
        complex12 = complex3.dividedBy(complex11.plus(complex));
        Complex complex13 = new Complex();
        complex13 = complex4.times(complex9);
        complex13 = complex12.times(complex13);
        Complex complex14 = new Complex();
        complex14 = complex12.times(complex8);
        Complex complex15 = new Complex();
        complex15 = complex2.times(complex10);
        complex15 = complex12.times(complex15);
        double d7 = d5 * complex13.re + d6 * complex13.im;
        double d8 = d5 * complex14.re + d6 * complex14.im;
        double d9 = d5 * complex15.re + d6 * complex15.im;
        return new Vector3D(d7, d8, d9);
    }
}

