/*
 * Decompiled with CFR 0.152.
 */
package vmm.surface.parametric;

import vmm.core3D.Vector3D;
import vmm.surface.parametric.SurfaceParametric;

public class KuenSurface
extends SurfaceParametric {
    public KuenSurface() {
        this.uPatchCount.setValueAndDefault(21);
        this.vPatchCount.setValueAndDefault(21);
        this.umin.reset(-4.0);
        this.umax.reset(4.0);
        this.vmin.reset(-3.75);
        this.vmax.reset(3.75);
        this.setDefaultViewpoint(new Vector3D(10.0, -10.0, 10.0));
        this.setDefaultWindow(-2.0, 2.0, -2.0, 2.0);
    }

    private static double sinh(double d) {
        return 0.5 * (Math.exp(d) - Math.exp(-d));
    }

    private static double cosh(double d) {
        return 0.5 * (Math.exp(d) + Math.exp(-d));
    }

    public Vector3D surfacePoint(double d, double d2) {
        double d3 = 2.0 * KuenSurface.cosh(d2) * (Math.cos(d) + d * Math.sin(d)) / (KuenSurface.cosh(d2) * KuenSurface.cosh(d2) + d * d);
        double d4 = 2.0 * KuenSurface.cosh(d2) * (-d * Math.cos(d) + Math.sin(d)) / (KuenSurface.cosh(d2) * KuenSurface.cosh(d2) + d * d);
        double d5 = d2 - 2.0 * KuenSurface.sinh(d2) * KuenSurface.cosh(d2) / (KuenSurface.cosh(d2) * KuenSurface.cosh(d2) + d * d);
        return new Vector3D(d3, d4, d5);
    }
}

