/*
 * Decompiled with CFR 0.152.
 */
package vmm.surface.parametric;

import java.awt.event.ActionEvent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import vmm.actions.AbstractActionVMM;
import vmm.actions.ActionList;
import vmm.core.BasicAnimator;
import vmm.core.I18n;
import vmm.core.RealParamAnimateable;
import vmm.core.View;
import vmm.core3D.Vector3D;
import vmm.surface.parametric.SurfaceParametric;

public class KleinBottle
extends SurfaceParametric {
    private RealParamAnimateable aa = new RealParamAnimateable("genericParam.aa", 3.0, 3.0, 3.0);
    boolean in2ndMorph = false;

    public KleinBottle() {
        this.setDefaultViewpoint(new Vector3D(10.0, -10.0, 10.0));
        this.setDefaultWindow(-4.0, 4.0, -4.0, 4.0);
        this.umin.reset("0.0", "-0.3", "-pi");
        this.umax.reset("2*pi", "0.3", "pi");
        this.vmin.reset("0.0", "0.1", "0.1");
        this.vmax.reset("2*pi", "2*pi", "2*pi");
        this.uPatchCount.setValueAndDefault(18);
        this.vPatchCount.setValueAndDefault(24);
        this.setDefaultOrientation(2);
        this.addParameter(this.aa);
    }

    private static double sin(double d) {
        return Math.sin(d);
    }

    private static double cos(double d) {
        return Math.cos(d);
    }

    public ActionList getAdditionalAnimationsForView(final View view) {
        ActionList actionList = super.getAdditionalAnimationsForView(view);
        actionList.add(new AbstractActionVMM(I18n.tr("vmm.surface.parametric.KleinBottle.Twisting8")){

            public void actionPerformed(ActionEvent actionEvent) {
                BasicAnimator basicAnimator = new BasicAnimator();
                basicAnimator.setLooping(2);
                basicAnimator.setUseFilmstrip(KleinBottle.this.getUseFilmstripForMorphing());
                basicAnimator.setFrames(KleinBottle.this.getFramesForMorphing());
                basicAnimator.setMillisecondsPerFrame(200);
                basicAnimator.addWithCustomValue(KleinBottle.this.umin, 0.0);
                basicAnimator.addWithCustomValue(KleinBottle.this.umax, Math.PI * 2);
                basicAnimator.addWithCustomLimits(KleinBottle.this.vmin, 0.0, 0.0);
                basicAnimator.addWithCustomLimits(KleinBottle.this.vmax, 0.2, Math.PI * 2);
                basicAnimator.addChangeListener(new ChangeListener(){

                    public void stateChanged(ChangeEvent changeEvent) {
                        KleinBottle.this.in2ndMorph = ((BasicAnimator)changeEvent.getSource()).isRunning();
                    }
                });
                view.getDisplay().installAnimation(basicAnimator);
            }
        });
        return actionList;
    }

    public Vector3D surfacePoint(double d, double d2) {
        double d3 = this.aa.getValue();
        return new Vector3D((d3 + KleinBottle.cos(d2 / 2.0) * KleinBottle.sin(d) - KleinBottle.sin(d2 / 2.0) * KleinBottle.sin(2.0 * d)) * KleinBottle.cos(d2), (d3 + KleinBottle.cos(d2 / 2.0) * KleinBottle.sin(d) - KleinBottle.sin(d2 / 2.0) * KleinBottle.sin(2.0 * d)) * KleinBottle.sin(d2), KleinBottle.sin(d2 / 2.0) * KleinBottle.sin(d) + KleinBottle.cos(d2 / 2.0) * KleinBottle.sin(2.0 * d));
    }
}

