/*
 * Decompiled with CFR 0.152.
 */
package vmm.surface.parametric;

import vmm.core.RealParamAnimateable;
import vmm.core3D.GridTransformMatrix;
import vmm.core3D.Vector3D;
import vmm.surface.parametric.SurfaceParametric;

public class Hyperboloid2
extends SurfaceParametric {
    private RealParamAnimateable aa = new RealParamAnimateable("genericParam.aa", "1.0", "1.0", "0.5");
    private RealParamAnimateable bb = new RealParamAnimateable("genericParam.bb", "1.0", "1.0", "1.8");
    private RealParamAnimateable cc = new RealParamAnimateable("genericParam.cc", "1.0", "1.0", "1.0");

    public Hyperboloid2() {
        this.uPatchCount.setValueAndDefault(18);
        this.vPatchCount.setValueAndDefault(18);
        this.umin.reset("0");
        this.umax.reset("2");
        this.vmin.reset("0");
        this.vmax.reset("2 pi");
        this.uPatchCount.setValueAndDefault(12);
        this.vPatchCount.setValueAndDefault(12);
        this.setDefaultViewpoint(new Vector3D(25.0, 25.0, 15.0));
        this.setDefaultWindow(-5.5, 5.5, -5.5, 5.5);
        this.addParameter(this.aa);
        this.addParameter(this.bb);
        this.addParameter(this.cc);
    }

    protected void createData() {
        super.createData();
        this.data.discardGridTransforms();
        this.data.addGridTransform(new GridTransformMatrix().scale(1.0, 1.0, -1.0));
    }

    private static double sinh(double d) {
        return 0.5 * (Math.exp(d) - Math.exp(-d));
    }

    private static double cosh(double d) {
        return 0.5 * (Math.exp(d) + Math.exp(-d));
    }

    public Vector3D surfacePoint(double d, double d2) {
        double d3 = this.aa.getValue();
        double d4 = this.bb.getValue();
        double d5 = this.cc.getValue();
        double d6 = d3 * Hyperboloid2.sinh(d) * Math.cos(d2);
        double d7 = d4 * Hyperboloid2.sinh(d) * Math.sin(d2);
        double d8 = d5 * Hyperboloid2.cosh(d);
        return new Vector3D(d6, d7, d8);
    }
}

