/*
 * Decompiled with CFR 0.152.
 */
package vmm.surface.parametric;

import java.awt.event.ActionEvent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import vmm.actions.AbstractActionVMM;
import vmm.actions.ActionList;
import vmm.core.BasicAnimator;
import vmm.core.I18n;
import vmm.core.Parameter;
import vmm.core.RealParamAnimateable;
import vmm.core.View;
import vmm.core3D.Vector3D;
import vmm.surface.parametric.SurfaceParametric;

public class Hyperboloid1
extends SurfaceParametric {
    private RealParamAnimateable aa = new RealParamAnimateable("genericParam.aa", "1.0", "1.0", "0.5");
    private RealParamAnimateable bb = new RealParamAnimateable("genericParam.bb", "1.0", "1.0", "1.8");
    private RealParamAnimateable cc = new RealParamAnimateable("genericParam.cc", "1.0", "1.0", "1.0");
    private RealParamAnimateable dd = new RealParamAnimateable("genericParam.dd", "1.0", "0.5", "2.0");
    private boolean in2ndMorph = false;
    private double AA = this.aa.getValue();
    private double BB = this.bb.getValue();
    private double CC = this.cc.getValue();
    private double DD = this.dd.getValue();

    public Hyperboloid1() {
        this.uPatchCount.setValueAndDefault(18);
        this.vPatchCount.setValueAndDefault(18);
        this.umin.reset("-2");
        this.umax.reset("2");
        this.vmin.reset("0");
        this.vmax.reset("2 pi");
        this.setDefaultViewpoint(new Vector3D(30.0, 20.0, 10.0));
        this.setDefaultWindow(-5.5, 5.5, -5.5, 5.5);
        this.addParameter(this.dd);
        this.addParameter(this.cc);
        this.addParameter(this.bb);
        this.addParameter(this.aa);
    }

    public void parameterChanged(Parameter parameter, Object object, Object object2) {
        super.parameterChanged(parameter, object, object2);
        this.AA = this.aa.getValue();
        this.BB = this.bb.getValue();
        this.CC = this.cc.getValue();
        this.DD = this.dd.getValue();
    }

    public ActionList getAdditionalAnimationsForView(final View view) {
        ActionList actionList = super.getAdditionalAnimationsForView(view);
        actionList.add(new AbstractActionVMM(I18n.tr("vmm.surface.parametric.Hyperboloid1.Ruling")){

            public void actionPerformed(ActionEvent actionEvent) {
                BasicAnimator basicAnimator = new BasicAnimator();
                basicAnimator.setLooping(2);
                basicAnimator.setUseFilmstrip(Hyperboloid1.this.getUseFilmstripForMorphing());
                basicAnimator.setFrames(Hyperboloid1.this.getFramesForMorphing());
                basicAnimator.setMillisecondsPerFrame(200);
                basicAnimator.addWithCustomLimits(Hyperboloid1.this.dd, 0.5, 2.0);
                basicAnimator.addChangeListener(new ChangeListener(){

                    public void stateChanged(ChangeEvent changeEvent) {
                        if (((BasicAnimator)changeEvent.getSource()).isRunning()) {
                            Hyperboloid1.this.in2ndMorph = true;
                        } else {
                            Hyperboloid1.this.in2ndMorph = false;
                        }
                    }
                });
                view.getDisplay().installAnimation(basicAnimator);
            }
        });
        return actionList;
    }

    private static double sinh(double d) {
        return 0.5 * (Math.exp(d) - Math.exp(-d));
    }

    private static double cosh(double d) {
        return 0.5 * (Math.exp(d) + Math.exp(-d));
    }

    public Vector3D surfacePoint(double d, double d2) {
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        if (!this.in2ndMorph) {
            d3 = this.AA * Hyperboloid1.cosh(d) * Math.cos(d2);
            d4 = this.BB * Hyperboloid1.cosh(d) * Math.sin(d2);
            d5 = this.CC * Hyperboloid1.sinh(d);
        } else {
            double d6 = d * Math.PI / 2.0;
            double d7 = d2 - (this.vmax.getValue() + this.vmin.getValue()) / 2.0;
            d5 = this.AA * (Math.cos(d6) - d7 * Math.sin(d6));
            d4 = this.BB * (Math.sin(d6) + d7 * Math.cos(d6));
            d3 = this.DD * this.CC * d7;
        }
        return new Vector3D(d3, d4, d5);
    }
}

