/*
 * Decompiled with CFR 0.152.
 */
package vmm.surface.parametric;

import vmm.core.RealParamAnimateable;
import vmm.core3D.Vector3D;
import vmm.surface.parametric.SurfaceParametric;

public class HyperbolicParaboloid
extends SurfaceParametric {
    private RealParamAnimateable aa = new RealParamAnimateable("genericParam.aa", "1.0", "1.0", "0.5");
    private RealParamAnimateable bb = new RealParamAnimateable("genericParam.bb", "2.0", "1.0", "1.8");
    private RealParamAnimateable cc = new RealParamAnimateable("genericParam.cc", "1.0", "1.0", "1.0");

    public HyperbolicParaboloid() {
        this.uPatchCount.setValueAndDefault(18);
        this.vPatchCount.setValueAndDefault(18);
        this.umin.reset("-2.5");
        this.umax.reset("2.5");
        this.vmin.reset("-2.5");
        this.vmax.reset("2.5");
        this.setDefaultViewpoint(new Vector3D(29.0, 16.0, 20.0));
        this.setDefaultWindow(-8.0, 8.0, -8.0, 8.0);
        this.addParameter(this.aa);
        this.addParameter(this.bb);
        this.addParameter(this.cc);
    }

    public Vector3D surfacePoint(double d, double d2) {
        double d3 = this.aa.getValue();
        double d4 = this.bb.getValue();
        double d5 = this.cc.getValue();
        double d6 = d3 * d;
        double d7 = d4 * d2;
        double d8 = d5 * d * d2;
        return new Vector3D(d6, d7, d8);
    }
}

