/*
 * Decompiled with CFR 0.152.
 */
package vmm.surface.parametric;

import vmm.core.RealParamAnimateable;
import vmm.core3D.Vector3D;
import vmm.surface.parametric.SurfaceParametric;

public class Henneberg
extends SurfaceParametric {
    private RealParamAnimateable aa = new RealParamAnimateable("genericParam.aa", 0.0, 0.0, 1.5707963267948966);

    public Henneberg() {
        this.uPatchCount.setValueAndDefault(8);
        this.vPatchCount.setValueAndDefault(24);
        this.umin.reset(0.35);
        this.umax.reset(0.85);
        this.vmin.reset("-pi");
        this.vmax.reset("pi");
        this.setDefaultViewpoint(new Vector3D(10.0, -10.0, 10.0));
        this.setDefaultWindow(-8.0, 8.0, -8.0, 8.0);
        this.addParameter(this.aa);
    }

    private static double sinh(double d) {
        return 0.5 * (Math.exp(d) - Math.exp(-d));
    }

    private static double cosh(double d) {
        return 0.5 * (Math.exp(d) + Math.exp(-d));
    }

    public Vector3D surfacePoint(double d, double d2) {
        double d3 = Math.PI;
        double d4 = this.aa.getValue();
        double d5 = -2.0 * Math.cos(d4 * d3) * (-Henneberg.sinh(d) * Math.cos(d2) + Henneberg.sinh(3.0 * d) * Math.cos(3.0 * d2) / 3.0) - 2.0 * Math.sin(d4 * d3) * (-Henneberg.cosh(d) * Math.sin(d2) + Henneberg.cosh(3.0 * d) * Math.sin(3.0 * d2) / 3.0);
        double d6 = -2.0 * Math.cos(d4 * d3) * (-Henneberg.sinh(d) * Math.sin(d2) - Henneberg.sinh(3.0 * d) * Math.sin(3.0 * d2) / 3.0) - 2.0 * Math.sin(d4 * d3) * (Henneberg.cosh(d) * Math.cos(d2) + Henneberg.cosh(3.0 * d) * Math.cos(3.0 * d2) / 3.0);
        double d7 = 2.0 * Math.cos(d4 * d3) * (-1.0 + Henneberg.cosh(2.0 * d) * Math.cos(2.0 * d2)) + 2.0 * Math.sin(d4 * d3) * (Henneberg.sinh(2.0 * d) * Math.sin(2.0 * d2));
        return new Vector3D(d5, d6, d7);
    }
}

