/*
 * Decompiled with CFR 0.152.
 */
package vmm.surface.parametric;

import java.awt.Color;
import vmm.core.Complex;
import vmm.core.Parameter;
import vmm.core.RealParamAnimateable;
import vmm.core.View;
import vmm.core3D.ComplexVector3D;
import vmm.core3D.GridTransformMatrix;
import vmm.core3D.Vector3D;
import vmm.surface.parametric.WeierstrassMinimalSurface;

public class DoublyPeriodicJE
extends WeierstrassMinimalSurface {
    private RealParamAnimateable aa = new RealParamAnimateable("vmm.surface.parametric.DoublyPeriodicJE.aa", 0.0, 0.6, -0.6);
    private int iP;
    private int um;
    private int vm;
    private double PL;
    private double r1;
    private double rB;
    private double rTest;
    private double detour;
    private Complex cP;
    private Complex cP_;
    private Complex qP;
    private ComplexVector3D halfPeriodII;

    public DoublyPeriodicJE() {
        this.addParameter(this.aa);
        this.aa.setMaximumValueForInput(0.9);
        this.aa.setMinimumValueForInput(-0.8);
        this.setDefaultOrientation(0);
        this.setDefaultViewpoint(new Vector3D(-42.0, 19.0, 19.0));
        this.setDefaultWindow(-5.0, 4.0, -4.0, 3.2);
        this.uPatchCount.setValueAndDefault(30);
        this.vPatchCount.setValueAndDefault(12);
        this.umin.reset(-4.43);
        this.umax.reset(-this.umin.getValue());
        this.vmin.reset(-1.5707963267948966);
        this.vmax.reset(1.5707963267948966);
        this.removeParameter(this.vmin);
        this.removeParameter(this.vmax);
        this.removeParameter(this.umax);
        this.multipleCopyOptions = new int[]{2, 3};
        this.canShowConjugateSurface = true;
        this.wantsToSeeDomain = false;
        this.wantsToSeeGaussImage = false;
        if (this.wantsToSeeGaussImage) {
            this.wantsToSeeDomain = true;
        }
        if (this.wantsToSeeDomain) {
            this.setDefaultViewUp(new Vector3D(0.0, 0.0, 1.0));
            this.setDefaultViewpoint(new Vector3D(0.0, 0.0, 40.0));
        }
    }

    public View getDefaultView() {
        WeierstrassMinimalSurface.WMSView wMSView = new WeierstrassMinimalSurface.WMSView(this);
        wMSView.setGridSpacing(12);
        float f = 0.2f;
        wMSView.getLightSettings().setAmbientLight(new Color(f, f, f));
        wMSView.getLightSettings().setSpecularExponent(55);
        wMSView.getLightSettings().setSpecularRatio(0.5f);
        return wMSView;
    }

    public void parameterChanged(Parameter parameter, Object object, Object object2) {
        super.parameterChanged(parameter, object, object2);
        if (parameter == this.umin) {
            this.umax.reset(-this.umin.getValue());
        }
    }

    protected void createData() {
        super.createData();
        this.data.discardGridTransforms();
        GridTransformMatrix[] gridTransformMatrixArray = new GridTransformMatrix[40];
        gridTransformMatrixArray[0] = new GridTransformMatrix();
        if (!this.inAssociateMorph && !this.wantsToSeeDomain && (this.flag0 || this.flag05)) {
            if (this.flag0) {
                gridTransformMatrixArray[1] = new GridTransformMatrix().scale(-1.0, 1.0, 1.0);
                gridTransformMatrixArray[2] = new GridTransformMatrix().scale(1.0, -1.0, -1.0).reverse();
                gridTransformMatrixArray[3] = new GridTransformMatrix().scale(-1.0, -1.0, -1.0).reverse();
            } else if (this.flag05) {
                gridTransformMatrixArray[1] = new GridTransformMatrix().scale(1.0, -1.0, -1.0).reverse();
                gridTransformMatrixArray[2] = new GridTransformMatrix().scale(-1.0, 1.0, 1.0);
                gridTransformMatrixArray[3] = new GridTransformMatrix().scale(-1.0, -1.0, -1.0).reverse();
            }
            this.data.addGridTransform(gridTransformMatrixArray[1]);
            this.data.addGridTransform(gridTransformMatrixArray[2]);
            this.data.addGridTransform(gridTransformMatrixArray[3]);
            if (this.getNumberOfPieces() == 2 || this.getNumberOfPieces() == 3) {
                int n;
                for (n = 2; n < 4; ++n) {
                    if (this.flag0) {
                        gridTransformMatrixArray[n + 2] = new GridTransformMatrix(gridTransformMatrixArray[n]).translate(0.0, 2.0 * this.halfPeriodII.y.re, 0.0);
                    } else if (this.flag05) {
                        gridTransformMatrixArray[n + 2] = new GridTransformMatrix(gridTransformMatrixArray[n]).translate(2.0 * this.halfPeriod.x.im, 0.0, 0.0);
                    }
                    this.data.addGridTransform(gridTransformMatrixArray[n + 2]);
                }
                for (n = 2; n < 4; ++n) {
                    if (this.flag0) {
                        gridTransformMatrixArray[n + 4] = new GridTransformMatrix(gridTransformMatrixArray[n]).translate(0.0, 0.0, 2.0 * this.halfPeriod.z.re);
                    }
                    if (this.flag05) {
                        gridTransformMatrixArray[n + 4] = new GridTransformMatrix(gridTransformMatrixArray[n]).scale(-1.0, -1.0, -1.0).reverse().translate(-2.0 * this.halfPeriod.x.im, 0.0, 0.0);
                    }
                    this.data.addGridTransform(gridTransformMatrixArray[n + 4]);
                }
                if (this.getNumberOfPieces() == 3 && this.flag0) {
                    for (n = 2; n < 4; ++n) {
                        gridTransformMatrixArray[n + 6] = new GridTransformMatrix(gridTransformMatrixArray[n]).translate(0.0, 2.0 * this.halfPeriodII.y.re, 2.0 * this.halfPeriod.z.re);
                        this.data.addGridTransform(gridTransformMatrixArray[n + 6]);
                    }
                    for (n = 0; n < 2; ++n) {
                        gridTransformMatrixArray[n + 10] = new GridTransformMatrix(gridTransformMatrixArray[n]).translate(0.0, 0.0, -2.0 * this.halfPeriod.z.re);
                        this.data.addGridTransform(gridTransformMatrixArray[n + 10]);
                    }
                }
                if (this.getNumberOfPieces() == 3 && this.flag05) {
                    for (n = 2; n < 3; ++n) {
                        gridTransformMatrixArray[n + 6] = new GridTransformMatrix(gridTransformMatrixArray[n]).translate(0.0, 0.0, -2.0 * this.halfPeriodII.z.im);
                        gridTransformMatrixArray[n + 7] = new GridTransformMatrix(gridTransformMatrixArray[n]).translate(0.0, 0.0, -2.0 * this.halfPeriodII.z.im).scale(-1.0, 1.0, 1.0);
                        this.data.addGridTransform(gridTransformMatrixArray[n + 6]);
                        this.data.addGridTransform(gridTransformMatrixArray[n + 7]);
                    }
                    for (n = 0; n < 1; ++n) {
                        gridTransformMatrixArray[n + 10] = new GridTransformMatrix(gridTransformMatrixArray[n]).translate(-2.0 * this.halfPeriod.x.im, 0.0, -2.0 * this.halfPeriodII.z.im);
                        gridTransformMatrixArray[n + 11] = new GridTransformMatrix(gridTransformMatrixArray[n]).translate(-2.0 * this.halfPeriod.x.im, 0.0, -2.0 * this.halfPeriodII.z.im).scale(-1.0, 1.0, 1.0);
                        this.data.addGridTransform(gridTransformMatrixArray[n + 10]);
                        this.data.addGridTransform(gridTransformMatrixArray[n + 11]);
                    }
                }
            }
        }
    }

    protected Complex domainGrid(double d, double d2) {
        double d3;
        double d4 = Math.exp(d);
        Complex complex = new Complex(d4 * Math.cos(d2), d4 * Math.sin(d2));
        Complex complex2 = new Complex(complex.re + 1.0, complex.im);
        complex.re = 1.0 - complex.re;
        complex.im = -complex.im;
        complex.assignDivide(complex2);
        if (d2 < 1.0E-4) {
            d3 = complex.minus(this.cP).r();
            if (d3 <= this.detour) {
                complex.assignTimes(1.0 + d3 - this.detour);
            } else {
                d3 = complex.minus(this.cP_).r();
                if (d3 <= this.detour) {
                    complex.assignTimes(1.0 + d3 - this.detour);
                }
            }
        }
        if (d2 >= this.vmax.getValue() - 1.0E-4) {
            d3 = complex.minus(this.cP.conj()).r();
            if (d3 <= this.detour) {
                complex.assignTimes(1.0 + d3 - this.detour);
            } else {
                d3 = complex.minus(this.cP_.conj()).r();
                if (d3 <= this.detour) {
                    complex.assignTimes(1.0 + d3 - this.detour);
                }
            }
        }
        if (this.wantsToSeeGaussImage) {
            complex = this.hPrime(complex);
        }
        return complex;
    }

    protected void p_Index() {
        this.iP = (int)Math.floor((this.rTest - this.umin.getValue()) / (this.umax.getValue() - this.umin.getValue()) * (double)(this.ucount - 1));
    }

    protected Complex gauss(Complex complex) {
        Complex complex2 = new Complex(1.0 - complex.re, -complex.im);
        complex2.assignDivide(new Complex(complex.re + 1.0, complex.im));
        return complex2;
    }

    protected Complex hPrime(Complex complex) {
        Complex complex2 = complex.times(complex);
        Complex complex3 = new Complex(complex.re, -complex.im);
        double d = complex2.re * complex2.re + complex2.im * complex2.im;
        complex2 = new Complex(complex2.re / d + complex2.re - this.rB, -complex2.im * (1.0 / d - 1.0));
        complex2 = complex2.squareRootNearer(complex3);
        complex2.assignTimes(complex);
        return complex2.inverse().times(this.r1);
    }

    protected void redoConstants() {
        super.redoConstants();
        this.PL = 0.7853981633974483 * (1.0 + Math.sin(1.5707963267948966 * this.aa.getValue()));
        this.cP = new Complex(Math.cos(this.PL), Math.sin(this.PL));
        this.cP_ = new Complex(-Math.cos(this.PL), Math.sin(this.PL));
        this.qP = new Complex(this.cP.times(0.9995));
        this.rB = 2.0 * Math.cos(2.0 * this.PL);
        this.rTest = Math.log(Math.sin(this.PL) / (1.0 + Math.cos(this.PL)));
        this.detour = (0.05 * (this.aa.getValue() + 0.7) + 0.005 * (0.9 - this.aa.getValue())) / 2.0;
        this.r1 = 0.5 * (1.0 + this.aa.getValue()) * (1.0 - 0.075 * (double)(this.getNumberOfPieces() - 1));
        if (this.inAssociateMorph) {
            this.r1 *= 1.5;
        }
        this.p_Index();
        this.um = (int)Math.floor((double)this.ucount / 2.0);
        this.vm = (int)Math.floor((double)this.vcount / 2.0);
    }

    protected ComplexVector3D getCenter() {
        if (this.inAssociateMorph) {
            return new ComplexVector3D(this.helperArray[this.um][this.vm]);
        }
        if (this.wantsToSeeDomain) {
            return new ComplexVector3D(ZERO_C, ZERO_C, ZERO_C);
        }
        double d = 0.005;
        Complex complex = new Complex(Math.cos(this.PL - d), Math.sin(this.PL - d));
        Complex complex2 = new Complex(Math.cos(this.PL) - 0.7 * d, Math.sin(this.PL) - 0.7 * d);
        Complex complex3 = new Complex(Math.cos(this.PL + d), Math.sin(this.PL + d));
        ComplexVector3D complexVector3D = new ComplexVector3D(this.helperArray[this.iP][0]);
        complexVector3D.assignPlus(this.ComplexVectorIntegrator(this.domainGrid(this.umin.getValue() + (double)this.iP * this.du, this.vmin.getValue()), complex, 32));
        ComplexVector3D complexVector3D2 = this.ComplexVectorIntegrator(complex, complex2, 32);
        complexVector3D2 = complexVector3D2.plus(this.ComplexVectorIntegrator(complex2, complex3, 32)).times(new Complex(0.5, -0.5));
        return complexVector3D.plus(complexVector3D2);
    }

    public void computeHalfPeriod() {
        ComplexVector3D complexVector3D = this.helperToMinimal(this.helperArray[this.ucount - 1][0]);
        ComplexVector3D complexVector3D2 = this.helperToMinimal(this.helperArray[0][0]);
        this.halfPeriod = complexVector3D.minus(complexVector3D2);
        this.halfPeriod.x.re = 0.0;
        this.halfPeriod.y.re = 0.0;
        this.halfPeriod.y.im = 0.0;
        this.halfPeriodII = this.helperToMinimal(this.helperArray[this.um][this.vm].times(2.0));
        this.halfPeriodII.x.re = 0.0;
        this.halfPeriodII.z.re = 0.0;
        this.halfPeriodII.y.im = 0.0;
    }

    public Vector3D surfacePoint(double d, double d2) {
        int n = (int)Math.floor(0.25 + (d - this.umin.getValue()) / this.du);
        int n2 = (int)Math.floor(0.25 + (d2 - this.vmin.getValue()) / this.dv);
        ComplexVector3D complexVector3D = new ComplexVector3D(this.helperArray[n][n2].plus(this.ComplexVectorOneStepIntegrator(this.domainGrid(this.umin.getValue() + (double)n * this.du, this.vmin.getValue() + (double)n2 * this.dv), this.domainGrid(d, d2))));
        ComplexVector3D complexVector3D2 = this.helperToMinimal(complexVector3D);
        if (!this.inAssociateMorph && !this.wantsToSeeDomain) {
            if (n == this.iP && n2 == 0) {
                complexVector3D2 = new ComplexVector3D(ComplexVector3D.ORIGIN);
            } else if (n == this.ucount - 1 - this.iP && n2 == 0) {
                complexVector3D2 = new ComplexVector3D(this.halfPeriod);
            } else if (n == this.iP && n2 == this.vcount - 1) {
                complexVector3D2 = new ComplexVector3D(this.halfPeriodII);
            } else if (n == this.ucount - 1 - this.iP && n2 == this.vcount - 1) {
                if (this.flag0) {
                    complexVector3D2 = new ComplexVector3D(this.halfPeriod.plus(this.halfPeriodII));
                } else if (this.flag05) {
                    complexVector3D2 = new ComplexVector3D(this.halfPeriod.times(-1.0).plus(this.halfPeriodII));
                }
            }
            if (this.flag0) {
                if ((n2 == 0 || n2 == this.vcount - 1) && n > this.iP && n < this.ucount - 1 - this.iP) {
                    complexVector3D2.x.assign(ZERO_C);
                }
                if (n2 == 0 && n < this.iP) {
                    complexVector3D2.assign(complexVector3D2.x, ZERO_C, ZERO_C);
                }
                if (n2 == 0 && n > this.ucount - 1 - this.iP) {
                    complexVector3D2.assign(complexVector3D2.x, ZERO_C, this.halfPeriod.z);
                }
                if (n2 == this.vcount - 1 && n < this.iP) {
                    complexVector3D2.assign(complexVector3D2.x, this.halfPeriodII.y, ZERO_C);
                }
                if (n2 == this.vcount - 1 && n > this.ucount - 1 - this.iP) {
                    complexVector3D2.assign(complexVector3D2.x, this.halfPeriodII.y, this.halfPeriod.z);
                }
            }
            if (this.flag05) {
                if (n2 == 0 && n > this.iP && n < this.ucount - 1 - this.iP) {
                    complexVector3D2.assign(complexVector3D2.x, ZERO_C, ZERO_C);
                }
                if (n2 == this.vcount - 1 && n > this.iP && n < this.ucount - 1 - this.iP) {
                    complexVector3D2.assign(complexVector3D2.x, ZERO_C, this.halfPeriodII.z);
                }
            }
        }
        if (this.wantsToSeeDomain) {
            return new Vector3D(complexVector3D2.z.re, complexVector3D2.z.im, 0.0);
        }
        if (this.AFP == 0.0) {
            return complexVector3D2.re();
        }
        return complexVector3D2.re().times(Math.cos(this.AFP)).plus(complexVector3D2.im().times(Math.sin(this.AFP)));
    }
}

