/*
 * Decompiled with CFR 0.152.
 */
package vmm.surface.parametric;

import java.awt.Color;
import vmm.core.Complex;
import vmm.core.RealParamAnimateable;
import vmm.core.View;
import vmm.core3D.ComplexVector3D;
import vmm.core3D.GridTransformMatrix;
import vmm.core3D.Vector3D;
import vmm.surface.parametric.WeierstrassMinimalSurface;

public class DoublyPeriodicJD
extends WeierstrassMinimalSurface {
    private RealParamAnimateable aa = new RealParamAnimateable("vmm.surface.parametric.DoublyPeriodicJD.aa", 0.0, 0.6, -0.6);
    private int jP;
    private int um;
    private int vm;
    private double PL;
    private double r1;
    private double rB;
    private Complex cP;
    private Complex qP;
    private ComplexVector3D halfPeriodII;

    public DoublyPeriodicJD() {
        this.addParameter(this.aa);
        this.aa.setMaximumValueForInput(0.9);
        this.aa.setMinimumValueForInput(-0.84);
        this.setDefaultOrientation(0);
        this.setDefaultViewUp(new Vector3D(0.35, 0.05, 0.93));
        this.setDefaultViewpoint(new Vector3D(-46.0, -8.0, 18.0));
        this.setDefaultWindow(-4.5, 2.7, -3.9, 2.2);
        this.uPatchCount.setValueAndDefault(12);
        this.vPatchCount.setValueAndDefault(12);
        this.umin.reset(-4.5);
        this.umax.reset(0.0);
        this.vmin.reset(-1.5707963267948966);
        this.vmax.reset(1.5707963267948966);
        this.removeParameter(this.vmin);
        this.removeParameter(this.vmax);
        this.removeParameter(this.umax);
        this.wantsToSeeDomain = false;
        this.wantsToSeeGaussImage = false;
        if (this.wantsToSeeGaussImage) {
            this.wantsToSeeDomain = true;
        }
        if (this.wantsToSeeDomain) {
            this.setDefaultViewUp(new Vector3D(0.0, 0.0, 1.0));
            this.setDefaultViewpoint(new Vector3D(0.0, 0.0, 40.0));
        }
        this.multipleCopyOptions = new int[]{2};
        this.canShowConjugateSurface = true;
    }

    public View getDefaultView() {
        WeierstrassMinimalSurface.WMSView wMSView = new WeierstrassMinimalSurface.WMSView(this);
        float f = 0.3f;
        wMSView.getLightSettings().setAmbientLight(new Color(f, f, f));
        wMSView.getLightSettings().setSpecularExponent(55);
        wMSView.getLightSettings().setSpecularRatio(0.5f);
        return wMSView;
    }

    protected void createData() {
        super.createData();
        this.data.discardGridTransforms();
        GridTransformMatrix[] gridTransformMatrixArray = new GridTransformMatrix[40];
        gridTransformMatrixArray[0] = new GridTransformMatrix();
        GridTransformMatrix gridTransformMatrix = new GridTransformMatrix();
        if (!this.inAssociateMorph && !this.wantsToSeeDomain) {
            if (this.flag0) {
                gridTransformMatrixArray[1] = new GridTransformMatrix().scale(1.0, 1.0, -1.0);
                gridTransformMatrixArray[2] = new GridTransformMatrix().scale(-1.0, -1.0, 1.0).reverse();
                gridTransformMatrixArray[3] = new GridTransformMatrix().scale(-1.0, -1.0, -1.0).reverse();
            } else if (this.flag05) {
                gridTransformMatrixArray[1] = new GridTransformMatrix().scale(-1.0, -1.0, 1.0).reverse();
                gridTransformMatrixArray[2] = new GridTransformMatrix().scale(1.0, 1.0, -1.0);
                gridTransformMatrixArray[3] = new GridTransformMatrix().scale(-1.0, -1.0, -1.0).reverse();
            }
            this.data.addGridTransform(gridTransformMatrixArray[1]);
            this.data.addGridTransform(gridTransformMatrixArray[2]);
            this.data.addGridTransform(gridTransformMatrixArray[3]);
            Vector3D vector3D = new Vector3D();
            if (this.flag0) {
                gridTransformMatrix = new GridTransformMatrix().scale(1.0, -1.0, -1.0).reverse();
                vector3D.z = this.halfPeriodII.z.re;
            } else if (this.flag05) {
                gridTransformMatrix = new GridTransformMatrix().scale(-1.0, 1.0, 1.0);
                vector3D.x = this.halfPeriodII.x.im;
            }
            for (int i = 0; i < 4; ++i) {
                gridTransformMatrixArray[i + 4] = new GridTransformMatrix(gridTransformMatrixArray[i]).leftMultiplyBy(gridTransformMatrix).translate(vector3D);
                this.data.addGridTransform(gridTransformMatrixArray[i + 4]);
            }
            if (this.getNumberOfPieces() == 2) {
                GridTransformMatrix gridTransformMatrix2 = new GridTransformMatrix();
                Vector3D vector3D2 = new Vector3D();
                if (this.flag0) {
                    gridTransformMatrix2 = new GridTransformMatrix().scale(-1.0, -1.0, 1.0).reverse();
                    vector3D2.y = 2.0 * this.halfPeriod.y.re;
                } else if (this.flag05) {
                    gridTransformMatrix2 = new GridTransformMatrix().scale(-1.0, 1.0, 1.0);
                    vector3D2.x = 3.0 * this.halfPeriodII.x.im;
                }
                for (int i = 0; i < 8; ++i) {
                    gridTransformMatrixArray[i + 8] = new GridTransformMatrix(gridTransformMatrixArray[i]).leftMultiplyBy(gridTransformMatrix2).translate(vector3D2);
                    this.data.addGridTransform(gridTransformMatrixArray[i + 8]);
                }
            }
        }
    }

    protected Complex domainGrid(double d, double d2) {
        double d3 = Math.exp(d);
        if (d > this.umax.getValue() - 0.001) {
            d3 -= Math.max(Math.max(0.0, 0.04 - Math.abs(d2 - this.PL)), 0.04 - Math.abs(d2 + this.PL));
        }
        Complex complex = new Complex(d3 * Math.cos(d2), d3 * Math.sin(d2));
        if (this.wantsToSeeGaussImage) {
            complex = this.hPrime(complex);
        }
        return complex;
    }

    protected void p_Index() {
        this.jP = (int)Math.floor((this.PL - this.vmin.getValue()) / (this.vmax.getValue() - this.vmin.getValue()) * (double)(this.vcount - 1));
    }

    protected Complex gauss(Complex complex) {
        return new Complex(complex);
    }

    protected Complex hPrime(Complex complex) {
        Complex complex2 = complex.times(complex);
        Complex complex3 = new Complex(complex.re, -complex.im);
        double d = complex2.re * complex2.re + complex2.im * complex2.im;
        complex2 = new Complex(complex2.re / d + complex2.re - this.rB, -complex2.im * (1.0 / d - 1.0));
        complex2 = complex2.squareRootNearer(complex3);
        complex2.assignTimes(complex);
        return complex2.inverse().times(this.r1);
    }

    protected void redoConstants() {
        super.redoConstants();
        this.PL = 0.7853981633974483 * (1.0 + Math.sin(1.5707963267948966 * this.aa.getValue()));
        this.cP = new Complex(Math.cos(this.PL), Math.sin(this.PL));
        this.qP = new Complex(this.cP.times(0.99995));
        this.rB = 2.0 * Math.cos(2.0 * this.PL);
        this.r1 = 0.5;
        if (this.inAssociateMorph) {
            this.r1 = 1.0;
        }
        this.p_Index();
        this.um = (int)Math.floor(this.ucount - 1);
        this.vm = (int)Math.floor(this.vcount / 2);
    }

    protected ComplexVector3D getCenter() {
        if (this.inAssociateMorph) {
            return new ComplexVector3D(this.helperArray[this.um][this.vm]);
        }
        if (this.wantsToSeeDomain) {
            return new ComplexVector3D(ZERO_C, ZERO_C, ZERO_C);
        }
        ComplexVector3D complexVector3D = new ComplexVector3D(this.helperArray[this.ucount - 1][this.jP]);
        complexVector3D = complexVector3D.plus(this.ComplexVectorIntegrator(this.domainGrid(this.umax.getValue(), this.vmin.getValue() + (double)this.jP * this.dv), this.qP, 32));
        return complexVector3D;
    }

    public void computeHalfPeriod() {
        this.halfPeriod = new ComplexVector3D(this.helperArray[this.um][this.vm].times(2.0));
        this.halfPeriod.assign(ZERO_C, this.halfPeriod.y.plus(this.halfPeriod.x).times(I_C), this.halfPeriod.z);
        this.halfPeriodII = new ComplexVector3D(this.helperArray[this.ucount - 1][this.vcount - 1].times(2.0));
        ComplexVector3D complexVector3D = new ComplexVector3D(this.helperArray[this.ucount - 1][0]);
        this.halfPeriodII.assign(complexVector3D.y.plus(complexVector3D.x), ZERO_C, this.halfPeriodII.z);
    }

    public Vector3D surfacePoint(double d, double d2) {
        ComplexVector3D complexVector3D;
        int n = (int)Math.floor(0.25 + (d - this.umin.getValue()) / this.du);
        int n2 = (int)Math.floor(0.25 + (d2 - this.vmin.getValue()) / this.dv);
        if (!this.inAssociateMorph && !this.wantsToSeeDomain && n == this.ucount - 1 && n2 == this.jP) {
            complexVector3D = new ComplexVector3D(ComplexVector3D.ORIGIN);
        } else if (!this.inAssociateMorph && !this.wantsToSeeDomain && n == this.ucount - 1 && n2 == this.vcount - 1 - this.jP) {
            complexVector3D = new ComplexVector3D(this.halfPeriod);
        } else {
            ComplexVector3D complexVector3D2 = new ComplexVector3D(this.helperArray[n][n2].plus(this.ComplexVectorOneStepIntegrator(this.domainGrid(this.umin.getValue() + (double)n * this.du, this.vmin.getValue() + (double)n2 * this.dv), this.domainGrid(d, d2))));
            complexVector3D = new ComplexVector3D(complexVector3D2.y.minus(complexVector3D2.x), complexVector3D2.y.plus(complexVector3D2.x).times(I_C), complexVector3D2.z);
            if (!this.inAssociateMorph && !this.wantsToSeeDomain) {
                if (this.flag0) {
                    if (n == this.ucount - 1 && n2 <= this.jP && n2 >= this.vcount - 1 - this.jP) {
                        complexVector3D.z.assign(ZERO_C);
                    }
                    if (n == this.ucount - 1 && n2 > this.jP) {
                        complexVector3D.assign(ZERO_C, ZERO_C, complexVector3D.z);
                    }
                    if (n == this.ucount - 1 && n2 < this.vcount - 1 - this.jP) {
                        complexVector3D.assign(this.halfPeriod.x, this.halfPeriod.y, complexVector3D.z);
                    }
                }
                if (this.flag05) {
                    if (n == this.ucount - 1 && n2 > this.jP) {
                        complexVector3D.z.assign(ZERO_C);
                    }
                    if (n == this.ucount - 1 && n2 < this.vcount - 1 - this.jP) {
                        complexVector3D.z.assign(this.halfPeriod.z);
                    }
                }
            }
        }
        if (this.wantsToSeeDomain) {
            return new Vector3D(complexVector3D.z.re, complexVector3D.z.im, 0.0);
        }
        if (this.AFP == 0.0) {
            return complexVector3D.re();
        }
        return complexVector3D.re().times(Math.cos(this.AFP)).plus(complexVector3D.im().times(Math.sin(this.AFP)));
    }
}

