/*
 * Decompiled with CFR 0.152.
 */
package vmm.surface.parametric;

import java.awt.event.ActionEvent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import vmm.actions.AbstractActionVMM;
import vmm.actions.ActionList;
import vmm.core.BasicAnimator;
import vmm.core.I18n;
import vmm.core.Parameter;
import vmm.core.Quaternion;
import vmm.core.RealParamAnimateable;
import vmm.core.View;
import vmm.core3D.Vector3D;
import vmm.surface.parametric.SurfaceParametric;

public class DoublyHopfFiberedTori
extends SurfaceParametric {
    private RealParamAnimateable aa = new RealParamAnimateable("vmm.surface.parametric.DoublyHopfFiberedTori.aa", 0.7853981633974483, 0.7853981633974483, 1.413716694115407);
    private RealParamAnimateable bb = new RealParamAnimateable("vmm.surface.parametric.DoublyHopfFiberedTori.bb", 0.0, 0.0, 0.0);
    double AA;
    double BB;
    Quaternion q0;
    boolean in2ndMorph = false;

    public DoublyHopfFiberedTori() {
        this.uPatchCount.setValueAndDefault(24);
        this.vPatchCount.setValueAndDefault(12);
        this.umin.reset("0");
        this.umax.reset("2 pi");
        this.vmin.reset("0");
        this.vmax.reset("pi");
        this.setDefaultViewpoint(new Vector3D(10.0, -10.0, 10.0));
        this.setDefaultWindow(-2.5, 2.5, -2.5, 2.5);
        this.setDefaultOrientation(0);
        this.addParameter(this.bb);
        this.addParameter(this.aa);
    }

    public void parameterChanged(Parameter parameter, Object object, Object object2) {
        super.parameterChanged(parameter, object, object2);
        this.AA = this.aa.getValue();
        this.BB = this.bb.getValue();
        this.q0 = new Quaternion(Math.cos(this.AA) * Math.cos(0.0), Math.cos(this.AA) * Math.sin(0.0), Math.sin(this.AA) * Math.cos(0.0), -Math.sin(this.AA) * Math.sin(0.0));
    }

    public ActionList getAdditionalAnimationsForView(final View view) {
        ActionList actionList = super.getAdditionalAnimationsForView(view);
        final BasicAnimator basicAnimator = new BasicAnimator();
        basicAnimator.setLooping(1);
        basicAnimator.setUseFilmstrip(this.getUseFilmstripForMorphing());
        basicAnimator.setFrames(this.getFramesForMorphing());
        basicAnimator.setMillisecondsPerFrame(200);
        basicAnimator.addWithCustomLimits(this.bb, 0.0, Math.PI * 2);
        basicAnimator.addWithCustomValue(this.vmin, 0.0);
        basicAnimator.addWithCustomValue(this.vmax, Math.PI);
        basicAnimator.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                DoublyHopfFiberedTori.this.in2ndMorph = basicAnimator.isRunning();
            }
        });
        actionList.add(new AbstractActionVMM(I18n.tr("vmm.surface.parametric.DoublyHopfFiberedTori.RotateAroundCircle")){

            public void actionPerformed(ActionEvent actionEvent) {
                view.getDisplay().installAnimation(basicAnimator);
            }
        });
        return actionList;
    }

    public Vector3D surfacePoint(double d, double d2) {
        Quaternion quaternion = new Quaternion(Math.cos(d), Math.sin(d), 0.0, 0.0);
        Quaternion quaternion2 = new Quaternion(Math.cos(this.AA) * Math.cos(d2), Math.cos(this.AA) * Math.sin(d2), Math.sin(this.AA) * Math.cos(d2), -Math.sin(this.AA) * Math.sin(d2));
        Quaternion quaternion3 = quaternion.times(quaternion2);
        Quaternion quaternion4 = quaternion3.rotateAroundHopfFibre(this.BB, this.q0);
        return new Vector3D(quaternion4.StereographicProjection());
    }
}

