/*
 * Decompiled with CFR 0.152.
 */
package vmm.surface.parametric;

import vmm.core.Complex;
import vmm.core.IntegerParam;
import vmm.core.Parameter;
import vmm.core.RealParamAnimateable;
import vmm.core3D.ComplexVector3D;
import vmm.core3D.Vector3D;
import vmm.surface.parametric.WeierstrassMinimalSurface;

public class DoubleEnneper
extends WeierstrassMinimalSurface {
    private IntegerParam exponent = new IntegerParam("vmm.surface.parametric.DoubleEnneper.MainEx", 8);
    private RealParamAnimateable aa = new RealParamAnimateable("vmm.surface.parametric.DoubleEnneper.aa", 4.0, 4.0, 4.0);
    private RealParamAnimateable bb = new RealParamAnimateable("vmm.surface.parametric.DoubleEnneper.bb", 0.1, 0.0, 1.0);
    double uminmax = 1.5;
    private int ee;
    private double AA;
    private double BE;
    private Complex q1;
    private Complex q2;
    private Complex q3;
    private Complex q1q2;

    public DoubleEnneper() {
        this.afp.reset(0.0, 0.0, 0.0);
        this.addParameter(this.bb);
        this.addParameter(this.aa);
        this.addParameter(this.exponent);
        this.setDefaultViewpoint(new Vector3D(40.0, -50.0, 40.0));
        this.setDefaultWindow(-9.0, 9.0, -7.0, 7.0);
        this.uPatchCount.setValueAndDefault(8);
        this.vPatchCount.setValueAndDefault(18);
        this.umin.reset(-this.uminmax);
        this.umax.reset(this.uminmax);
        this.vmin.reset(0.0);
        this.vmax.reset(Math.PI * 2);
        this.canShowConjugateSurface = true;
    }

    public void parameterChanged(Parameter parameter, Object object, Object object2) {
        super.parameterChanged(parameter, object, object2);
        this.AFP = this.afp.getValue();
        if (parameter != this.afp) {
            this.needsValueArray = true;
            if (parameter == this.exponent) {
                this.uminmax = 2.0 - (double)this.exponent.getValue() / 16.0;
                this.umin.reset(-this.uminmax);
                this.umax.reset(this.uminmax);
            }
        }
    }

    protected Complex domainGrid(double d, double d2) {
        double d3 = Math.exp(d);
        Complex complex = new Complex(d3 * Math.cos(d2), d3 * Math.sin(d2));
        return complex;
    }

    protected Complex gauss(Complex complex) {
        Complex complex2 = complex.integerPower(this.ee);
        Complex complex3 = this.q2.times(complex2);
        complex3.assignMinus(this.q1);
        complex3.assignTimes(complex2);
        Complex complex4 = this.q1.times(complex2);
        complex4.assignMinus(this.q2);
        complex4.assignTimes(complex);
        return complex3.dividedBy(complex4);
    }

    protected Complex hPrime(Complex complex) {
        Complex complex2 = complex.integerPower(this.ee);
        Complex complex3 = complex2.minus(this.q1q2);
        complex3.assignTimes(complex2);
        complex3.re += 1.0;
        Complex complex4 = this.q3.times(complex2);
        complex4.assignTimes(complex);
        return complex3.dividedBy(complex4);
    }

    protected void redoConstants() {
        super.redoConstants();
        this.ee = this.exponent.getValue();
        this.BE = Math.PI * 2 * this.bb.getValue() / (double)this.ee;
        this.AA = Math.max(1.1, this.aa.getValue());
        this.q1 = new Complex(Math.sqrt(this.AA) * Math.cos(this.BE / 2.0), Math.sqrt(this.AA) * Math.sin(this.BE / 2.0));
        this.q1 = this.q1.integerPower(this.ee);
        this.q2 = this.q1.inverse();
        this.q1q2 = this.q1.integerPower(2).plus(this.q2.integerPower(2));
        double d = Math.exp((double)(2 * this.ee) * Math.log(this.AA));
        d = (d - 1.0) / (d + 1.0);
        this.q3 = new Complex(Math.cos((double)this.ee * this.BE), d * Math.sin((double)this.ee * this.BE));
        this.q3 = this.q3.times(Math.sqrt(this.AA * this.AA + 1.0 / this.AA / this.AA) * Math.exp(this.ee) * (double)(this.ee + 1) / (5.5 + 1.0 / (double)this.ee) * Math.sqrt(this.ee));
    }

    protected ComplexVector3D getCenter() {
        int n = (int)Math.floor((double)(this.ucount - 1) / 2.0);
        int n2 = (int)Math.floor((double)(this.vcount - 1) / 2.0);
        ComplexVector3D complexVector3D = new ComplexVector3D(this.helperArray[n][0]);
        return complexVector3D.plus(this.helperArray[n][n2]).times(0.5);
    }
}

