/*
 * Decompiled with CFR 0.152.
 */
package vmm.surface.parametric;

import vmm.core.Animation;
import vmm.core.BasicAnimator;
import vmm.core.RealParamAnimateable;
import vmm.core.View;
import vmm.core3D.Vector3D;
import vmm.core3D.View3DLit;
import vmm.surface.parametric.SurfaceParametric;

public class DiracBelt
extends SurfaceParametric {
    private RealParamAnimateable t = new RealParamAnimateable("vmm.surface.parametric.DiracBelt.t", 0.0, 0.0, 3.14159);

    public View getDefaultView() {
        View3DLit view3DLit = new View3DLit();
        view3DLit.setRenderingStyle(0);
        view3DLit.setViewStyle(1);
        return view3DLit;
    }

    public Animation getCreateAnimation(View view) {
        BasicAnimator basicAnimator = this.getMorphingAnimation(view, 1);
        basicAnimator.setMillisecondsPerFrame(200);
        return basicAnimator;
    }

    public DiracBelt() {
        this.uPatchCount.setValueAndDefault(6);
        this.vPatchCount.setValueAndDefault(36);
        this.umin.reset(-0.5);
        this.umax.reset(0.5);
        this.vmin.reset(0.0);
        this.vmax.reset(6.0);
        this.addParameter(this.t);
        this.setDefaultWindow(-4.25, 4.25, -4.25, 4.25);
        this.setDefaultViewpoint(new Vector3D(-1.0, -7.8, 1.6));
        this.setFramesForMorphing(36);
    }

    public Vector3D surfacePoint(double d, double d2) {
        double d3 = this.t.getValue();
        double d4 = Math.sin(d2 / 2.0);
        double d5 = Math.sin(d2);
        double d6 = Math.sin(2.0 * d2);
        double d7 = Math.cos(d2);
        double d8 = Math.cos(2.0 * d2);
        double d9 = Math.cos(d3);
        double d10 = Math.sin(d3);
        double d11 = Math.sin(2.0 * d3);
        double d12 = Math.sin(4.0 * d3);
        double d13 = Math.cos(2.0 * d3);
        double d14 = Math.cos(4.0 * d3);
        double d15 = 0.5 * (d2 - 8.0 * d * d9 * (1.0 + 2.0 * d9 * d9 * d7) * d10 * d4 * d4 + d14 * (d2 - d5) + d5) - 2.0;
        double d16 = -d7 * d11 + d * d9 * d9 * d6;
        double d17 = d * (-d13 * d10 * d10 + d9 * d9 * (d13 * d8 + 4.0 * d7 * d10 * d10)) + 0.5 * d12 * (-d2 + d5);
        return new Vector3D(d15, d16, d17);
    }
}

