/*
 * Decompiled with CFR 0.152.
 */
package vmm.surface.parametric;

import vmm.core.RealParamAnimateable;
import vmm.core3D.Vector3D;
import vmm.surface.parametric.SurfaceParametric;

public class DiniSurface
extends SurfaceParametric {
    private RealParamAnimateable aa = new RealParamAnimateable("genericParam.aa", 0.35, 0.2, 0.5);

    public DiniSurface() {
        this.uPatchCount.setValueAndDefault(20);
        this.vPatchCount.setValueAndDefault(12);
        this.umin.reset(-4.0);
        this.umax.reset(4.0);
        this.vmin.reset("-pi");
        this.vmax.reset("pi");
        this.setDefaultViewpoint(new Vector3D(10.0, -10.0, 10.0));
        this.setDefaultWindow(-1.75, 1.75, -1.75, 1.75);
        this.addParameter(this.aa);
    }

    public Vector3D surfacePoint(double d, double d2) {
        double d3 = this.aa.getValue();
        double d4 = Math.PI * Math.min(0.999, Math.max(d3, 0.001));
        double d5 = Math.sin(d4);
        double d6 = Math.cos(d4);
        double d7 = (d - d6 * d2) / d5;
        double d8 = Math.exp(d7);
        double d9 = 2.0 * d5 / (d8 + 1.0 / d8);
        double d10 = d9 * (d8 - 1.0 / d8) * 0.5;
        double d11 = d - d10;
        double d12 = d9 * Math.cos(d2);
        double d13 = d9 * Math.sin(d2);
        return new Vector3D(d11, d12, d13);
    }
}

