/*
 * Decompiled with CFR 0.152.
 */
package vmm.surface.parametric;

import vmm.core.RealParamAnimateable;
import vmm.core3D.Vector3D;
import vmm.surface.parametric.SurfaceParametric;

public class Cyclide
extends SurfaceParametric {
    private RealParamAnimateable aa = new RealParamAnimateable("genericParam.aa", "1.75", "1.75", "1.2");
    private RealParamAnimateable bb = new RealParamAnimateable("genericParam.bb", "0.4", "0.4", "1.2");
    private RealParamAnimateable cc = new RealParamAnimateable("genericParam.cc", "0.4", "0.4", "1.2");
    private RealParamAnimateable dd = new RealParamAnimateable("genericParam.dd", "1", "1", "1");
    private RealParamAnimateable ee = new RealParamAnimateable("genericParam.ee", "1", "1", "1");
    private RealParamAnimateable ff = new RealParamAnimateable("genericParam.ff", "1", "1", "1");
    private RealParamAnimateable gg = new RealParamAnimateable("genericParam.gg", "3.25", "3.55", "3.55");
    private RealParamAnimateable hh = new RealParamAnimateable("genericParam.hh", "2.25", "2.25", "2.25");

    public Cyclide() {
        this.uPatchCount.setValueAndDefault(12);
        this.vPatchCount.setValueAndDefault(32);
        this.umin.reset("0");
        this.umax.reset("2 pi");
        this.vmin.reset("0");
        this.vmax.reset("2 pi");
        this.setDefaultViewpoint(new Vector3D(-20.0, -6.0, -6.0));
        this.setDefaultWindow(-3.0, 3.0, -3.0, 3.0);
        this.setDefaultOrientation(2);
        this.addParameter(this.aa);
        this.addParameter(this.bb);
        this.addParameter(this.cc);
        this.addParameter(this.dd);
        this.addParameter(this.ee);
        this.addParameter(this.ff);
        this.addParameter(this.gg);
        this.addParameter(this.hh);
    }

    private static Vector3D Inversion(double d, Vector3D vector3D, Vector3D vector3D2) {
        Vector3D vector3D3 = new Vector3D();
        Vector3D vector3D4 = new Vector3D();
        vector3D3.x = vector3D2.x - vector3D.x;
        vector3D3.y = vector3D2.y - vector3D.y;
        vector3D3.z = vector3D2.z - vector3D.z;
        double d2 = vector3D3.x * vector3D3.x + vector3D3.y * vector3D3.y + vector3D3.z * vector3D3.z;
        double d3 = d / d2;
        vector3D4.x = d3 * vector3D3.x + vector3D.x;
        vector3D4.y = d3 * vector3D3.y + vector3D.y;
        vector3D4.z = d3 * vector3D3.z + vector3D.z;
        return vector3D4;
    }

    public Vector3D surfacePoint(double d, double d2) {
        double d3 = this.aa.getValue();
        double d4 = this.bb.getValue();
        double d5 = this.cc.getValue();
        double d6 = this.dd.getValue();
        double d7 = this.ee.getValue();
        double d8 = this.ff.getValue();
        double d9 = this.gg.getValue();
        double d10 = this.hh.getValue();
        double d11 = (d3 + d4 * Math.cos(d)) * Math.cos(d2);
        double d12 = (d3 + d4 * Math.cos(d)) * Math.sin(d2);
        double d13 = d5 * Math.sin(d);
        Vector3D vector3D = new Vector3D(d6, d7, d8);
        Vector3D vector3D2 = new Vector3D(d11, d12, d13);
        Vector3D vector3D3 = new Vector3D();
        vector3D3 = Cyclide.Inversion(d9, vector3D, vector3D2);
        vector3D3.z += d10;
        return vector3D3;
    }
}

