/*
 * Decompiled with CFR 0.152.
 */
package vmm.surface.parametric;

import vmm.core.RealParamAnimateable;
import vmm.core3D.Vector3D;
import vmm.surface.parametric.SurfaceParametric;

public class CrossCap
extends SurfaceParametric {
    private RealParamAnimateable aa = new RealParamAnimateable("genericParam.aa", 1.3, 1.2, 1.4);

    public CrossCap() {
        this.setDefaultViewpoint(new Vector3D(10.0, -10.0, 10.0));
        this.setDefaultWindow(-2.0, 2.0, -2.0, 2.0);
        this.umin.reset("0");
        this.umax.reset("pi");
        this.vmin.reset("-pi/2");
        this.vmax.reset("pi/2");
        this.uPatchCount.setValueAndDefault(38);
        this.vPatchCount.setValueAndDefault(38);
        this.setDefaultOrientation(2);
        this.addParameter(this.aa);
    }

    private static double sin(double d) {
        return Math.sin(d);
    }

    private static double cos(double d) {
        return Math.cos(d);
    }

    public Vector3D surfacePoint(double d, double d2) {
        double d3 = this.aa.getValue();
        double d4 = d3 * d3;
        return new Vector3D(d4 * (CrossCap.sin(d) * CrossCap.sin(2.0 * d2) / 2.0), d4 * (CrossCap.sin(2.0 * d) * CrossCap.cos(d2) * CrossCap.cos(d2)), d4 * (CrossCap.cos(2.0 * d) * CrossCap.cos(d2) * CrossCap.cos(d2)));
    }
}

