/*
 * Decompiled with CFR 0.152.
 */
package vmm.surface.parametric;

import vmm.core.Complex;
import vmm.core.IntegerParam;
import vmm.core.Parameter;
import vmm.core.RealParamAnimateable;
import vmm.core.View;
import vmm.core3D.ComplexVector3D;
import vmm.core3D.GridTransformMatrix;
import vmm.core3D.Vector3D;
import vmm.surface.parametric.WeierstrassMinimalSurface;

public class CostaHoffmanMeeks
extends WeierstrassMinimalSurface {
    private IntegerParam exponent = new IntegerParam("vmm.surface.parametric.CostaHoffmanMeeks.exponent", 2);
    private RealParamAnimateable lrp = new RealParamAnimateable("vmm.surface.parametric.CostaHoffmanMeeks.lrp", 1.0, 1.2, 0.8);
    private int Ex;
    private int iP;
    private int um;
    private int vm;
    double amp;
    private double r1;
    private double LRP;
    private Complex qP;

    public CostaHoffmanMeeks() {
        this.addParameter(this.lrp);
        this.lrp.setMinimumValueForInput(0.1);
        this.addParameter(this.exponent);
        this.exponent.setMinimumValueForInput(2);
        this.setDefaultOrientation(0);
        this.setDefaultViewpoint(new Vector3D(25.0, 43.0, -10.0));
        this.setDefaultViewUp(new Vector3D(0.1, -0.3, -1.0));
        this.setDefaultWindow(-9.0, 9.0, -8.0, 8.0);
        this.uPatchCount.setValueAndDefault(24);
        this.vPatchCount.setValueAndDefault(12);
        this.umin.reset(-1.9);
        this.umax.reset(2.4);
        this.vmin.reset(-0.99995);
        this.vmax.reset(0.99995);
        this.removeParameter(this.vmin);
        this.removeParameter(this.vmax);
        this.iFirstInHelper = false;
        this.needsPeriodClosed = true;
        this.wantsToSeeDomain = false;
        if (this.wantsToSeeDomain) {
            this.setDefaultViewUp(new Vector3D(0.0, 0.0, 1.0));
            this.setDefaultViewpoint(new Vector3D(0.0, 0.0, 40.0));
        }
        this.canShowConjugateSurface = false;
    }

    public View getDefaultView() {
        WeierstrassMinimalSurface.WMSView wMSView = new WeierstrassMinimalSurface.WMSView(this);
        wMSView.setGridSpacing(6);
        return wMSView;
    }

    public void parameterChanged(Parameter parameter, Object object, Object object2) {
        super.parameterChanged(parameter, object, object2);
        this.AFP = this.afp.getValue();
        if (parameter != this.afp) {
            this.needsValueArray = true;
        }
        if (parameter == this.exponent) {
            this.needsPeriodClosed = true;
            this.LRP = 1.0;
        }
    }

    protected void createData() {
        super.createData();
        this.data.discardGridTransforms();
        GridTransformMatrix[] gridTransformMatrixArray = new GridTransformMatrix[4 * this.Ex];
        gridTransformMatrixArray[0] = new GridTransformMatrix();
        if (!this.inAssociateMorph && !this.wantsToSeeDomain && this.flag0) {
            int n;
            gridTransformMatrixArray[1] = new GridTransformMatrix().scale(1.0, -1.0, 1.0);
            this.data.addGridTransform(gridTransformMatrixArray[1]);
            for (n = 2; n < 2 * this.Ex; ++n) {
                gridTransformMatrixArray[n] = new GridTransformMatrix(gridTransformMatrixArray[n - 2]).rotateZ(360.0 / (double)this.Ex);
                this.data.addGridTransform(gridTransformMatrixArray[n]);
            }
            for (n = 0; n < 2 * this.Ex; ++n) {
                gridTransformMatrixArray[n + 2 * this.Ex] = new GridTransformMatrix(gridTransformMatrixArray[n]).scale(1.0, -1.0, -1.0).rotateZ(180.0 / (double)this.Ex).reverse();
                this.data.addGridTransform(gridTransformMatrixArray[n + 2 * this.Ex]);
            }
        }
    }

    protected Complex domainGrid(double d, double d2) {
        double d3;
        double d4 = Math.exp(CostaHoffmanMeeks.monotonPow(d, 2));
        Complex complex = new Complex(d4 * Math.cos(d3 = Math.PI * Math.sin(d2 * Math.PI / 2.0)) + 1.0, d4 * Math.sin(d3));
        Complex complex2 = complex.squareRootNearer(ONE_C);
        if (complex2.r() < this.amp) {
            complex2.re = Math.max(complex2.re, this.amp - (double)this.Ex * Math.abs(complex.im));
        }
        return complex2;
    }

    protected void p_Index() {
        for (int i = 0; i < this.ucount; ++i) {
            Complex complex = this.domainGrid(this.umin.getValue() + (double)i * this.du, this.vmin.getValue());
            if (!(Math.abs(complex.im) < 1.0E-4)) continue;
            this.iP = i;
        }
    }

    protected Complex gauss(Complex complex) {
        double d = complex.re * complex.re + complex.im * complex.im;
        Complex complex2 = new Complex(complex.re / d - complex.re, -complex.im * (1.0 / d + 1.0));
        Complex complex3 = complex.im > 0.0 ? complex2.logNearer(ZERO_C).times(1.0 / (double)this.Ex) : complex2.logNearer(IP__C).times(1.0 / (double)this.Ex);
        complex2 = complex3.exponential();
        complex2.assignTimes(complex);
        complex2.assignTimes(this.LRP);
        return complex2;
    }

    protected Complex hPrime(Complex complex) {
        Complex complex2 = complex.times(complex);
        double d = ((complex2.re - 1.0) * (complex2.re - 1.0) + complex2.im * complex2.im) / this.r1;
        return new Complex((complex2.re - 1.0) / d, -complex2.im / d);
    }

    protected double closingLopezRos() {
        double d;
        double d2;
        double d3 = this.helperArray[0][this.vm].y.re;
        double d4 = -this.helperArray[0][this.vm].x.re;
        double d5 = -this.helperArray[0][this.vm].y.im;
        double d6 = -this.helperArray[0][this.vm].x.im;
        double d7 = Math.cos(Math.PI / (1.0 * (double)this.Ex)) / Math.sin(Math.PI / (1.0 * (double)this.Ex));
        if (this.Ex != 3) {
            double d8 = this.helperArray[this.iP + 3][this.vcount - 1].y.re;
            double d9 = -this.helperArray[this.iP + 3][this.vcount - 1].x.re;
            double d10 = -this.helperArray[this.iP + 3][this.vcount - 1].y.im;
            double d11 = -this.helperArray[this.iP + 3][this.vcount - 1].x.im;
            double d12 = Math.cos(Math.PI / (2.0 * (double)this.Ex)) / Math.sin(Math.PI / (2.0 * (double)this.Ex));
            d2 = -d5 * d7 - d3 + d10 * d12 + d8;
            d = -d11 * d12 - d9 + d6 * d7 + d4;
        } else {
            double d13 = this.helperArray[this.iP + 3][0].y.re;
            double d14 = -this.helperArray[this.iP + 3][0].x.re;
            double d15 = -this.helperArray[this.iP + 3][0].y.im;
            double d16 = -this.helperArray[this.iP + 3][0].x.im;
            double d17 = Math.cos(Math.PI * 3 / (2.0 * (double)this.Ex)) / Math.sin(Math.PI * 3 / (2.0 * (double)this.Ex));
            d2 = -d5 * d7 - d3 + d15 * d17 - d13;
            d = -d16 * d17 + d14 + d6 * d7 + d4;
        }
        double d18 = Math.sqrt(d2 / d);
        this.LRP = d18 * this.lrp.getValue();
        return d18;
    }

    protected void doClosingJob() {
        this.LRPclosed = this.closingLopezRos();
        this.createHelperArray();
    }

    protected void redoConstants() {
        super.redoConstants();
        this.LRP = this.needsPeriodClosed ? 1.0 : this.LRPclosed * this.lrp.getValue();
        this.Ex = this.exponent.getValue();
        this.r1 = 1.0;
        this.amp = 4.8828125E-4 / (double)this.Ex / (double)this.Ex / (double)this.Ex;
        this.p_Index();
        this.um = (int)Math.floor((double)(this.ucount - 1) / 2.0);
        this.vm = (int)Math.floor((double)(this.vcount - 1) / 2.0);
    }

    protected ComplexVector3D getCenter() {
        if (this.inAssociateMorph || this.wantsToSeeDomain) {
            return new ComplexVector3D(this.helperArray[this.um][this.vm]);
        }
        ComplexVector3D complexVector3D = this.helperToMinimal(this.helperArray[0][0]);
        ComplexVector3D complexVector3D2 = this.helperToMinimal(this.helperArray[8][0]);
        ComplexVector3D complexVector3D3 = this.helperToMinimal(this.helperArray[this.um][this.vm]);
        ComplexVector3D complexVector3D4 = this.helperToMinimal(this.helperArray[this.ucount - 1][this.vm]);
        ComplexVector3D complexVector3D5 = this.helperToMinimal(this.helperArray[this.ucount - 1][0]);
        Complex complex = new Complex(complexVector3D3.x.re, complexVector3D3.y.re);
        Complex complex2 = new Complex(complexVector3D4.x.re, complexVector3D4.y.re);
        Complex complex3 = new Complex(complexVector3D2.x.re, complexVector3D2.y.re);
        Complex complex4 = new Complex(complexVector3D.x.re, complexVector3D.y.re);
        Complex complex5 = this.intersectLines(complex, complex2, complex3, complex4);
        return this.minimalToHelper(new ComplexVector3D(complex5, complex5.times(I__C), complexVector3D5.z));
    }

    public Vector3D surfacePoint(double d, double d2) {
        ComplexVector3D complexVector3D;
        int n = (int)Math.floor(0.25 + (d - this.umin.getValue()) / this.du);
        int n2 = (int)Math.floor(0.25 + (d2 - this.vmin.getValue()) / this.dv);
        if (!(this.lrp.getValue() != 1.0 || this.inAssociateMorph || this.wantsToSeeDomain || n != this.iP + 1 || n2 != this.vcount - 1 && n2 != 0)) {
            complexVector3D = new ComplexVector3D(ComplexVector3D.ORIGIN);
        } else {
            ComplexVector3D complexVector3D2 = new ComplexVector3D(this.helperArray[n][n2].plus(this.ComplexVectorOneStepIntegrator(this.domainGrid(this.umin.getValue() + (double)n * this.du, this.vmin.getValue() + (double)n2 * this.dv), this.domainGrid(d, d2))));
            complexVector3D = this.helperToMinimal(complexVector3D2);
        }
        if (this.wantsToSeeDomain) {
            return new Vector3D(complexVector3D.z.re, complexVector3D.z.im, 0.0);
        }
        if (this.AFP == 0.0) {
            return complexVector3D.re();
        }
        return complexVector3D.re().times(Math.cos(this.AFP)).plus(complexVector3D.im().times(Math.sin(this.AFP)));
    }
}

