/*
 * Decompiled with CFR 0.152.
 */
package vmm.surface.parametric;

import java.awt.event.ActionEvent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import vmm.actions.AbstractActionVMM;
import vmm.actions.ActionList;
import vmm.core.BasicAnimator;
import vmm.core.I18n;
import vmm.core.Parameter;
import vmm.core.RealParamAnimateable;
import vmm.core.View;
import vmm.core3D.Vector3D;
import vmm.surface.parametric.SurfaceParametric;

public class ConstCurvOneHelicoids
extends SurfaceParametric {
    private RealParamAnimateable aa = new RealParamAnimateable("vmm.surface.parametric.ConstCurvOneHelicoids.aa", "1.2", "1.2", "1.2");
    private RealParamAnimateable hh = new RealParamAnimateable("vmm.surface.parametric.ConstCurvOneHelicoids.hh", "0.2", "0", "0.7");
    double AA = this.aa.getValue();
    double HH = this.hh.getValue() / Math.max(1.0, Math.abs(this.hh.getValue() / this.AA));
    boolean needsNewArray = true;
    boolean in2ndMorph = false;
    double r0 = this.helRad(0.0);
    double DU;
    int tr;
    Vector3D startPoint = new Vector3D(this.r0, 0.0, 0.0);
    Vector3D[] TransversCurve;

    public ConstCurvOneHelicoids() {
        this.addParameter(this.hh);
        this.addParameter(this.aa);
        this.uPatchCount.setValueAndDefault(10);
        this.vPatchCount.setValueAndDefault(30);
        this.tr = 1 + this.uPatchCount.getValue() * 6;
        this.umax.reset(this.findUmax());
        this.umin.reset(-this.umax.getValue());
        this.DU = (this.umax.getValue() - this.umin.getValue()) / (double)(this.tr - 1);
        this.vmin.reset("0");
        this.vmax.reset(Math.PI * 2);
        this.setDefaultViewpoint(new Vector3D(10.0, -20.0, 10.0));
        this.setDefaultWindow(-0.8, 4.0, -1.8, 1.5);
        this.setDefaultOrientation(0);
    }

    public void parameterChanged(Parameter parameter, Object object, Object object2) {
        super.parameterChanged(parameter, object, object2);
        this.needsNewArray = true;
    }

    protected void createData() {
        if (this.needsNewArray) {
            this.redoConstantsAndArray();
        }
        super.createData();
    }

    public void redoConstantsAndArray() {
        this.AA = this.aa.getValue();
        this.HH = this.hh.getValue() / Math.max(1.0, Math.abs(this.hh.getValue() / this.AA));
        this.umax.reset(this.findUmax());
        this.umin.reset(-this.umax.getValue());
        this.r0 = this.helRad(0.0);
        if (this.in2ndMorph) {
            this.vmax.reset(Math.PI * 2 / this.r0);
        } else {
            this.vmax.reset(Math.PI * 2);
        }
        this.tr = 1 + this.uPatchCount.getValue() * 6;
        this.DU = (this.umax.getValue() - this.umin.getValue()) / (double)(this.tr - 1);
        this.startPoint = new Vector3D(this.r0, 0.0, 0.0);
        this.TransversCurve = new Vector3D[this.tr];
        this.createCurveArray();
    }

    private double findUmax() {
        double d = this.AA * this.AA;
        double d2 = (d - 1.0) / (2.0 * d);
        double d3 = Math.sqrt(Math.abs(Math.sqrt(this.HH * this.HH / d / d + d2 * d2) + d2));
        double d4 = this.in2ndMorph ? Math.min(0.5, Math.acos(d3)) : Math.acos(d3);
        return d4;
    }

    private double helRad(double d) {
        double d2 = 0.0;
        double d3 = this.AA * this.AA * Math.cos(d) * Math.cos(d) - this.HH * this.HH;
        if (d3 > 0.0) {
            d2 = Math.sqrt(d3);
        }
        return d2;
    }

    private double dHelRad(double d) {
        double d2 = 0.0;
        double d3 = 2.0 * this.helRad(d);
        if (d3 > 0.0) {
            d2 = -this.AA * this.AA * Math.sin(2.0 * d) / d3;
        }
        return d2;
    }

    private Vector3D nRadial(double d, double d2) {
        double d3 = Math.sqrt(d * d + d2 * d2);
        Vector3D vector3D = new Vector3D(0.0, 0.0, 0.0);
        if (d3 > 0.0) {
            vector3D = new Vector3D(d / d3, d2 / d3, 0.0);
        }
        return vector3D;
    }

    private Vector3D nZylinder(double d, double d2) {
        double d3 = d * d + d2 * d2;
        double d4 = Math.sqrt(d3 + this.HH * this.HH);
        Vector3D vector3D = new Vector3D(0.0, 0.0, 0.0);
        if (d4 > 0.0) {
            d3 = Math.sqrt(d3);
            double d5 = this.HH / (d3 * d4);
            vector3D = new Vector3D(d2 * d5, -d * d5, d3 / d4);
        }
        return vector3D;
    }

    public ActionList getAdditionalAnimationsForView(final View view) {
        ActionList actionList = super.getAdditionalAnimationsForView(view);
        actionList.add(new AbstractActionVMM(I18n.tr("vmm.surface.parametric.ConstCurvOneHelicoids.IsometricMorph")){

            public void actionPerformed(ActionEvent actionEvent) {
                BasicAnimator basicAnimator = new BasicAnimator();
                basicAnimator.setLooping(2);
                basicAnimator.setUseFilmstrip(ConstCurvOneHelicoids.this.getUseFilmstripForMorphing());
                basicAnimator.setFrames(ConstCurvOneHelicoids.this.getFramesForMorphing());
                basicAnimator.setMillisecondsPerFrame(200);
                double d = 0.4;
                double d2 = 1.5;
                ConstCurvOneHelicoids.this.HH = 0.2;
                ConstCurvOneHelicoids.this.AA = d2;
                double d3 = ConstCurvOneHelicoids.this.findUmax();
                basicAnimator.addWithCustomValue(ConstCurvOneHelicoids.this.hh, ConstCurvOneHelicoids.this.HH);
                basicAnimator.addWithCustomLimits(ConstCurvOneHelicoids.this.aa, d, d2);
                basicAnimator.addWithCustomValue(ConstCurvOneHelicoids.this.uPatchCount, 6);
                basicAnimator.addWithCustomValue(ConstCurvOneHelicoids.this.vPatchCount, 36);
                basicAnimator.addWithCustomValue(ConstCurvOneHelicoids.this.umin, -d3);
                basicAnimator.addWithCustomValue(ConstCurvOneHelicoids.this.umax, d3);
                basicAnimator.addWithCustomValue(ConstCurvOneHelicoids.this.vmin, 0.0);
                basicAnimator.addWithCustomValue(ConstCurvOneHelicoids.this.vmax, Math.PI);
                basicAnimator.addChangeListener(new ChangeListener(){

                    public void stateChanged(ChangeEvent changeEvent) {
                        ConstCurvOneHelicoids.this.in2ndMorph = ((BasicAnimator)changeEvent.getSource()).isRunning();
                    }
                });
                view.getDisplay().installAnimation(basicAnimator);
            }
        });
        return actionList;
    }

    public Vector3D surfacePoint(double d, double d2) {
        Vector3D vector3D = new Vector3D();
        int n = (int)Math.round((d - this.umin.getValue()) / this.DU);
        double d3 = this.umin.getValue() + this.DU * (double)n;
        vector3D = d == d3 ? this.TransversCurve[n] : this.midpointODEstep(d3, d, this.TransversCurve[n], 8);
        double d4 = vector3D.x * Math.cos(d2) - vector3D.y * Math.sin(d2);
        double d5 = vector3D.x * Math.sin(d2) + vector3D.y * Math.cos(d2);
        double d6 = vector3D.z + this.HH * d2;
        return new Vector3D(d6, -d5, d4);
    }

    protected Vector3D midpointODEstep(double d, double d2, Vector3D vector3D, int n) {
        double d3 = d;
        int n2 = (int)Math.round(1.0 + Math.abs(d2 - d)) * n;
        double d4 = (d2 - d) / (double)n2;
        Vector3D vector3D2 = new Vector3D(vector3D);
        for (int i = 0; i < n2; ++i) {
            double d5 = this.dHelRad(d3);
            Vector3D vector3D3 = this.nRadial(vector3D2.x, vector3D2.y);
            vector3D3 = vector3D3.linComb(d5, Math.sqrt(1.0 - d5 * d5), this.nZylinder(vector3D2.x, vector3D2.y));
            Vector3D vector3D4 = vector3D2.plus(vector3D3.times(d4 / 2.0));
            d5 = this.dHelRad(d3 += d4 / 2.0);
            Vector3D vector3D5 = this.nRadial(vector3D4.x, vector3D4.y);
            vector3D5 = vector3D5.linComb(d5, Math.sqrt(1.0 - d5 * d5), this.nZylinder(vector3D4.x, vector3D4.y));
            vector3D2 = vector3D2.plus(vector3D5.times(d4));
            d3 += d4 / 2.0;
        }
        return new Vector3D(vector3D2);
    }

    private void createCurveArray() {
        double d = this.umin.getValue();
        this.TransversCurve[0] = this.midpointODEstep(0.0, d, this.startPoint, 32);
        for (int i = 1; i < this.tr; ++i) {
            double d2 = d + (double)(i - 1) * this.DU;
            this.TransversCurve[i] = this.midpointODEstep(d2, d2 + this.DU, this.TransversCurve[i - 1], 8);
        }
        this.needsNewArray = false;
    }
}

