/*
 * Decompiled with CFR 0.152.
 */
package vmm.surface.parametric;

import java.awt.event.ActionEvent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import vmm.actions.AbstractActionVMM;
import vmm.actions.ActionList;
import vmm.core.BasicAnimator;
import vmm.core.I18n;
import vmm.core.Parameter;
import vmm.core.RealParamAnimateable;
import vmm.core.View;
import vmm.core3D.Vector3D;
import vmm.surface.parametric.SurfaceParametric;

public class ConstCurvFamilyOfRevolution
extends SurfaceParametric {
    private RealParamAnimateable aa = new RealParamAnimateable("vmm.surface.parametric.ConstCurvFamilyOfRevolution.aa", "0.7", "0.5", "1.5");
    boolean needsNewRange = true;
    boolean in2ndMorph = false;
    double AA = this.aa.getValue();

    public ConstCurvFamilyOfRevolution() {
        this.uPatchCount.setValueAndDefault(12);
        this.vPatchCount.setValueAndDefault(12);
        this.vmin.reset("0");
        this.vmax.reset(Math.PI * 2);
        this.umin.reset("-1.57");
        this.umax.reset("1.57");
        this.setDefaultViewpoint(new Vector3D(10.0, -10.0, 10.0));
        this.setDefaultWindow(-1.5, 1.5, -1.5, 1.5);
        this.setDefaultOrientation(2);
        this.addParameter(this.aa);
    }

    public void parameterChanged(Parameter parameter, Object object, Object object2) {
        super.parameterChanged(parameter, object, object2);
        this.needsNewRange = true;
    }

    protected void createData() {
        this.AA = this.aa.getValue();
        if (this.needsNewRange && !this.in2ndMorph) {
            this.redoConstants();
        }
        super.createData();
    }

    public void redoConstants() {
        double d = Math.asin(Math.min(1.0, 1.0 / this.AA));
        this.umax.reset(Math.min(d - 1.0E-5, 1.5707963267948966));
        this.umin.reset(-this.umax.getValue());
        this.needsNewRange = false;
    }

    public ActionList getAdditionalAnimationsForView(final View view) {
        ActionList actionList = super.getAdditionalAnimationsForView(view);
        actionList.add(new AbstractActionVMM(I18n.tr("vmm.surface.parametric.ConstCurvFamilyOfRevolution.IsometricMorph")){

            public void actionPerformed(ActionEvent actionEvent) {
                BasicAnimator basicAnimator = new BasicAnimator();
                basicAnimator.setLooping(2);
                basicAnimator.setUseFilmstrip(ConstCurvFamilyOfRevolution.this.getUseFilmstripForMorphing());
                basicAnimator.setFrames(ConstCurvFamilyOfRevolution.this.getFramesForMorphing());
                basicAnimator.setMillisecondsPerFrame(200);
                double d = 0.5;
                double d2 = 1.5;
                double d3 = Math.min(Math.asin(Math.min(1.0, 1.0 / d2)) - 1.0E-6, 1.5707963267948966);
                basicAnimator.addWithCustomLimits(ConstCurvFamilyOfRevolution.this.aa, d, d2);
                basicAnimator.addWithCustomValue(ConstCurvFamilyOfRevolution.this.uPatchCount, 10);
                basicAnimator.addWithCustomValue(ConstCurvFamilyOfRevolution.this.vPatchCount, 20);
                basicAnimator.addWithCustomValue(ConstCurvFamilyOfRevolution.this.umin, -d3);
                basicAnimator.addWithCustomValue(ConstCurvFamilyOfRevolution.this.umax, d3);
                basicAnimator.addWithCustomLimits(ConstCurvFamilyOfRevolution.this.vmin, 0.0, 0.0);
                basicAnimator.addWithCustomLimits(ConstCurvFamilyOfRevolution.this.vmax, Math.PI, Math.PI);
                basicAnimator.addChangeListener(new ChangeListener(){

                    public void stateChanged(ChangeEvent changeEvent) {
                        ConstCurvFamilyOfRevolution.this.in2ndMorph = ((BasicAnimator)changeEvent.getSource()).isRunning();
                    }
                });
                view.getDisplay().installAnimation(basicAnimator);
            }
        });
        return actionList;
    }

    public Vector3D surfacePoint(double d, double d2) {
        double d3;
        double d4;
        if (this.in2ndMorph) {
            d4 = this.AA * Math.cos(d) * Math.cos(d2 / this.AA);
            d3 = this.AA * Math.cos(d) * Math.sin(d2 / this.AA);
        } else {
            d4 = this.AA * Math.cos(d) * Math.cos(d2);
            d3 = this.AA * Math.cos(d) * Math.sin(d2);
        }
        double d5 = this.height(d);
        return new Vector3D(d4, d3, d5);
    }

    private double integrand(double d) {
        return Math.sqrt(1.0 - this.AA * this.AA * Math.sin(d) * Math.sin(d));
    }

    private double height(double d) {
        long l = 2L * Math.round(2.0 + 8.0 * Math.abs(d));
        double d2 = 0.0;
        double d3 = this.integrand(0.0);
        if (d != 0.0) {
            double d4 = d / (double)l;
            int n = 1;
            while ((long)n < l) {
                d3 = this.integrand((double)n * d4);
                d2 += 4.0 * d3;
                d3 = this.integrand((double)(n + 1) * d4);
                d2 += 2.0 * d3;
                n += 2;
            }
            d2 = (d2 - d3) * d4 / 3.0;
        }
        return d2;
    }
}

