/*
 * Decompiled with CFR 0.152.
 */
package vmm.surface.parametric;

import vmm.core.RealParamAnimateable;
import vmm.core3D.Vector3D;
import vmm.surface.parametric.SurfaceParametric;

public class Conoid
extends SurfaceParametric {
    private RealParamAnimateable aa = new RealParamAnimateable("vmm.surface.parametric.Conoid.aa", "1", "1", "1");
    private RealParamAnimateable bb = new RealParamAnimateable("vmm.surface.parametric.Conoid.bb", 1.0, 1.0, 12.0);

    public Conoid() {
        this.uPatchCount.setValueAndDefault(16);
        this.vPatchCount.setValueAndDefault(16);
        this.umin.reset("-1");
        this.umax.reset("1");
        this.vmin.reset("-pi");
        this.vmax.reset("pi");
        this.setDefaultViewpoint(new Vector3D(10.0, -10.0, 10.0));
        this.setDefaultWindow(-2.5, 2.5, -2.5, 2.5);
        this.addParameter(this.aa);
        this.addParameter(this.bb);
        this.setFramesForMorphing(11);
    }

    private static double cos(double d) {
        return Math.cos(d);
    }

    private static double sin(double d) {
        return Math.sin(d);
    }

    public Vector3D surfacePoint(double d, double d2) {
        double d3 = this.aa.getValue();
        double d4 = this.bb.getValue();
        double d5 = d * Conoid.cos(d2);
        double d6 = d * Conoid.sin(d2);
        double d7 = d3 * Conoid.sin(d4 * d2);
        return new Vector3D(d5, d6, d7);
    }
}

