/*
 * Decompiled with CFR 0.152.
 */
package vmm.surface.parametric;

import java.awt.Color;
import vmm.core.Complex;
import vmm.core.IntegerParam;
import vmm.core.Parameter;
import vmm.core.RealParamAnimateable;
import vmm.core.View;
import vmm.core3D.ComplexVector3D;
import vmm.core3D.GridTransformMatrix;
import vmm.core3D.Vector3D;
import vmm.surface.parametric.WeierstrassMinimalSurface;

public class ChenGackstatter
extends WeierstrassMinimalSurface {
    private IntegerParam exponent = new IntegerParam("vmm.surface.parametric.ChenGackstatter.exponent", 3);
    private RealParamAnimateable lrp = new RealParamAnimateable("vmm.surface.parametric.ChenGackstatter.lrp", 1.0, 0.7, 1.1);
    protected int Ex;
    protected int iP;
    protected int um;
    protected int vm;
    double amp;
    protected double r1;
    protected double LRP;

    public ChenGackstatter() {
        this.addParameter(this.lrp);
        this.lrp.setMinimumValueForInput(0.1);
        this.addParameter(this.exponent);
        this.exponent.setMinimumValueForInput(2);
        this.exponent.setMaximumValueForInput(11);
        this.setDefaultOrientation(0);
        this.setDefaultViewpoint(new Vector3D(38.4, 30.7, -11.2));
        this.setDefaultViewUp(new Vector3D(-0.125, -0.2, -0.97));
        this.setDefaultWindow(-7.5, 7.5, -6.0, 6.0);
        this.uPatchCount.setValueAndDefault(18);
        this.vPatchCount.setValueAndDefault(12);
        this.umin.reset(-0.9);
        this.umax.reset(1.72);
        this.umax.setMinimumValueForInput(0.2);
        this.vmin.reset(-0.9995);
        this.vmax.reset(0.9995);
        this.removeParameter(this.umin);
        this.removeParameter(this.vmin);
        this.removeParameter(this.vmax);
        this.iFirstInHelper = false;
        this.iBeginMiddleInHelper = true;
        this.needsPeriodClosed = true;
        this.wantsToSeeDomain = false;
        if (this.wantsToSeeDomain) {
            this.setDefaultViewUp(new Vector3D(0.0, 0.0, 1.0));
            this.setDefaultViewpoint(new Vector3D(0.0, 0.0, 40.0));
        }
        this.canShowConjugateSurface = false;
    }

    public View getDefaultView() {
        WeierstrassMinimalSurface.WMSView wMSView = new WeierstrassMinimalSurface.WMSView(this);
        wMSView.setGridSpacing(6);
        float f = 0.34f;
        wMSView.getLightSettings().setLight0(new Color(f, f, f));
        wMSView.getLightSettings().getDirectionalLight2().setItsColor(new Color(0.5f, 1.0f, 0.0f));
        wMSView.getLightSettings().getDirectionalLight2().setItsDirection(new Vector3D(0.66, -0.34, -0.66));
        wMSView.getLightSettings().getDirectionalLight3().setItsDirection(new Vector3D(0.57, 0.2, -0.8));
        wMSView.getLightSettings().setSpecularExponent(55);
        wMSView.getLightSettings().setSpecularRatio(0.5f);
        return wMSView;
    }

    public void parameterChanged(Parameter parameter, Object object, Object object2) {
        super.parameterChanged(parameter, object, object2);
        this.AFP = this.afp.getValue();
        if (parameter != this.afp) {
            this.needsValueArray = true;
        }
        if (parameter == this.exponent) {
            this.needsPeriodClosed = true;
            this.LRP = 1.0;
            if (parameter != this.umax) {
                this.umax.reset(Math.max(0.9, 1.9 - ((double)this.exponent.getValue() - 2.0) * 0.18));
            }
            super.parameterChanged(parameter, object, object2);
        }
    }

    protected void createData() {
        super.createData();
        this.data.discardGridTransforms();
        GridTransformMatrix[] gridTransformMatrixArray = new GridTransformMatrix[4 * this.Ex];
        gridTransformMatrixArray[0] = new GridTransformMatrix();
        if (!this.inAssociateMorph && !this.wantsToSeeDomain && this.flag0) {
            int n;
            gridTransformMatrixArray[1] = new GridTransformMatrix().scale(1.0, -1.0, 1.0);
            this.data.addGridTransform(gridTransformMatrixArray[1]);
            for (n = 2; n < 2 * this.Ex; ++n) {
                gridTransformMatrixArray[n] = new GridTransformMatrix(gridTransformMatrixArray[n - 2]).rotateZ(360.0 / (double)this.Ex);
                this.data.addGridTransform(gridTransformMatrixArray[n]);
            }
            if (this.flag0) {
                for (n = 0; n < 2 * this.Ex; ++n) {
                    gridTransformMatrixArray[n + 2 * this.Ex] = new GridTransformMatrix(gridTransformMatrixArray[n]).scale(1.0, -1.0, -1.0).rotateZ(180.0 / (double)this.Ex).reverse();
                    this.data.addGridTransform(gridTransformMatrixArray[n + 2 * this.Ex]);
                }
            }
        }
    }

    protected Complex domainGrid(double d, double d2) {
        double d3;
        double d4 = ChenGackstatter.myRad(d, this.Ex);
        Complex complex = new Complex(d4 * Math.cos(d3 = Math.PI * Math.sin(d2 * Math.PI / 2.0)) + 1.0, d4 * Math.sin(d3));
        Complex complex2 = complex.squareRootNearer(ONE_C);
        double d5 = complex2.r();
        if (d5 < this.amp) {
            complex2.assignTimes(Math.max(1.0, (this.amp - d5) / d5));
        }
        return complex2;
    }

    protected void p_Index() {
        for (int i = 0; i < this.ucount; ++i) {
            Complex complex = this.domainGrid(this.umin.getValue() + (double)i * this.du, this.vmin.getValue());
            if (!(complex.re > 1.0E-4) || !(Math.abs(complex.im) < 1.0E-4)) continue;
            this.iP = i;
        }
        this.iP += (int)Math.floor(((double)this.Ex - 3.0) * ((double)this.Ex - 2.0) / 2.0);
    }

    protected static double myRad(double d, int n) {
        if (d <= -1.0) {
            return 0.0;
        }
        if (d <= 0.0) {
            return 1.0 + ChenGackstatter.monotonPow(-1.0 + ChenGackstatter.monotonPow(d + 1.0, (int)Math.floor(2.0 + (double)n / 2.0)), n);
        }
        return 1.0 + ChenGackstatter.monotonPow(d, n) * (double)n / ((double)n - 1.0);
    }

    protected Complex gauss(Complex complex) {
        double d = complex.re * complex.re + complex.im * complex.im;
        Complex complex2 = new Complex(complex.re / d - complex.re, -complex.im * (1.0 / d + 1.0));
        Complex complex3 = complex.im > 0.0 ? complex2.logNearer(ZERO_C).times(1.0 - 1.0 / (double)this.Ex) : complex2.logNearer(IP__C).times(1.0 - 1.0 / (double)this.Ex);
        complex2 = complex3.exponential();
        complex2.assignTimes(this.LRP);
        return complex2;
    }

    protected Complex hPrime(Complex complex) {
        return new Complex(this.r1, 0.0);
    }

    protected double closingLopezRos() {
        int n = this.ucount - 1 - this.iP;
        int n2 = Math.min(40, this.ucount - 6);
        double d = this.helperArray[n2][this.vm].y.re;
        double d2 = -this.helperArray[n2][this.vm].x.re;
        double d3 = -this.helperArray[n2][this.vm].y.im;
        double d4 = -this.helperArray[n2][this.vm].x.im;
        double d5 = Math.cos(Math.PI / (1.0 * (double)this.Ex)) / Math.sin(Math.PI / (1.0 * (double)this.Ex));
        double d6 = this.helperArray[this.iP + n][this.vcount - 1].y.re;
        double d7 = -this.helperArray[this.iP + n][this.vcount - 1].x.re;
        double d8 = -this.helperArray[this.iP + n][this.vcount - 1].y.im;
        double d9 = -this.helperArray[this.iP + n][this.vcount - 1].x.im;
        double d10 = Math.cos(Math.PI / (2.0 * (double)this.Ex)) / Math.sin(Math.PI / (2.0 * (double)this.Ex));
        double d11 = d3 * d5 - d - d8 * d10 + d6;
        double d12 = d9 * d10 - d7 - d4 * d5 + d2;
        double d13 = Math.min(Math.sqrt(d11 / d12), Math.sqrt((d8 * d10 - d6) / (d7 - d9 * d10)));
        d6 = this.helperArray[this.iP + n][0].y.re;
        d7 = -this.helperArray[this.iP + n][0].x.re;
        d8 = -this.helperArray[this.iP + n][0].y.im;
        d9 = -this.helperArray[this.iP + n][0].x.im;
        d10 = Math.cos(Math.PI * 3 / (2.0 * (double)this.Ex)) / Math.sin(Math.PI * 3 / (2.0 * (double)this.Ex));
        d11 = d3 * d5 - d - d8 * d10 + d6;
        d12 = d9 * d10 - d7 - d4 * d5 + d2;
        double d14 = Math.min(Math.sqrt(d11 / d12), Math.sqrt((d8 * d10 - d6) / (d7 - d9 * d10)));
        d13 = Math.min(d13, d14);
        for (int i = 1; i < 3; ++i) {
            this.LRP = d13;
            this.createHelperArray();
            double d15 = this.helperArray[this.iP + n][0].y.re;
            double d16 = -this.helperArray[this.iP + n][0].x.re;
            double d17 = -this.helperArray[this.iP + n][0].y.im;
            double d18 = -this.helperArray[this.iP + n][0].x.im;
            double d19 = Math.cos(Math.PI * 3 / (2.0 * (double)this.Ex)) / Math.sin(Math.PI * 3 / (2.0 * (double)this.Ex));
            d13 *= Math.sqrt((d17 * d19 - d15) / (d16 - d18 * d19));
        }
        this.LRP = d13 * this.lrp.getValue();
        return d13;
    }

    protected void doClosingJob() {
        this.LRPclosed = this.closingLopezRos();
        this.createHelperArray();
    }

    protected void redoConstants() {
        super.redoConstants();
        this.LRP = this.needsPeriodClosed ? 1.0 : this.LRPclosed * this.lrp.getValue();
        this.Ex = this.exponent.getValue();
        this.r1 = 1.0 * Math.sqrt(Math.sqrt(2.0 / (double)this.Ex));
        this.amp = 1.0 / (double)(this.Ex * this.Ex * this.Ex * this.Ex * this.Ex * this.Ex * this.Ex * this.Ex * this.Ex * this.Ex);
        this.p_Index();
        this.um = (int)Math.floor((double)(this.ucount - 1) / 2.0);
        this.vm = (int)Math.floor((double)(this.vcount - 1) / 2.0);
    }

    protected ComplexVector3D getCenter() {
        if (this.inAssociateMorph) {
            return new ComplexVector3D(this.helperArray[this.um][this.vm]);
        }
        ComplexVector3D complexVector3D = this.helperToMinimal(this.helperArray[18][0]);
        ComplexVector3D complexVector3D2 = this.helperToMinimal(this.helperArray[30][0]);
        ComplexVector3D complexVector3D3 = this.helperToMinimal(this.helperArray[12][this.vm]);
        ComplexVector3D complexVector3D4 = this.helperToMinimal(this.helperArray[this.um][this.vm]);
        ComplexVector3D complexVector3D5 = this.helperToMinimal(this.helperArray[this.ucount - 1][0]);
        Complex complex = new Complex(complexVector3D3.x.re, complexVector3D3.y.re);
        Complex complex2 = new Complex(complexVector3D4.x.re, complexVector3D4.y.re);
        Complex complex3 = new Complex(complexVector3D2.x.re, complexVector3D2.y.re);
        Complex complex4 = new Complex(complexVector3D.x.re, complexVector3D.y.re);
        Complex complex5 = this.intersectLines(complex, complex2, complex3, complex4);
        return this.minimalToHelper(new ComplexVector3D(complex5, complex5.times(I__C), complexVector3D5.z));
    }

    public Vector3D surfacePoint(double d, double d2) {
        ComplexVector3D complexVector3D;
        int n = (int)Math.floor(0.25 + (d - this.umin.getValue()) / this.du);
        int n2 = (int)Math.floor(0.25 + (d2 - this.vmin.getValue()) / this.dv);
        if (!(this.lrp.getValue() != 1.0 || this.inAssociateMorph || this.wantsToSeeDomain || n <= this.iP - this.Ex + 2 || n >= this.iP + this.Ex || n2 != this.vcount - 1 && n2 != 0)) {
            complexVector3D = new ComplexVector3D(ComplexVector3D.ORIGIN);
        } else {
            ComplexVector3D complexVector3D2 = new ComplexVector3D(this.helperArray[n][n2].plus(this.ComplexVectorOneStepIntegrator(this.domainGrid(this.umin.getValue() + (double)n * this.du, this.vmin.getValue() + (double)n2 * this.dv), this.domainGrid(d, d2))));
            complexVector3D = this.helperToMinimal(complexVector3D2);
            if (this.lrp.getValue() == 1.0 && !this.inAssociateMorph && !this.wantsToSeeDomain && n == 0) {
                complexVector3D.assign(ZERO_C, ZERO_C, complexVector3D.z);
            }
        }
        if (this.wantsToSeeDomain) {
            return new Vector3D(complexVector3D.z.re, complexVector3D.z.im, 0.0);
        }
        if (this.AFP == 0.0) {
            return complexVector3D.re();
        }
        return complexVector3D.re().times(Math.cos(this.AFP)).plus(complexVector3D.im().times(Math.sin(this.AFP)));
    }
}

