/*
 * Decompiled with CFR 0.152.
 */
package vmm.surface.parametric;

import vmm.core.RealParamAnimateable;
import vmm.core3D.Vector3D;
import vmm.surface.parametric.SurfaceParametric;

public class Catenoid_Helicoid
extends SurfaceParametric {
    private RealParamAnimateable aa = new RealParamAnimateable("genericParam.aa", "0", "0", "pi/2");
    private RealParamAnimateable bb = new RealParamAnimateable("genericParam.bb", 0.5, 0.5, 0.5);

    public Catenoid_Helicoid() {
        this.uPatchCount.setValueAndDefault(16);
        this.vPatchCount.setValueAndDefault(10);
        this.umin.reset("-pi");
        this.umax.reset("pi");
        this.vmin.reset(-1.6);
        this.vmax.reset(1.6);
        this.setDefaultViewpoint(new Vector3D(10.0, -10.0, 10.0));
        this.setDefaultWindow(-2.5, 2.5, -2.5, 2.5);
        this.addParameter(this.aa);
        this.addParameter(this.bb);
    }

    private static double sinh(double d) {
        return 0.5 * (Math.exp(d) - Math.exp(-d));
    }

    private static double cosh(double d) {
        return 0.5 * (Math.exp(d) + Math.exp(-d));
    }

    public Vector3D surfacePoint(double d, double d2) {
        double d3 = this.aa.getValue();
        double d4 = this.bb.getValue();
        double d5 = d4 * (Math.cos(d3) * Catenoid_Helicoid.sinh(d2) * Math.sin(d) + Math.sin(d3) * Catenoid_Helicoid.cosh(d2) * Math.cos(d));
        double d6 = d4 * (-Math.cos(d3) * Catenoid_Helicoid.sinh(d2) * Math.cos(d) + Math.sin(d3) * Catenoid_Helicoid.cosh(d2) * Math.sin(d));
        double d7 = d4 * (Math.cos(d3) * d + Math.sin(d3) * d2);
        return new Vector3D(d5, d6, d7);
    }
}

