/*
 * Decompiled with CFR 0.152.
 */
package vmm.surface.parametric;

import vmm.core.Complex;
import vmm.core.IntegerParam;
import vmm.core.Parameter;
import vmm.core.RealParamAnimateable;
import vmm.core.View;
import vmm.core3D.ComplexVector3D;
import vmm.core3D.GridTransformMatrix;
import vmm.core3D.Vector3D;
import vmm.surface.parametric.WeierstrassMinimalSurface;

public class CatenoidFence
extends WeierstrassMinimalSurface {
    private RealParamAnimateable aa = new RealParamAnimateable("vmm.surface.parametric.CatenoidFence.aa", 0.0, -2.0, 2.0);
    private IntegerParam pieces = new IntegerParam("vmm.surface.parametric.CatenoidFence.pieces", 1);
    private int jP;
    private int um;
    private int vm;
    double amp = 0.04;
    private double P;
    private double PL;
    private double r1;
    private double R;
    private double R_;
    private double PR;
    private Complex qP;
    private ComplexVector3D halfPeriodII;

    public CatenoidFence() {
        this.addParameter(this.pieces);
        this.addParameter(this.aa);
        this.setDefaultOrientation(0);
        this.setDefaultViewpoint(new Vector3D(25.0, 43.0, -10.0));
        this.setDefaultViewUp(new Vector3D(0.1, -0.3, -1.0));
        this.setDefaultWindow(-7.5, 7.5, -6.0, 6.0);
        this.uPatchCount.setValueAndDefault(18);
        this.vPatchCount.setValueAndDefault(18);
        this.vmax.reset(3.0);
        this.vmin.reset(-this.vmax.getValue());
        this.umin.reset(-3.141492653589793);
        this.umax.reset(3.141492653589793);
        this.removeParameter(this.vmin);
        this.removeParameter(this.umax);
        this.removeParameter(this.umin);
        this.wantsToSeeDomain = false;
        if (this.wantsToSeeDomain) {
            this.setDefaultViewUp(new Vector3D(0.0, 0.0, 1.0));
            this.setDefaultViewpoint(new Vector3D(0.0, 0.0, 40.0));
        }
        this.multipleCopyOptions = new int[]{2, 3};
        this.canShowConjugateSurface = true;
    }

    public View getDefaultView() {
        WeierstrassMinimalSurface.WMSView wMSView = new WeierstrassMinimalSurface.WMSView(this);
        wMSView.setGridSpacing(6);
        return wMSView;
    }

    public void parameterChanged(Parameter parameter, Object object, Object object2) {
        super.parameterChanged(parameter, object, object2);
        this.AFP = this.afp.getValue();
        if (parameter != this.afp) {
            this.needsValueArray = true;
        }
        if (parameter == this.vmax) {
            this.vmin.reset(-this.vmax.getValue());
        }
    }

    protected void createData() {
        super.createData();
        this.data.discardGridTransforms();
        GridTransformMatrix[] gridTransformMatrixArray = new GridTransformMatrix[12];
        gridTransformMatrixArray[0] = new GridTransformMatrix();
        if (!this.inAssociateMorph && !this.wantsToSeeDomain) {
            int n;
            if (this.flag0) {
                gridTransformMatrixArray[1] = new GridTransformMatrix().scale(1.0, -1.0, 1.0).translate(0.0, 2.0 * this.halfPeriod.y.re, 0.0);
                this.data.addGridTransform(gridTransformMatrixArray[1]);
            }
            if (this.flag05) {
                gridTransformMatrixArray[1] = new GridTransformMatrix().scale(-1.0, 1.0, -1.0).translate(0.0, 0.0, 2.0 * this.halfPeriod.z.im);
                this.data.addGridTransform(gridTransformMatrixArray[1]);
            }
            if (this.getNumberOfPieces() == 2 || this.getNumberOfPieces() == 3) {
                for (n = 0; n < 2; ++n) {
                    if (this.flag0) {
                        gridTransformMatrixArray[n + 2] = new GridTransformMatrix(gridTransformMatrixArray[n]).translate(2.0 * this.halfPeriodII.x.re, 0.0, 0.0);
                        this.data.addGridTransform(gridTransformMatrixArray[n + 2]);
                    }
                    if (!this.flag05) continue;
                    gridTransformMatrixArray[n + 2] = new GridTransformMatrix(gridTransformMatrixArray[n]).translate(0.0, 0.0, -4.0 * this.halfPeriod.z.im);
                    this.data.addGridTransform(gridTransformMatrixArray[n + 2]);
                }
            }
            if (this.getNumberOfPieces() == 3 && this.flag0) {
                for (n = 0; n < 2; ++n) {
                    gridTransformMatrixArray[n + 4] = new GridTransformMatrix(gridTransformMatrixArray[n]).translate(-2.0 * this.halfPeriodII.x.re, 0.0, 0.0);
                    this.data.addGridTransform(gridTransformMatrixArray[n + 4]);
                }
            }
        }
    }

    protected Complex domainGrid(double d, double d2) {
        double d3 = this.R * Math.exp(d2);
        Complex complex = new Complex(d3 * Math.cos(d) + this.P, d3 * Math.sin(d));
        if (d < this.umin.getValue() + 1.0E-4) {
            complex.im = -Math.max(Math.max(-complex.im, this.amp - Math.abs(complex.re - this.P)), this.amp - Math.abs(complex.re - this.P - 1.0 / this.P));
        }
        if (d > this.umax.getValue() - 1.0E-4) {
            complex.im = Math.max(Math.max(complex.im, this.amp - Math.abs(complex.re - this.P)), this.amp - Math.abs(complex.re - this.P - 1.0 / this.P));
        }
        return complex;
    }

    protected void p_Index() {
        this.jP = (int)Math.floor((this.PL - this.vmin.getValue()) / (this.vmax.getValue() - this.vmin.getValue()) * (double)(this.vcount - 1));
    }

    protected Complex gauss(Complex complex) {
        double d = complex.re * complex.re + complex.im * complex.im;
        Complex complex2 = new Complex(this.PR * (complex.re / d - complex.re) + this.R_, -this.PR * complex.im * (1.0 / d + 1.0));
        complex2 = complex.im > 0.0 ? complex2.squareRootNearer(I2_C) : complex2.squareRootNearer(I1_C);
        return complex2;
    }

    protected Complex hPrime(Complex complex) {
        double d = ((complex.re - this.P) * (complex.re - this.P) + complex.im * complex.im) / this.r1;
        return new Complex((complex.re - this.P) / d, -complex.im / d);
    }

    protected void redoConstants() {
        super.redoConstants();
        this.P = Math.exp(this.aa.getValue());
        this.R = this.P * this.P + 1.0;
        this.R_ = (this.P * this.P - 1.0) / this.R;
        this.PR = this.P / this.R;
        this.R = Math.sqrt(this.R);
        this.PL = Math.log(this.P / this.R);
        this.qP = new Complex(this.P, 1.25E-5);
        this.r1 = 0.5;
        this.p_Index();
        this.um = (int)Math.floor((double)(this.ucount - 1) / 2.0);
        this.vm = (int)Math.floor((double)(this.vcount - 1) / 2.0);
    }

    protected ComplexVector3D getCenter() {
        return new ComplexVector3D(this.helperArray[this.um][this.vm]);
    }

    public void computeHalfPeriod() {
        this.halfPeriod = new ComplexVector3D(this.helperArray[0][0]);
        this.halfPeriod.assign(this.halfPeriod.y.minus(this.halfPeriod.x), this.halfPeriod.y.plus(this.halfPeriod.x).times(I_C), this.halfPeriod.z);
        this.halfPeriodII = new ComplexVector3D(this.helperArray[0][this.vm]);
        this.halfPeriodII.assign(this.halfPeriodII.y.minus(this.halfPeriodII.x), this.halfPeriodII.y.plus(this.halfPeriodII.x).times(I_C), this.halfPeriodII.z);
    }

    public Vector3D surfacePoint(double d, double d2) {
        int n = (int)Math.floor(0.25 + (d - this.umin.getValue()) / this.du);
        int n2 = (int)Math.floor(0.25 + (d2 - this.vmin.getValue()) / this.dv);
        ComplexVector3D complexVector3D = new ComplexVector3D(this.helperArray[n][n2].plus(this.ComplexVectorOneStepIntegrator(this.domainGrid(this.umin.getValue() + (double)n * this.du, this.vmin.getValue() + (double)n2 * this.dv), this.domainGrid(d, d2))));
        ComplexVector3D complexVector3D2 = new ComplexVector3D(complexVector3D.y.minus(complexVector3D.x), complexVector3D.y.plus(complexVector3D.x).times(I_C), complexVector3D.z);
        if (this.AFP == 0.0) {
            return complexVector3D2.re();
        }
        return complexVector3D2.re().times(Math.cos(this.AFP)).plus(complexVector3D2.im().times(Math.sin(this.AFP)));
    }
}

