/*
 * Decompiled with CFR 0.152.
 */
package vmm.surface.parametric;

import vmm.core.Complex;
import vmm.core.IntegerParam;
import vmm.core.RealParamAnimateable;
import vmm.core3D.ComplexVector3D;
import vmm.core3D.Vector3D;
import vmm.surface.parametric.WeierstrassMinimalSurface;

public class CatenoidEnneper
extends WeierstrassMinimalSurface {
    private IntegerParam exponent = new IntegerParam("vmm.surface.parametric.CatenoidEnneper.MainEx", 2);
    private RealParamAnimateable aa = new RealParamAnimateable("vmm.surface.parametric.CatenoidEnneper.CoeffA", 0.5, 0.0, 1.0);
    private int ex;
    private double a;
    private double r1;
    private double r2;
    private Complex q1;

    public CatenoidEnneper() {
        this.afp.reset(0.0, 0.0, 0.0);
        this.addParameter(this.aa);
        this.addParameter(this.exponent);
        this.setDefaultViewpoint(new Vector3D(-11.0, -17.0, 12.0));
        this.setDefaultWindow(-4.0, 4.0, -4.5, 3.5);
        this.uPatchCount.setValueAndDefault(8);
        this.vPatchCount.setValueAndDefault(18);
        this.umin.reset(-2.0);
        this.umax.reset(2.0);
        this.vmin.reset(0.0);
        this.vmax.reset(Math.PI * 2);
        this.canShowConjugateSurface = true;
    }

    protected Complex domainGrid(double d, double d2) {
        double d3 = Math.exp(d);
        Complex complex = new Complex(d3 * Math.cos(d2), d3 * Math.sin(d2));
        return complex;
    }

    protected Complex gauss(Complex complex) {
        Complex complex2 = new Complex(this.a * complex.re, this.a * complex.im);
        complex2.assignPow(complex2, this.ex);
        complex2.assignPlus(this.q1);
        complex2.assignTimes(this.r1);
        complex2.assignDivide(complex);
        return complex2;
    }

    protected Complex hPrime(Complex complex) {
        return this.gauss(complex).times(this.r2);
    }

    protected Complex gaussTimesHPrime(Complex complex) {
        Complex complex2 = this.gauss(complex);
        complex2.assignTimes(complex2);
        return complex2.times(this.r2);
    }

    protected Complex gaussInverseTimesHPrime(Complex complex) {
        return new Complex(this.r2, 0.0);
    }

    protected void redoConstants() {
        super.redoConstants();
        this.ex = this.exponent.getValue();
        this.a = this.aa.getValue();
        this.r1 = 1.0 / (3.0 + this.a * this.a);
        this.r2 = 0.4 / (1.0 + this.a * this.a * (double)this.ex / 2.0);
        this.q1 = new Complex(-3.0 + this.a, 0.0);
    }

    protected ComplexVector3D getCenter() {
        return new ComplexVector3D(this.helperArray[(int)Math.floor(this.ucount / 2)][(int)Math.floor(this.vcount / 2)]);
    }
}

