/*
 * Decompiled with CFR 0.152.
 */
package vmm.surface.parametric;

import vmm.core.RealParamAnimateable;
import vmm.core3D.Vector3D;
import vmm.surface.parametric.SurfaceParametric;

public class Catalan
extends SurfaceParametric {
    private RealParamAnimateable aa = new RealParamAnimateable("genericParam.aa", "0", "0", "pi / 2");

    public Catalan() {
        this.uPatchCount.setValueAndDefault(20);
        this.vPatchCount.setValueAndDefault(20);
        this.umin.reset(0.0);
        this.umax.reset("4 * pi");
        this.vmin.reset(-2.0);
        this.vmax.reset(2.0);
        this.setDefaultViewpoint(new Vector3D(3.0, -12.0, 12.0));
        this.setDefaultWindow(-10.0, 10.0, -10.0, 10.0);
        this.addParameter(this.aa);
    }

    private static double sinh(double d) {
        return 0.5 * (Math.exp(d) - Math.exp(-d));
    }

    private static double cosh(double d) {
        return 0.5 * (Math.exp(d) + Math.exp(-d));
    }

    public Vector3D surfacePoint(double d, double d2) {
        double d3 = this.aa.getValue();
        double d4 = Math.PI;
        double d5 = Math.cos(d3 * d4) * (d - Math.sin(d) * Catalan.cosh(d2)) + Math.sin(d3 * d4) * (d2 - Math.cos(d) * Catalan.sinh(d2)) - 4.0;
        double d6 = Math.cos(d3 * d4) * (1.0 - Math.cos(d) * Catalan.cosh(d2)) + Math.sin(d3 * d4) * Math.sin(d) * Catalan.sinh(d2);
        double d7 = Math.cos(d3 * d4) * 4.0 * Math.sin(d / 2.0) * Catalan.sinh(d2 / 2.0) + Math.sin(d3 * d4) * 4.0 * (Math.cos(d / 2.0) * Catalan.cosh(d2 / 2.0) - 1.0);
        return new Vector3D(d5, d6, d7);
    }
}

