/*
 * Decompiled with CFR 0.152.
 */
package vmm.surface.parametric;

import java.awt.event.ActionEvent;
import vmm.actions.AbstractActionVMM;
import vmm.actions.ActionList;
import vmm.core.BasicAnimator;
import vmm.core.Complex;
import vmm.core.I18n;
import vmm.core.RealParamAnimateable;
import vmm.core.View;
import vmm.core3D.Vector3D;
import vmm.surface.SurfaceView;
import vmm.surface.parametric.SurfaceParametric;

public class BoyBryantKusner
extends SurfaceParametric {
    private RealParamAnimateable aa = new RealParamAnimateable("genericParam.aa", "0.5", "0.5", "0.5");

    public BoyBryantKusner() {
        this.uPatchCount.setValueAndDefault(16);
        this.vPatchCount.setValueAndDefault(32);
        this.umin.reset(-1.45, -0.2, -1.449);
        this.umax.reset(0.0);
        this.vmin.reset(0.0);
        this.vmax.reset("2*pi");
        this.setDefaultOrientation(2);
        this.setDefaultViewpoint(new Vector3D(0.0, 0.0, 17.3));
        this.setDefaultWindow(-2.1, 2.1, -2.1, 2.1);
        this.addParameter(this.aa);
    }

    public View getDefaultView() {
        SurfaceView surfaceView = (SurfaceView)super.getDefaultView();
        return surfaceView;
    }

    public ActionList getAdditionalAnimationsForView(final View view) {
        ActionList actionList = super.getAdditionalAnimationsForView(view);
        actionList.add(new AbstractActionVMM(I18n.tr("common.AlternativeMorph")){

            public void actionPerformed(ActionEvent actionEvent) {
                BasicAnimator basicAnimator = new BasicAnimator();
                basicAnimator.setLooping(1);
                basicAnimator.setUseFilmstrip(BoyBryantKusner.this.getUseFilmstripForMorphing());
                basicAnimator.setFrames(BoyBryantKusner.this.getFramesForMorphing());
                basicAnimator.setMillisecondsPerFrame(200);
                basicAnimator.addWithCustomValue(BoyBryantKusner.this.uPatchCount, 24);
                basicAnimator.addWithCustomValue(BoyBryantKusner.this.vPatchCount, 6);
                basicAnimator.addWithCustomValue(BoyBryantKusner.this.umin, -1.45);
                basicAnimator.addWithCustomValue(BoyBryantKusner.this.umax, 1.45);
                basicAnimator.addWithCustomLimits(BoyBryantKusner.this.vmin, 0.0, 5.583185307179586);
                basicAnimator.addWithCustomLimits(BoyBryantKusner.this.vmax, 0.7, Math.PI * 2);
                view.getDisplay().installAnimation(basicAnimator);
            }
        });
        return actionList;
    }

    public Vector3D surfacePoint(double d, double d2) {
        Complex complex = new Complex(1.0, 0.0);
        Complex complex2 = new Complex(0.0, 1.0);
        double d3 = Math.exp(Math.tan(d));
        Complex complex3 = new Complex(d3 * Math.cos(d2), d3 * Math.sin(d2));
        Complex complex4 = new Complex(complex3.times(complex3));
        Complex complex5 = new Complex(complex3.times(complex4));
        Complex complex6 = new Complex(complex.dividedBy(complex4));
        Complex complex7 = new Complex(complex.dividedBy(complex5));
        Complex complex8 = new Complex(complex4.plus(complex6));
        Complex complex9 = new Complex(complex4.minus(complex6));
        Complex complex10 = new Complex(complex5.plus(complex7));
        Complex complex11 = new Complex(complex5.minus(complex7));
        Complex complex12 = new Complex(complex.dividedBy(complex11.plus(Math.sqrt(5.0))));
        Complex complex13 = new Complex(complex9.times(complex2).times(complex12));
        Complex complex14 = new Complex(complex12.times(complex8));
        Complex complex15 = new Complex(complex10.times(complex2).times(0.6666666666666666));
        complex15 = complex12.times(complex15);
        double d4 = complex13.re;
        double d5 = complex14.re;
        double d6 = complex15.re + this.aa.getValue();
        double d7 = 1.0 / Math.max(1.0E-5, d4 * d4 + d5 * d5 + d6 * d6);
        return new Vector3D(d7 * d4, d7 * d5, d7 * d6);
    }
}

