/*
 * Decompiled with CFR 0.152.
 */
package vmm.surface.parametric;

import java.awt.event.ActionEvent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import vmm.actions.AbstractActionVMM;
import vmm.actions.ActionList;
import vmm.core.BasicAnimator;
import vmm.core.I18n;
import vmm.core.Parameter;
import vmm.core.Quaternion;
import vmm.core.RealParamAnimateable;
import vmm.core.View;
import vmm.core3D.Vector3D;
import vmm.surface.parametric.SurfaceParametric;

public class BianchiPinkall
extends SurfaceParametric {
    private RealParamAnimateable aa = new RealParamAnimateable("vmm.surface.parametric.BianchiPinkall.aa", 0.25, 0.25, 0.25);
    private RealParamAnimateable bb = new RealParamAnimateable("vmm.surface.parametric.BianchiPinkall.bb", 0.1, 0.0, 0.1);
    private RealParamAnimateable cc = new RealParamAnimateable("vmm.surface.parametric.BianchiPinkall.cc", 3.0, 3.0, 3.0);
    private RealParamAnimateable dd = new RealParamAnimateable("vmm.surface.parametric.BianchiPinkall.dd", 0.0, 0.0, 0.0);
    double AA;
    double BB;
    double CC;
    double DD;
    Quaternion q0;
    boolean in2ndMorph = false;

    public BianchiPinkall() {
        this.uPatchCount.setValueAndDefault(36);
        this.vPatchCount.setValueAndDefault(18);
        this.umin.reset("0");
        this.umax.reset("2 pi");
        this.vmin.reset("0.01");
        this.vmax.reset("pi");
        this.setDefaultViewpoint(new Vector3D(-18.5, -5.1, -3.4));
        this.setDefaultWindow(-4.5, 4.5, -4.5, 4.5);
        this.setDefaultOrientation(0);
        this.addParameter(this.dd);
        this.addParameter(this.cc);
        this.addParameter(this.bb);
        this.addParameter(this.aa);
        this.aa.setMaximumValueForInput(0.5);
        this.aa.setMinimumValueForInput(0.0);
    }

    public void parameterChanged(Parameter parameter, Object object, Object object2) {
        super.parameterChanged(parameter, object, object2);
        this.AA = Math.PI * this.aa.getValue();
        this.BB = Math.PI * this.bb.getValue();
        this.BB = Math.max(0.0, Math.min(this.BB, Math.min(this.AA, Math.PI - this.AA)));
        this.CC = 2.0 * this.cc.getValue();
        this.DD = Math.PI * this.dd.getValue();
        this.q0 = this.vFunction(this.AA, this.BB, this.CC, 0.0);
    }

    public ActionList getAdditionalAnimationsForView(final View view) {
        ActionList actionList = super.getAdditionalAnimationsForView(view);
        actionList.add(new AbstractActionVMM(I18n.tr("vmm.surface.parametric.BianchiPinkall.RotateAroundCircle")){

            public void actionPerformed(ActionEvent actionEvent) {
                BasicAnimator basicAnimator = new BasicAnimator();
                basicAnimator.setLooping(1);
                basicAnimator.setUseFilmstrip(BianchiPinkall.this.getUseFilmstripForMorphing());
                basicAnimator.setFrames(BianchiPinkall.this.getFramesForMorphing());
                basicAnimator.setMillisecondsPerFrame(200);
                basicAnimator.addWithCustomLimits(BianchiPinkall.this.dd, 0.0, 2.0);
                basicAnimator.addChangeListener(new ChangeListener(){

                    public void stateChanged(ChangeEvent changeEvent) {
                        BianchiPinkall.this.in2ndMorph = ((BasicAnimator)changeEvent.getSource()).isRunning();
                    }
                });
                view.getDisplay().installAnimation(basicAnimator);
            }
        });
        return actionList;
    }

    public Quaternion vFunction(double d, double d2, double d3, double d4) {
        double d5 = d + d2 * Math.sin(d3 * d4);
        return new Quaternion(Math.cos(d5) * Math.cos(d4), Math.cos(d5) * Math.sin(d4), Math.sin(d5) * Math.cos(d4), -Math.sin(d5) * Math.sin(d4));
    }

    public Vector3D surfacePoint(double d, double d2) {
        Quaternion quaternion = new Quaternion(Math.cos(d), Math.sin(d), 0.0, 0.0);
        Quaternion quaternion2 = this.vFunction(this.AA, this.BB, this.CC, d2);
        Quaternion quaternion3 = quaternion.times(quaternion2);
        Quaternion quaternion4 = quaternion3.rotateAroundHopfFibre(this.DD, this.q0);
        return new Vector3D(quaternion4.StereographicProjection());
    }
}

