/*
 * Decompiled with CFR 0.152.
 */
package vmm.surface.parametric;

import vmm.core.RealParamAnimateable;
import vmm.core3D.Vector3D;
import vmm.surface.parametric.SurfaceParametric;

public class Astroidale
extends SurfaceParametric {
    private RealParamAnimateable aa = new RealParamAnimateable("vmm.surface.parametric.Astroidale.aa", "2.0", "2.0", "2.0");
    private RealParamAnimateable bb = new RealParamAnimateable("vmm.surface.parametric.Astroidale.bb", "3.0", "0.4", "3.0");

    public Astroidale() {
        this.uPatchCount.setValueAndDefault(16);
        this.vPatchCount.setValueAndDefault(10);
        this.umin.reset("-pi");
        this.umax.reset("pi");
        this.vmin.reset("-pi/2");
        this.vmax.reset("pi/2");
        this.setDefaultViewpoint(new Vector3D(10.0, -10.0, 10.0));
        this.setDefaultWindow(-2.5, 2.5, -2.5, 2.5);
        this.addParameter(this.aa);
        this.addParameter(this.bb);
    }

    private static double cospower(double d, double d2) {
        return Math.signum(Math.cos(d)) * Math.exp(d2 * Math.log(Math.abs(Math.cos(d))));
    }

    private static double sinpower(double d, double d2) {
        return Math.signum(Math.sin(d)) * Math.exp(d2 * Math.log(Math.abs(Math.sin(d))));
    }

    public Vector3D surfacePoint(double d, double d2) {
        double d3 = this.aa.getValue();
        double d4 = this.bb.getValue();
        double d5 = d3 * Astroidale.cospower(d, d4) * Astroidale.cospower(d2, d4);
        double d6 = d3 * Astroidale.sinpower(d, d4) * Astroidale.cospower(d2, d4);
        double d7 = d3 * Astroidale.sinpower(d2, d4);
        return new Vector3D(d5, d6, d7);
    }
}

