/*
 * Decompiled with CFR 0.152.
 */
package vmm.surface.implicit;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Random;
import vmm.actions.ActionList;
import vmm.actions.ActionRadioGroup;
import vmm.core.Animateable;
import vmm.core.BasicAnimator;
import vmm.core.Decoration;
import vmm.core.Display;
import vmm.core.Exhibit;
import vmm.core.I18n;
import vmm.core.IntegerParam;
import vmm.core.Parameter;
import vmm.core.Prefs;
import vmm.core.RealParam;
import vmm.core.RealParamAnimateable;
import vmm.core.TaskManager;
import vmm.core.VMMSave;
import vmm.core.View;
import vmm.core3D.Exhibit3D;
import vmm.core3D.LightSettings;
import vmm.core3D.PhongLighting;
import vmm.core3D.Transform3D;
import vmm.core3D.Vector3D;
import vmm.core3D.View3D;
import vmm.core3D.View3DWithLightSettings;
import vmm.surface.implicit.Maps;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SurfaceImplicit
extends Exhibit3D {
    equationType heightFunctionType = equationType.OTHER;
    protected RealParamAnimateable level = new RealParamAnimateable("vmm.surface.implicit.SurfaceImplicit.level", 0.0);
    protected IntegerParam pointCloudCount = new IntegerParam("vmm.surface.implicit.SurfaceImplicit.pointCloudCount", 2000);
    protected IntegerParam randomLineCount = new IntegerParam("vmm.surface.implicit.SurfaceImplicit.randomLineCount", 40000);
    protected RealParamAnimateable searchRadius = new RealParamAnimateable("vmm.surface.implicit.SurfaceImplicit.searchRadius", 3.0);
    protected RealParam rayTraceResolution = new RealParam("vmm.surface.implicit.SurfaceImplicit.rayTraceResolution", 0.05);
    protected Vector3D[] pointCloud;
    private int numberOfPointsInCloud = 0;
    private TaskManager taskManager;
    protected Line3D[] ListOfRandomLines;
    private double searchRadiusUsedForRandomLines;
    protected double resolution = this.rayTraceResolution.getValue();

    public abstract double heightFunction(double var1, double var3, double var5);

    public double heightFunction(Vector3D vector3D) {
        return this.heightFunction(vector3D.x, vector3D.y, vector3D.z);
    }

    public SurfaceImplicit() {
        this.addParameter(this.level);
        this.addParameter(this.rayTraceResolution);
        this.rayTraceResolution.setMinimumValueForInput(1.0E-5);
        this.addParameter(this.pointCloudCount);
        this.pointCloudCount.setMinimumValueForInput(200);
        this.pointCloudCount.setMaximumValueForInput(50000);
        this.addParameter(this.randomLineCount);
        this.randomLineCount.setMinimumValueForInput(1000);
        this.randomLineCount.setMaximumValueForInput(200000);
        this.addParameter(this.searchRadius);
        this.searchRadius.setMinimumValueForInput(Double.MIN_VALUE);
        this.setFramesForMorphing(12);
        this.setUseFilmstripForMorphing(true);
        this.setDefaultBackground(Color.BLACK);
    }

    public Vector3D normalToSurfaceAt(Vector3D vector3D) {
        double d = 1.0E-6;
        double d2 = 2.0 / d;
        Vector3D vector3D2 = new Vector3D();
        vector3D2.x = this.heightFunction(vector3D.x + d, vector3D.y, vector3D.z) - this.heightFunction(vector3D.x - d, vector3D.y, vector3D.z);
        vector3D2.y = this.heightFunction(vector3D.x, vector3D.y + d, vector3D.z) - this.heightFunction(vector3D.x, vector3D.y - d, vector3D.z);
        vector3D2.z = this.heightFunction(vector3D.x, vector3D.y, vector3D.z + d) - this.heightFunction(vector3D.x, vector3D.y, vector3D.z - d);
        Vector3D vector3D3 = new Vector3D(vector3D2.times(d2));
        return vector3D3.normalized();
    }

    @Override
    public void removeView(View view) {
        super.removeView(view);
        if (this.taskManager != null && (this.getViews() == null || this.getViews().size() == 0)) {
            this.taskManager.shutDown();
            this.taskManager = null;
        }
    }

    public synchronized void MakeListOfRandomLines() {
        double d = this.searchRadius.getValue();
        int n = this.randomLineCount.getValue();
        if (this.searchRadiusUsedForRandomLines == d && this.ListOfRandomLines != null && this.ListOfRandomLines.length == n + 1) {
            return;
        }
        this.searchRadiusUsedForRandomLines = d;
        this.ListOfRandomLines = new Line3D[this.randomLineCount.getValue() + 1];
        ArrayList<MakeRandomLines> arrayList = new ArrayList<MakeRandomLines>();
        for (int i = 1; i < this.ListOfRandomLines.length; i += 500) {
            int n2 = i + 500 - 1;
            if (n2 >= this.ListOfRandomLines.length) {
                n2 = this.ListOfRandomLines.length - 1;
            }
            arrayList.add(new MakeRandomLines(i, n2));
        }
        if (this.taskManager == null) {
            this.taskManager = new TaskManager();
        }
        this.taskManager.executeAndWait(arrayList);
    }

    protected double heightAlongLine(double d, Line3D line3D) {
        Vector3D vector3D = new Vector3D(line3D.parametricEquation(d));
        double d2 = this.heightFunction(vector3D.x, vector3D.y, vector3D.z);
        return d2;
    }

    public double theFunction(double d, Line3D line3D) {
        return this.heightAlongLine(d, line3D) - this.level.getValue();
    }

    public void quadraticSolve(Line3D line3D, double[] dArray) {
        double d;
        double d2;
        double d3;
        double d4 = this.theFunction(-1.0, line3D);
        double d5 = this.theFunction(0.0, line3D);
        double d6 = this.theFunction(1.0, line3D);
        double d7 = 0.5 * (d6 - d4);
        double d8 = d7 * d7 - 4.0 * (d3 = d6 - d7 - (d2 = d5)) * d2;
        dArray[0] = d = d8 >= 0.0 ? 2.0 : 0.0;
        if (d == 2.0) {
            dArray[1] = 0.5 * (-d7 - Math.sqrt(d8)) / d3;
            dArray[2] = 0.5 * (-d7 + Math.sqrt(d8)) / d3;
            if (dArray[2] < dArray[1]) {
                double d9 = dArray[2];
                dArray[2] = dArray[1];
                dArray[1] = d9;
            }
        }
    }

    public void cubicSolve(Line3D line3D, double[] dArray) {
        double d;
        double d2;
        double d3;
        double d4 = this.theFunction(-1.0, line3D);
        double d5 = this.theFunction(0.0, line3D);
        double d6 = this.theFunction(1.0, line3D);
        double d7 = this.theFunction(2.0, line3D);
        double d8 = 0.16666666666666666 * (d7 - 4.0 * (d3 = 0.5 * (d6 + d4) - (d2 = d5)) - (d6 - d4) - d2);
        if (Math.abs(d8) < 1.0E-9) {
            this.quadraticSolve(line3D, dArray);
        } else {
            double d9;
            double d10;
            double d11 = d3 / d8;
            double d12 = 0.5 * (d6 - d4) - d8;
            d = d12 / d8;
            double d13 = d2 / d8;
            double d14 = 0.037037037037037035 * d11 * d11 * d11 - 0.16666666666666666 * d11 * d + 0.5 * d13;
            double d15 = 0.3333333333333333 * (-0.3333333333333333 * d11 * d11 + d);
            double d16 = d15 * d15 * d15;
            double d17 = d14 * d14 + d16;
            if (Math.abs(d17) < 1.0E-9) {
                if (Math.abs(d14) < 1.0E-9) {
                    dArray[0] = 1.0;
                    dArray[1] = 0.0;
                } else {
                    dArray[0] = 2.0;
                    d10 = Math.cbrt(-d14);
                    dArray[1] = 2.0 * d10;
                    dArray[2] = -d10;
                }
            } else if (d17 < 0.0) {
                d10 = 0.3333333333333333 * Math.acos(-d14 / Math.sqrt(-d16));
                d9 = 2.0 * Math.sqrt(-d15);
                dArray[0] = 3.0;
                dArray[1] = d9 * Math.cos(d10);
                dArray[2] = -d9 * Math.cos(d10 + 1.0471975511965976);
                dArray[3] = -d9 * Math.cos(d10 - 1.0471975511965976);
            } else {
                d10 = Math.sqrt(d17);
                d9 = Math.cbrt(d10 - d14);
                double d18 = -Math.cbrt(d10 + d14);
                dArray[0] = 1.0;
                dArray[1] = d9 + d18;
            }
            int n = 1;
            while ((double)n <= dArray[0]) {
                dArray[n] = dArray[n] - 0.3333333333333333 * d11;
                ++n;
            }
        }
        int n = 2;
        while ((double)n <= dArray[0]) {
            for (int i = n; i > 1 && dArray[i - 1] > dArray[i]; --i) {
                d = dArray[i];
                dArray[i] = dArray[i - 1];
                dArray[i - 1] = d;
            }
            ++n;
        }
    }

    public void quarticSolve(Line3D line3D, double[] dArray) {
        double d;
        double d2;
        double d3;
        double d4;
        double d5;
        double d6;
        double d7;
        double d8;
        double d9;
        double d10;
        double d11;
        double d12 = this.theFunction(-2.0, line3D);
        double d13 = this.theFunction(-1.0, line3D);
        double d14 = this.theFunction(0.0, line3D);
        double d15 = this.theFunction(1.0, line3D);
        double d16 = this.theFunction(2.0, line3D);
        double d17 = 0.08333333333333333 * (d16 - d12) - 0.16666666666666666 * (d15 - d13);
        double d18 = d17 * (d11 = 1.0 / (d10 = 0.08333333333333333 * (d16 - 8.0 * d17 - 2.0 * (d15 + d13) + 3.0 * (d9 = d14) - 2.0 * (d8 = 0.5 * (d15 - d13) - d17))));
        double d19 = d18 * d18;
        double d20 = -0.375 * d19 + (d7 = (d6 = 0.5 * (d15 + d13) - d9 - d10) * d11);
        double d21 = SurfaceImplicit.solveCubicForQuartic(-0.5 * d20, -(d5 = -0.01171875 * d19 * d19 + 0.0625 * d19 * d7 - 0.25 * d18 * (d4 = d8 * d11) + (d3 = d9 * d11)), 0.5 * d5 * d20 - 0.125 * (d2 = 0.125 * d19 * d18 - 0.5 * d18 * d7 + d4) * d2);
        double d22 = 2.0 * d21 - d20;
        if (d22 < 0.0) {
            if (d22 > 1.0E-10) {
                d22 = 0.0;
            }
            dArray[0] = 0.0;
        }
        if (d22 < 1.0E-10) {
            d = d21 * d21 - d5;
            if (d < 0.0) {
                dArray[0] = 0.0;
            }
            d = Math.sqrt(d);
        } else {
            d22 = Math.sqrt(d22);
            d = 0.5 * d2 / d22;
        }
        double d23 = d22 * d22;
        double d24 = -0.25 * d18;
        double d25 = d23 - 4.0 * (d21 - d);
        double d26 = d23 - 4.0 * (d21 + d);
        if (d25 >= 0.0 && d26 >= 0.0) {
            d25 = Math.sqrt(d25);
            d26 = Math.sqrt(d26);
            dArray[0] = 4.0;
            dArray[1] = -0.5 * (d22 + d25) + d24;
            dArray[2] = -0.5 * (d22 - d25) + d24;
            dArray[3] = 0.5 * (d22 + d26) + d24;
            dArray[4] = 0.5 * (d22 - d26) + d24;
        } else if (d25 >= 0.0) {
            d25 = Math.sqrt(d25);
            dArray[0] = 2.0;
            dArray[1] = -0.5 * (d22 + d25) + d24;
            dArray[2] = -0.5 * (d22 - d25) + d24;
        } else if (d26 >= 0.0) {
            d26 = Math.sqrt(d26);
            dArray[0] = 2.0;
            dArray[1] = 0.5 * (d22 - d26) + d24;
            dArray[2] = 0.5 * (d22 + d26) + d24;
        }
        int n = 2;
        while ((double)n <= dArray[0]) {
            for (int i = n; i > 1 && dArray[i - 1] > dArray[i]; --i) {
                double d27 = dArray[i];
                dArray[i] = dArray[i - 1];
                dArray[i - 1] = d27;
            }
            ++n;
        }
    }

    private static final double solveCubicForQuartic(double d, double d2, double d3) {
        double d4 = d * d;
        double d5 = (d4 - 3.0 * d2) / 9.0;
        double d6 = (d * (d4 - 4.5 * d2) + 13.5 * d3) / 27.0;
        double d7 = d5 * d5 * d5;
        double d8 = d6 * d6;
        double d9 = d7 - d8;
        double d10 = d / 3.0;
        if (d9 >= 0.0) {
            d9 = d6 / Math.sqrt(d7);
            double d11 = Math.acos(d9) / 3.0;
            double d12 = -2.0 * Math.sqrt(d5);
            return d12 * Math.cos(d11) - d10;
        }
        double d13 = Math.pow(Math.sqrt(d8 - d7) + Math.abs(d6), 0.3333333333333333);
        if (d6 < 0.0) {
            return d13 + d5 / d13 - d10;
        }
        return -(d13 + d5 / d13) - d10;
    }

    public double FindNextRoot(Line3D line3D, double d, double d2, double d3) {
        double[] dArray = new double[3];
        double[] dArray2 = new double[3];
        dArray[1] = d;
        dArray[2] = d2;
        dArray2[1] = this.theFunction(dArray[1], line3D);
        dArray2[2] = this.theFunction(dArray[2], line3D);
        double d4 = (dArray[1] * dArray2[2] - dArray[2] * dArray2[1]) / (dArray2[2] - dArray2[1]);
        return d4;
    }

    private void IntersectLineWithImplicitQuadraticSurface(Line3D line3D, double[] dArray, ArrayList<Vector3D> arrayList) {
        double d = Math.pow(this.searchRadius.getValue(), 2.0);
        double d2 = Math.pow(line3D.intercept.norm(), 2.0);
        double d3 = Math.sqrt(d - d2);
        this.quadraticSolve(line3D, dArray);
        if (dArray[0] == 2.0) {
            if (Math.abs(dArray[1]) <= d3) {
                arrayList.add(new Vector3D(line3D.parametricEquation(dArray[1])));
            }
            if (Math.abs(dArray[2]) <= d3) {
                arrayList.add(new Vector3D(line3D.parametricEquation(dArray[2])));
            }
        }
    }

    private void IntersectLineWithImplicitCubicSurface(Line3D line3D, double[] dArray, ArrayList<Vector3D> arrayList) {
        double d = Math.pow(this.searchRadius.getValue(), 2.0);
        double d2 = Math.pow(line3D.intercept.norm(), 2.0);
        double d3 = Math.sqrt(d - d2);
        this.cubicSolve(line3D, dArray);
        if (dArray[0] > 0.0 && Math.abs(dArray[1]) <= d3) {
            arrayList.add(new Vector3D(line3D.parametricEquation(dArray[1])));
        }
        if (dArray[0] > 1.0 && Math.abs(dArray[2]) <= d3) {
            arrayList.add(new Vector3D(line3D.parametricEquation(dArray[2])));
        }
        if (dArray[0] > 2.0 && Math.abs(dArray[3]) <= d3) {
            arrayList.add(new Vector3D(line3D.parametricEquation(dArray[3])));
        }
    }

    private void IntersectLineWithImplicitQuarticSurface(Line3D line3D, double[] dArray, ArrayList<Vector3D> arrayList) {
        double d = Math.pow(this.searchRadius.getValue(), 2.0);
        double d2 = Math.pow(line3D.intercept.norm(), 2.0);
        double d3 = Math.sqrt(d - d2);
        this.quarticSolve(line3D, dArray);
        if (dArray[0] > 0.0 && Math.abs(dArray[1]) <= d3) {
            arrayList.add(new Vector3D(line3D.parametricEquation(dArray[1])));
        }
        if (dArray[0] > 1.0 && Math.abs(dArray[2]) <= d3) {
            arrayList.add(new Vector3D(line3D.parametricEquation(dArray[2])));
        }
        if (dArray[0] > 2.0 && Math.abs(dArray[3]) <= d3) {
            arrayList.add(new Vector3D(line3D.parametricEquation(dArray[3])));
        }
        if (dArray[0] > 3.0 && Math.abs(dArray[4]) <= d3) {
            arrayList.add(new Vector3D(line3D.parametricEquation(dArray[4])));
        }
    }

    private void IntersectLineWithImplicitSurface(Line3D line3D, ArrayList<Vector3D> arrayList) {
        int n;
        double d;
        double d2 = Math.pow(this.searchRadius.getValue(), 2.0);
        double d3 = Math.sqrt(Math.max(0.001, d2 - (d = Math.pow(line3D.intercept.norm(), 2.0))));
        double d4 = 2.0 * d3;
        double d5 = d4 / (double)(n = (int)Math.round(40.0 * d3));
        if (d5 > this.resolution) {
            n = (int)Math.round(d4 / this.resolution) + 1;
            d5 = d4 / (double)n;
        }
        Vector3D vector3D = line3D.parametricEquation(-d3 - d5);
        Vector3D vector3D2 = line3D.parametricEquation(-d3).minus(vector3D);
        double d6 = this.level.getValue();
        double d7 = vector3D2.x;
        double d8 = vector3D2.y;
        double d9 = vector3D2.z;
        double d10 = vector3D.x;
        double d11 = vector3D.y;
        double d12 = vector3D.z;
        double d13 = this.heightFunction(d10, d11, d12) - d6;
        double d14 = -d3 - d5;
        double d15 = d5;
        for (int i = 0; i <= n; ++i) {
            double d16 = d14 + d15;
            double d17 = d10 + d7;
            double d18 = d11 + d8;
            double d19 = d12 + d9;
            double d20 = this.heightFunction(d17, d18, d19) - d6;
            if (Math.signum(d13) != Math.signum(d20)) {
                double d21 = (d14 * d20 - d16 * d13) / (d20 - d13);
                arrayList.add(line3D.parametricEquation(d21));
            }
            d13 = d20;
            d10 = d17;
            d11 = d18;
            d12 = d19;
            d14 = d16;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createPointCloud() {
        this.pointCloud = new Vector3D[this.pointCloudCount.getValue()];
        TaskManager.Job job = this.taskManager.createJob();
        int n = 1;
        ArrayList<FindPointsOnPointCloud> arrayList = new ArrayList<FindPointsOnPointCloud>();
        CollectPointsForPointCloud collectPointsForPointCloud = new CollectPointsForPointCloud(arrayList, job);
        while (n < this.ListOfRandomLines.length) {
            int n2 = n + 499;
            if (n2 > this.ListOfRandomLines.length) {
                n2 = this.ListOfRandomLines.length;
            }
            FindPointsOnPointCloud findPointsOnPointCloud = new FindPointsOnPointCloud(collectPointsForPointCloud, n, n2);
            arrayList.add(findPointsOnPointCloud);
            n = n2 + 1;
        }
        CollectPointsForPointCloud collectPointsForPointCloud2 = collectPointsForPointCloud;
        synchronized (collectPointsForPointCloud2) {
            for (FindPointsOnPointCloud findPointsOnPointCloud : arrayList) {
                job.add(findPointsOnPointCloud);
            }
        }
        job.close();
        job.await(0);
    }

    @Override
    protected void computeDrawData3D(View3D view3D, boolean bl, Transform3D transform3D, Transform3D transform3D2) {
        if (!(!bl && this.pointCloud != null && this.ListOfRandomLines != null || view3D instanceof ImplicitSurfaceView && ((ImplicitSurfaceView)view3D).getUseRaytraceRendering())) {
            view3D.getDisplay().setCursor(Cursor.getPredefinedCursor(3));
            this.MakeListOfRandomLines();
            this.createPointCloud();
            view3D.getDisplay().setCursor(Cursor.getDefaultCursor());
        }
    }

    @Override
    protected void doDraw3D(Graphics2D graphics2D, View3D view3D, Transform3D transform3D) {
        if (!(view3D instanceof ImplicitSurfaceView) || !((ImplicitSurfaceView)view3D).getUseRaytraceRendering()) {
            view3D.drawPixels(this.pointCloud);
        } else {
            ((ImplicitSurfaceView)view3D).killRayTraceJob();
            ((ImplicitSurfaceView)view3D).drawRayTracedSurface();
        }
    }

    @Override
    public View getDefaultView() {
        return new ImplicitSurfaceView();
    }

    @Override
    public BasicAnimator getMorphingAnimation(final View view, int n) {
        if (!(view instanceof ImplicitSurfaceView)) {
            return super.getMorphingAnimation(view, n);
        }
        Parameter[] parameterArray = view.getViewAndExhibitParameters();
        if (parameterArray == null) {
            return null;
        }
        boolean bl = false;
        for (int i = 0; i < parameterArray.length; ++i) {
            if (!(parameterArray[i] instanceof Animateable) || !((Animateable)((Object)parameterArray[i])).reallyAnimated()) continue;
            bl = true;
            break;
        }
        if (!bl) {
            return null;
        }
        BasicAnimator basicAnimator = new BasicAnimator(this.getFramesForMorphing()){

            public void animationStarting() {
                ((ImplicitSurfaceView)view).killRayTraceJob();
                SurfaceImplicit.this.morphingView = view;
                SurfaceImplicit.this.isMorphing = true;
            }

            public void animationEnding() {
                SurfaceImplicit.this.morphingView = null;
                SurfaceImplicit.this.isMorphing = false;
            }

            protected void nextFrame(ActionEvent actionEvent) {
                if (((ImplicitSurfaceView)view).isBuildingImage()) {
                    return;
                }
                super.nextFrame(actionEvent);
            }
        };
        if (this.getUseFilmstripForMorphing()) {
            basicAnimator.setUseFilmstrip(true);
            basicAnimator.setMillisecondsPerFrame(100);
        }
        for (int i = 0; i < parameterArray.length; ++i) {
            if (!(parameterArray[i] instanceof Animateable)) continue;
            basicAnimator.addAnimatedItem((Animateable)((Object)parameterArray[i]));
        }
        basicAnimator.setLooping(n);
        return basicAnimator;
    }

    public class ImplicitSurfaceView
    extends View3DWithLightSettings {
        @VMMSave
        boolean useRaytraceRendering = false;
        protected ActionRadioGroup renderSelect;
        private int rayTraceJobNum;
        private TaskManager.Job currentRayTraceJob;
        private RayTraceThread rayTraceThread;
        private Graphics leftAnaglyphGraphics;
        private Graphics rightAnaglyphGraphics;

        public ImplicitSurfaceView() {
            this.setViewStyle(1);
            this.renderSelect = new ActionRadioGroup(){

                public void optionSelected(int n) {
                    ImplicitSurfaceView.this.setUseRaytraceRendering(n == 1);
                }
            };
            this.renderSelect.addItem(I18n.tr("vmm.surface.implicit.PointCloud"));
            this.renderSelect.addItem(I18n.tr("vmm.surface.implicit.RayTrace"));
            this.renderSelect.setSelectedIndex(0);
            LightSettings lightSettings = new LightSettings();
            lightSettings.setSpecularExponent(80);
            lightSettings.setSpecularRatio(0.25f);
            this.setAnaglyphLightSettings(lightSettings);
            this.setNonAnaglyphLightSettings(new LightSettings(3));
        }

        public boolean getUseRaytraceRendering() {
            return this.useRaytraceRendering;
        }

        public void setUseRaytraceRendering(boolean bl) {
            if (this.useRaytraceRendering == bl) {
                return;
            }
            if (this.getDisplay() != null) {
                this.getDisplay().stopAnimation();
            }
            this.killRayTraceJob();
            this.useRaytraceRendering = bl;
            this.renderSelect.setSelectedIndex(bl ? 1 : 0);
            String string = Prefs.get("view3d.initialAnaglyphMode", "default");
            if (bl) {
                if (this.getViewStyle() == 1 && !string.equalsIgnoreCase("always")) {
                    this.setViewStyle(0);
                }
                this.setOrthographicProjection(false);
                this.projectionCommands.setEnabled(false);
            } else {
                if (this.getViewStyle() == 0 && !string.equalsIgnoreCase("never")) {
                    this.setViewStyle(1);
                }
                this.projectionCommands.setEnabled(true);
            }
            this.forceRedraw();
        }

        public void setExhibit(Exhibit exhibit) {
            this.killRayTraceJob();
            super.setExhibit(exhibit);
        }

        public ActionList getActions() {
            ActionList actionList = super.getActions();
            actionList.add(this.renderSelect);
            return actionList;
        }

        public ActionList getSettingsCommands() {
            ActionList actionList = super.getSettingsCommands();
            actionList.remove(this.lightingEnabledToggle);
            return actionList;
        }

        boolean isBuildingImage() {
            return this.buildingImageForFilmstrip;
        }

        protected void drawRayTracedSurface() {
            if (this.getViewStyle() == 0) {
                this.drawRayTracedDirect(7);
            } else {
                this.setUpForLeftEye();
                this.drawRayTracedDirect(7);
                this.setUpForRightEye();
                this.drawRayTracedDirect(7);
                this.finishStereoView();
            }
            if (!this.getFastDrawing()) {
                this.startRayTraceJob();
            }
        }

        protected Vector3D GetFirstIntersectionsOfLineWithQuadraticSurface(Line3D line3D, double[] dArray) {
            if (line3D.intercept.norm() > SurfaceImplicit.this.searchRadius.getValue()) {
                return new Vector3D(-12345.0, 0.0, 0.0);
            }
            Vector3D vector3D = new Vector3D();
            vector3D = null;
            double d = Math.pow(SurfaceImplicit.this.searchRadius.getValue(), 2.0);
            double d2 = Math.pow(line3D.intercept.norm(), 2.0);
            double d3 = Math.sqrt(Math.max(1.0E-5, d - d2));
            SurfaceImplicit.this.quadraticSolve(line3D, dArray);
            if (dArray[0] == 0.0) {
                return new Vector3D(-12345.0, 0.0, 0.0);
            }
            if (Math.abs(dArray[1]) > d3 && Math.abs(dArray[2]) > d3) {
                return new Vector3D(-12345.0, 0.0, 0.0);
            }
            vector3D = Math.abs(dArray[1]) < d3 ? line3D.parametricEquation(dArray[1]) : line3D.parametricEquation(dArray[2]);
            return vector3D;
        }

        protected Vector3D GetFirstIntersectionsOfLineWithCubicSurface(Line3D line3D, double[] dArray) {
            if (line3D.intercept.norm() > SurfaceImplicit.this.searchRadius.getValue()) {
                return new Vector3D(-12345.0, 0.0, 0.0);
            }
            Vector3D vector3D = new Vector3D();
            vector3D = null;
            double d = Math.pow(SurfaceImplicit.this.searchRadius.getValue(), 2.0);
            double d2 = Math.pow(line3D.intercept.norm(), 2.0);
            double d3 = Math.sqrt(Math.max(1.0E-5, d - d2));
            SurfaceImplicit.this.cubicSolve(line3D, dArray);
            if (dArray[0] == 0.0) {
                return new Vector3D(-12345.0, 0.0, 0.0);
            }
            if (Math.abs(dArray[1]) > d3 && Math.abs(dArray[2]) > d3 && Math.abs(dArray[3]) > d3) {
                return new Vector3D(-12345.0, 0.0, 0.0);
            }
            vector3D = Math.abs(dArray[1]) < d3 ? line3D.parametricEquation(dArray[1]) : (Math.abs(dArray[2]) < d3 ? line3D.parametricEquation(dArray[2]) : line3D.parametricEquation(dArray[3]));
            return vector3D;
        }

        protected Vector3D GetFirstIntersectionsOfLineWithQuarticSurface(Line3D line3D, double[] dArray) {
            if (line3D.intercept.norm() > SurfaceImplicit.this.searchRadius.getValue()) {
                return new Vector3D(-12345.0, 0.0, 0.0);
            }
            Vector3D vector3D = new Vector3D();
            vector3D = null;
            double d = Math.pow(SurfaceImplicit.this.searchRadius.getValue(), 2.0);
            double d2 = Math.pow(line3D.intercept.norm(), 2.0);
            double d3 = Math.sqrt(Math.max(1.0E-5, d - d2));
            SurfaceImplicit.this.quarticSolve(line3D, dArray);
            if (dArray[0] == 0.0) {
                return new Vector3D(-12345.0, 0.0, 0.0);
            }
            vector3D = Math.abs(dArray[1]) < d3 ? line3D.parametricEquation(dArray[1]) : (Math.abs(dArray[2]) < d3 ? line3D.parametricEquation(dArray[2]) : (Math.abs(dArray[3]) < d3 ? line3D.parametricEquation(dArray[3]) : (Math.abs(dArray[4]) < d3 ? line3D.parametricEquation(dArray[4]) : new Vector3D(-12345.0, 0.0, 0.0))));
            return vector3D;
        }

        protected Vector3D GetFirstIntersectionsOfLineWithSurface(Line3D line3D) {
            if (line3D.intercept.norm() > SurfaceImplicit.this.searchRadius.getValue()) {
                return new Vector3D(-12345.0, 0.0, 0.0);
            }
            double d = Math.pow(SurfaceImplicit.this.searchRadius.getValue(), 2.0);
            double d2 = Math.pow(line3D.intercept.norm(), 2.0);
            double d3 = Math.sqrt(Math.max(0.001, d - d2));
            double d4 = 2.0 * d3;
            int n = (int)Math.round(40.0 * d3);
            double d5 = d4 / (double)n;
            SurfaceImplicit.this.resolution = SurfaceImplicit.this.rayTraceResolution.getValue();
            if (d5 > SurfaceImplicit.this.resolution) {
                n = (int)Math.round(d4 / SurfaceImplicit.this.resolution) + 1;
                d5 = d4 / (double)n;
            }
            Vector3D vector3D = line3D.parametricEquation(-d3 - d5);
            Vector3D vector3D2 = line3D.parametricEquation(-d3).minus(vector3D);
            double d6 = SurfaceImplicit.this.level.getValue();
            double d7 = vector3D2.x;
            double d8 = vector3D2.y;
            double d9 = vector3D2.z;
            double d10 = vector3D.x;
            double d11 = vector3D.y;
            double d12 = vector3D.z;
            double d13 = SurfaceImplicit.this.heightFunction(d10, d11, d12) - d6;
            double d14 = -d3 - d5;
            double d15 = d5;
            for (int i = 0; i <= n; ++i) {
                double d16 = d14 + d15;
                double d17 = d10 + d7;
                double d18 = d11 + d8;
                double d19 = d12 + d9;
                double d20 = SurfaceImplicit.this.heightFunction(d17, d18, d19) - d6;
                if (Math.signum(d13) != Math.signum(d20)) {
                    double d21 = (d14 * d20 - d16 * d13) / (d20 - d13);
                    return line3D.parametricEquation(d21);
                }
                d13 = d20;
                d10 = d17;
                d11 = d18;
                d12 = d19;
                d14 = d16;
            }
            return new Vector3D(-12345.0, 0.0, 0.0);
        }

        private void drawRayTracedDirect(int n) {
            int n2 = this.transform3D.getWidth();
            int n3 = this.transform3D.getHeight();
            double d = (double)n * 0.5;
            Point2D.Double double_ = new Point2D.Double();
            Vector3D vector3D = this.getViewPoint();
            Vector3D vector3D2 = this.transform3D.getImagePlaneXDirection();
            Vector3D vector3D3 = this.transform3D.getImagePlaneYDirection();
            Color color = this.getBackground();
            if (this.getViewStyle() == 1) {
                color = Color.BLACK;
            }
            double[] dArray = new double[5];
            for (int i = 0; i < n3; i += n) {
                for (int j = 0; j < n2; j += n) {
                    dArray[0] = 0.0;
                    dArray[1] = 10000.0;
                    dArray[2] = 10000.0;
                    dArray[3] = 10000.0;
                    dArray[4] = 10000.0;
                    ((Point2D)double_).setLocation((double)j + d, (double)i + d);
                    this.transform3D.viewportToWindow(double_);
                    Vector3D vector3D4 = vector3D2.times(((Point2D)double_).getX());
                    Vector3D vector3D5 = vector3D3.times(((Point2D)double_).getY());
                    Vector3D vector3D6 = vector3D4.plus(vector3D5);
                    Vector3D vector3D7 = vector3D6.minus(vector3D).normalized();
                    double d2 = vector3D.dot(vector3D7);
                    Vector3D vector3D8 = vector3D.minus(vector3D7.times(d2));
                    Line3D line3D = new Line3D(vector3D8, vector3D7);
                    Vector3D vector3D9 = SurfaceImplicit.this.heightFunctionType == equationType.QUADRATIC ? this.GetFirstIntersectionsOfLineWithQuadraticSurface(line3D, dArray) : (SurfaceImplicit.this.heightFunctionType == equationType.CUBIC ? this.GetFirstIntersectionsOfLineWithCubicSurface(line3D, dArray) : (SurfaceImplicit.this.heightFunctionType == equationType.QUARTIC ? this.GetFirstIntersectionsOfLineWithQuarticSurface(line3D, dArray) : this.GetFirstIntersectionsOfLineWithSurface(line3D)));
                    Color color2 = color;
                    if (vector3D9.x != -12345.0) {
                        Vector3D vector3D10 = SurfaceImplicit.this.normalToSurfaceAt(vector3D9);
                        color2 = PhongLighting.phongLightingColor(vector3D10, this, this.transform3D, vector3D9, Color.WHITE);
                    }
                    if (n == 1) {
                        this.drawPixelDirect(color2, j, i);
                        continue;
                    }
                    this.setColor(color2);
                    this.fillRectDirect(j, i, n, n);
                }
            }
        }

        private synchronized void killRayTraceJob() {
            if (this.currentRayTraceJob == null) {
                return;
            }
            this.buildingImageForFilmstrip = false;
            if (!this.currentRayTraceJob.isFinished()) {
                this.currentRayTraceJob.cancel();
            }
            this.rayTraceThread = null;
            this.currentRayTraceJob = null;
            ++this.rayTraceJobNum;
            if (this.leftAnaglyphGraphics != null) {
                this.leftAnaglyphGraphics.dispose();
                this.rightAnaglyphGraphics.dispose();
                this.rightAnaglyphGraphics = null;
                this.leftAnaglyphGraphics = null;
            }
        }

        private synchronized void startRayTraceJob() {
            BufferedImage bufferedImage;
            BufferedImage bufferedImage2;
            Transform3D transform3D;
            Transform3D transform3D2;
            assert (this.currentRayTraceJob == null);
            if (this.getViewStyle() == 0) {
                transform3D2 = (Transform3D)this.getTransform3D().clone();
                transform3D = null;
                bufferedImage2 = this.fullOSI;
                bufferedImage = null;
            } else {
                this.setUpForLeftEye();
                transform3D2 = (Transform3D)this.getTransform3D().clone();
                this.setUpForRightEye();
                transform3D = (Transform3D)this.getTransform3D().clone();
                this.finishStereoView();
                if (this.getViewStyle() == 1) {
                    bufferedImage2 = this.stereoComposite.getLeftEyeImage();
                    bufferedImage = this.stereoComposite.getRightEyeImage();
                    this.leftAnaglyphGraphics = bufferedImage2.getGraphics();
                    this.rightAnaglyphGraphics = bufferedImage.getGraphics();
                } else {
                    bufferedImage2 = this.leftStereographOSI;
                    bufferedImage = this.rightStereographOSI;
                }
            }
            if (SurfaceImplicit.this.taskManager == null) {
                SurfaceImplicit.this.taskManager = new TaskManager();
            }
            this.currentRayTraceJob = SurfaceImplicit.this.taskManager.createJob();
            int n = transform3D2.getHeight();
            for (int i = 0; i < n; ++i) {
                this.currentRayTraceJob.add(new RayTraceTask(this.rayTraceJobNum, transform3D2, transform3D, bufferedImage2, bufferedImage, i));
            }
            this.currentRayTraceJob.close();
            this.buildingImageForFilmstrip = true;
            this.rayTraceThread = new RayTraceThread(this.currentRayTraceJob, this.rayTraceJobNum);
            this.rayTraceThread.start();
        }

        private synchronized void finishRayTraceTask(RayTraceTask rayTraceTask) {
            if (rayTraceTask.jobID != this.rayTraceJobNum) {
                return;
            }
            if (this.leftAnaglyphGraphics != null) {
                int n;
                for (n = 0; n < rayTraceTask.width; ++n) {
                    this.leftAnaglyphGraphics.setColor(new Color(rayTraceTask.rgb1[n]));
                    this.leftAnaglyphGraphics.fillRect(n, rayTraceTask.y, 1, 1);
                }
                for (n = 0; n < rayTraceTask.width; ++n) {
                    this.rightAnaglyphGraphics.setColor(new Color(rayTraceTask.rgb2[n]));
                    this.rightAnaglyphGraphics.fillRect(n, rayTraceTask.y, 1, 1);
                }
            } else {
                rayTraceTask.image1.setRGB(0, rayTraceTask.y, rayTraceTask.width, 1, rayTraceTask.rgb1, 0, rayTraceTask.width);
                if (rayTraceTask.image2 != null) {
                    rayTraceTask.image2.setRGB(0, rayTraceTask.y, rayTraceTask.width, 1, rayTraceTask.rgb2, 0, rayTraceTask.width);
                }
            }
        }

        private class RayTraceTask
        implements Runnable {
            Transform3D transform1;
            Transform3D transform2;
            BufferedImage image1;
            BufferedImage image2;
            int y;
            int width;
            int jobID;
            int[] rgb1;
            int[] rgb2;

            RayTraceTask(int n, Transform3D transform3D, Transform3D transform3D2, BufferedImage bufferedImage, BufferedImage bufferedImage2, int n2) {
                this.transform1 = transform3D;
                this.transform2 = transform3D2;
                this.image1 = bufferedImage;
                this.image2 = bufferedImage2;
                this.y = n2;
                this.jobID = n;
            }

            void compute(int[] nArray, ImplicitSurfaceView implicitSurfaceView, Transform3D transform3D) {
                Point2D.Double double_ = new Point2D.Double();
                Vector3D vector3D = transform3D.getViewPoint();
                Vector3D vector3D2 = transform3D.getImagePlaneXDirection();
                Vector3D vector3D3 = transform3D.getImagePlaneYDirection();
                Color color = ImplicitSurfaceView.this.getBackground();
                if (ImplicitSurfaceView.this.getViewStyle() == 1) {
                    color = Color.BLACK;
                }
                int n = color.getRGB();
                double[] dArray = new double[5];
                for (int i = 0; i < this.width; ++i) {
                    dArray[0] = 0.0;
                    dArray[1] = 10000.0;
                    dArray[2] = 10000.0;
                    dArray[3] = 10000.0;
                    dArray[4] = 10000.0;
                    ((Point2D)double_).setLocation((double)i + 0.5, (double)this.y + 0.5);
                    transform3D.viewportToWindow(double_);
                    Vector3D vector3D4 = vector3D2.times(((Point2D)double_).getX());
                    Vector3D vector3D5 = vector3D3.times(((Point2D)double_).getY());
                    Vector3D vector3D6 = vector3D4.plus(vector3D5);
                    Vector3D vector3D7 = vector3D6.minus(vector3D).normalized();
                    double d = vector3D.dot(vector3D7);
                    Vector3D vector3D8 = vector3D.minus(vector3D7.times(d));
                    Line3D line3D = new Line3D(vector3D8, vector3D7);
                    Vector3D vector3D9 = SurfaceImplicit.this.heightFunctionType == equationType.QUADRATIC ? ImplicitSurfaceView.this.GetFirstIntersectionsOfLineWithQuadraticSurface(line3D, dArray) : (SurfaceImplicit.this.heightFunctionType == equationType.CUBIC ? ImplicitSurfaceView.this.GetFirstIntersectionsOfLineWithCubicSurface(line3D, dArray) : (SurfaceImplicit.this.heightFunctionType == equationType.QUARTIC ? ImplicitSurfaceView.this.GetFirstIntersectionsOfLineWithQuarticSurface(line3D, dArray) : ImplicitSurfaceView.this.GetFirstIntersectionsOfLineWithSurface(line3D)));
                    int n2 = n;
                    if (vector3D9.x != -12345.0) {
                        Vector3D vector3D10 = SurfaceImplicit.this.normalToSurfaceAt(vector3D9);
                        Color color2 = PhongLighting.phongLightingColor(vector3D10, implicitSurfaceView, ImplicitSurfaceView.this.getTransform3D(), vector3D9, Color.WHITE);
                        n2 = color2.getRGB();
                    }
                    nArray[i] = n2;
                }
            }

            public void run() {
                this.width = this.transform1.getWidth();
                this.rgb1 = new int[this.width];
                this.compute(this.rgb1, ImplicitSurfaceView.this, this.transform1);
                if (this.transform2 != null) {
                    this.rgb2 = new int[this.width];
                    this.compute(this.rgb2, ImplicitSurfaceView.this, this.transform2);
                }
                ImplicitSurfaceView.this.finishRayTraceTask(this);
            }
        }

        private class RayTraceThread
        extends Thread {
            TaskManager.Job job;
            int jobID;

            RayTraceThread(TaskManager.Job job, int n) {
                this.job = job;
                this.jobID = n;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    boolean bl;
                    do {
                        bl = this.job.await(500);
                        ImplicitSurfaceView implicitSurfaceView = ImplicitSurfaceView.this;
                        synchronized (implicitSurfaceView) {
                            Display display;
                            if (this.jobID != ImplicitSurfaceView.this.rayTraceJobNum) {
                                break;
                            }
                            if (bl) {
                                ImplicitSurfaceView.this.buildingImageForFilmstrip = false;
                            }
                            if ((display = ImplicitSurfaceView.this.getDisplay()) != null) {
                                Graphics2D graphics2D;
                                Decoration[] decorationArray;
                                Decoration[] decorationArray2 = ImplicitSurfaceView.this.getDecorations();
                                Exhibit exhibit = ImplicitSurfaceView.this.getExhibit();
                                Decoration[] decorationArray3 = decorationArray = exhibit == null ? new Decoration[]{} : exhibit.getDecorations();
                                if ((decorationArray2.length > 0 || decorationArray.length > 0) && (graphics2D = ImplicitSurfaceView.this.prepareOSIForDrawing()) != null) {
                                    for (Decoration decoration : decorationArray2) {
                                        decoration.doDraw(graphics2D, ImplicitSurfaceView.this, ImplicitSurfaceView.this.getTransform());
                                    }
                                    if (decorationArray != null) {
                                        for (Decoration decoration : decorationArray) {
                                            decoration.doDraw(graphics2D, ImplicitSurfaceView.this, ImplicitSurfaceView.this.getTransform());
                                        }
                                    }
                                    ImplicitSurfaceView.this.finishOSIDraw();
                                }
                                if (ImplicitSurfaceView.this.getViewStyle() == 1) {
                                    try {
                                        ImplicitSurfaceView.this.stereoComposite.compose();
                                    }
                                    catch (NullPointerException nullPointerException) {
                                        // empty catch block
                                    }
                                }
                                display.repaint();
                            }
                        }
                    } while (!bl);
                }
                finally {
                    ImplicitSurfaceView implicitSurfaceView = ImplicitSurfaceView.this;
                    synchronized (implicitSurfaceView) {
                        if (this.jobID == ImplicitSurfaceView.this.rayTraceJobNum) {
                            ImplicitSurfaceView.this.killRayTraceJob();
                        }
                    }
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CollectPointsForPointCloud {
        TaskManager.Job findPointsJob;
        ArrayList<FindPointsOnPointCloud> tasks;
        int tasksCompleted;

        CollectPointsForPointCloud(ArrayList<FindPointsOnPointCloud> arrayList, TaskManager.Job job) {
            this.tasks = arrayList;
            this.findPointsJob = job;
            SurfaceImplicit.this.numberOfPointsInCloud = 0;
        }

        synchronized void taskCompleted() {
            if (this.findPointsJob.isFinished()) {
                return;
            }
            while (this.tasks.get(this.tasksCompleted).isFinished()) {
                ArrayList<Vector3D> arrayList = this.tasks.get((int)this.tasksCompleted).points;
                Iterator<Vector3D> iterator = arrayList.iterator();
                while (iterator.hasNext()) {
                    Vector3D vector3D;
                    SurfaceImplicit.this.pointCloud[((SurfaceImplicit)SurfaceImplicit.this).numberOfPointsInCloud++] = vector3D = iterator.next();
                    if (SurfaceImplicit.this.numberOfPointsInCloud != SurfaceImplicit.this.pointCloud.length) continue;
                    this.findPointsJob.cancel();
                    break;
                }
                ++this.tasksCompleted;
                if (this.tasksCompleted < this.tasks.size()) continue;
                break;
            }
        }
    }

    private class FindPointsOnPointCloud
    implements Runnable {
        int startIndex;
        int endIndex;
        ArrayList<Vector3D> points = new ArrayList();
        boolean finished;
        CollectPointsForPointCloud owner;

        FindPointsOnPointCloud(CollectPointsForPointCloud collectPointsForPointCloud, int n, int n2) {
            this.owner = collectPointsForPointCloud;
            this.startIndex = n;
            this.endIndex = n2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean isFinished() {
            CollectPointsForPointCloud collectPointsForPointCloud = this.owner;
            synchronized (collectPointsForPointCloud) {
                return this.finished;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            double[] dArray = new double[5];
            for (int i = this.startIndex; i <= this.endIndex; ++i) {
                dArray[0] = 0.0;
                dArray[1] = 10000.0;
                dArray[2] = 10000.0;
                dArray[3] = 10000.0;
                dArray[4] = 10000.0;
                if (SurfaceImplicit.this.heightFunctionType == equationType.QUADRATIC) {
                    SurfaceImplicit.this.IntersectLineWithImplicitQuadraticSurface(SurfaceImplicit.this.ListOfRandomLines[i], dArray, this.points);
                    continue;
                }
                if (SurfaceImplicit.this.heightFunctionType == equationType.CUBIC) {
                    SurfaceImplicit.this.IntersectLineWithImplicitCubicSurface(SurfaceImplicit.this.ListOfRandomLines[i], dArray, this.points);
                    continue;
                }
                if (SurfaceImplicit.this.heightFunctionType == equationType.QUARTIC) {
                    SurfaceImplicit.this.IntersectLineWithImplicitQuarticSurface(SurfaceImplicit.this.ListOfRandomLines[i], dArray, this.points);
                    continue;
                }
                SurfaceImplicit.this.IntersectLineWithImplicitSurface(SurfaceImplicit.this.ListOfRandomLines[i], this.points);
            }
            CollectPointsForPointCloud collectPointsForPointCloud = this.owner;
            synchronized (collectPointsForPointCloud) {
                this.finished = true;
                this.owner.taskCompleted();
            }
        }
    }

    private class MakeRandomLines
    implements Runnable {
        int start;
        int end;

        MakeRandomLines(int n, int n2) {
            this.start = n;
            this.end = n2;
        }

        public void run() {
            Vector3D vector3D = Vector3D.UNIT_Z;
            Vector3D vector3D2 = new Vector3D();
            Random random = new Random(this.start);
            for (int i = this.start; i <= this.end; ++i) {
                double d = Math.PI * 2 * random.nextDouble();
                double d2 = Math.acos(random.nextDouble());
                Vector3D vector3D3 = new Vector3D();
                vector3D3.x = Math.sin(d2) * Math.cos(d);
                vector3D3.y = Math.sin(d2) * Math.sin(d);
                vector3D3.z = Math.cos(d2);
                double d3 = Math.PI * 2 * random.nextDouble();
                double d4 = Math.sqrt(random.nextDouble());
                vector3D2.x = d4 * Math.cos(d3);
                vector3D2.y = d4 * Math.sin(d3);
                vector3D2.z = 0.0;
                vector3D2 = vector3D2.times(SurfaceImplicit.this.searchRadius.getValue());
                Vector3D vector3D4 = Maps.Transvection(vector3D, vector3D3, vector3D2);
                SurfaceImplicit.this.ListOfRandomLines[i] = new Line3D(vector3D4, vector3D3);
            }
        }
    }

    public class Line3D {
        Vector3D intercept;
        Vector3D direction;

        public Vector3D parametricEquation(double d) {
            Vector3D vector3D = new Vector3D();
            vector3D.assignLinComb(1.0, this.intercept, d, this.direction);
            return vector3D;
        }

        public Line3D(Vector3D vector3D, Vector3D vector3D2) {
            this.intercept = vector3D;
            this.direction = vector3D2;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum equationType {
        OTHER,
        LINEAR,
        QUADRATIC,
        CUBIC,
        QUARTIC;

    }
}

