/*
 * Decompiled with CFR 0.152.
 */
package vmm.surface.implicit;

import vmm.core.RealParamAnimateable;
import vmm.core3D.Vector3D;
import vmm.surface.implicit.SurfaceImplicit;

public class SteinerRoman
extends SurfaceImplicit {
    private RealParamAnimateable a = new RealParamAnimateable("vmm.surface.implicit.SteinerRoman.a", 1.6, 1.6, 1.6);

    public static double sqr(double d) {
        return d * d;
    }

    public double heightFunction(double d, double d2, double d3) {
        double d4 = this.a.getValue();
        double d5 = SteinerRoman.sqr(d);
        double d6 = SteinerRoman.sqr(d2);
        double d7 = SteinerRoman.sqr(d3);
        double d8 = SteinerRoman.sqr(d4);
        double d9 = d8 * d8 * (d5 * d6 + d6 * d7 + d7 * d5) - 2.0 * d4 * d8 * d * d2 * d3;
        return d9;
    }

    public SteinerRoman() {
        this.addParameter(this.a);
        this.setDefaultWindow(-0.75, 0.75, -0.75, 0.75);
        this.setDefaultViewpoint(new Vector3D(10.0, -10.0, 10.0));
        this.searchRadius.reset(1.0);
        this.randomLineCount.reset(80000);
        this.pointCloudCount.reset(18000);
        this.level.reset(0.0, 0.0, 0.0);
        this.setFramesForMorphing(12);
        this.resolution = 0.01;
        this.rayTraceResolution.setValue(this.resolution);
        this.heightFunctionType = SurfaceImplicit.equationType.QUARTIC;
    }
}

