/*
 * Decompiled with CFR 0.152.
 */
package vmm.surface.implicit;

import vmm.core3D.Vector3D;

public class Maps {
    static double dotProd(Vector3D vector3D, Vector3D vector3D2) {
        return vector3D.x * vector3D2.x + vector3D.y * vector3D2.y + vector3D.z * vector3D2.z;
    }

    public static void ProjectOnAxis(Vector3D vector3D, Vector3D vector3D2, Vector3D vector3D3) {
        vector3D3 = vector3D.times(Maps.dotProd(vector3D, vector3D2));
    }

    public static Vector3D ProjectionOnAxis(Vector3D vector3D, Vector3D vector3D2) {
        return vector3D.times(Maps.dotProd(vector3D, vector3D2));
    }

    public static void ReflectInAxis(Vector3D vector3D, Vector3D vector3D2, Vector3D vector3D3) {
        vector3D3 = vector3D.times(2.0 * Maps.dotProd(vector3D, vector3D2)).minus(vector3D2);
    }

    public static Vector3D ReflectionInAxis(Vector3D vector3D, Vector3D vector3D2) {
        return vector3D.times(2.0 * Maps.dotProd(vector3D, vector3D2)).minus(vector3D2);
    }

    public static void Transvect(Vector3D vector3D, Vector3D vector3D2, Vector3D vector3D3, Vector3D vector3D4) {
        Vector3D vector3D5 = new Vector3D(vector3D.plus(vector3D2).normalized());
        Maps.ReflectInAxis(vector3D5, Maps.ReflectionInAxis(vector3D, vector3D3), vector3D4);
    }

    public static Vector3D Transvection(Vector3D vector3D, Vector3D vector3D2, Vector3D vector3D3) {
        Vector3D vector3D4 = new Vector3D(vector3D.plus(vector3D2).normalized());
        return Maps.ReflectionInAxis(vector3D4, Maps.ReflectionInAxis(vector3D, vector3D3));
    }
}

