/*
 * Decompiled with CFR 0.152.
 */
package vmm.surface.implicit;

import vmm.core.RealParamAnimateable;
import vmm.core3D.Vector3D;
import vmm.surface.implicit.SurfaceImplicit;

public class KummerQuartic
extends SurfaceImplicit {
    private RealParamAnimateable a = new RealParamAnimateable("vmm.surface.implicit.KummerQuartic.a", 1.3, 1.0, 1.5);

    public static double sqr(double d) {
        return d * d;
    }

    public double heightFunction(double d, double d2, double d3) {
        double d4 = this.a.getValue();
        double d5 = KummerQuartic.sqr(d);
        double d6 = KummerQuartic.sqr(d2);
        double d7 = KummerQuartic.sqr(d3);
        double d8 = (3.0 * KummerQuartic.sqr(d4) - 1.0) / (3.0 - KummerQuartic.sqr(d4));
        double d9 = Math.sqrt(2.0);
        double d10 = 1.0 - d3 - d9 * d;
        double d11 = 1.0 - d3 + d9 * d;
        double d12 = 1.0 + d3 + d9 * d2;
        double d13 = 1.0 + d3 - d9 * d2;
        double d14 = KummerQuartic.sqr(d5 + d6 + d7 - KummerQuartic.sqr(d4)) - d8 * d10 * d11 * d12 * d13;
        return d14;
    }

    public KummerQuartic() {
        this.addParameter(this.a);
        this.setDefaultWindow(-3.25, 3.25, -3.25, 3.25);
        this.setDefaultViewpoint(new Vector3D(-9.92, 9.1, -11.65));
        this.setDefaultViewUp(new Vector3D(-0.52, 0.39, 0.75));
        this.searchRadius.reset(3.0);
        this.randomLineCount.reset(60000);
        this.pointCloudCount.reset(24000);
        this.level.reset(0.0, 0.05, 0.1);
        this.setFramesForMorphing(12);
        this.heightFunctionType = SurfaceImplicit.equationType.QUARTIC;
    }
}

