/*
 * Decompiled with CFR 0.152.
 */
package vmm.surface.implicit;

import vmm.core.RealParamAnimateable;
import vmm.core3D.Vector3D;
import vmm.surface.implicit.SurfaceImplicit;

public class ImplicitHyperboloid2Sheet
extends SurfaceImplicit {
    private RealParamAnimateable a = new RealParamAnimateable("vmm.surface.implicit.Hyperboloid2.a", 0.6, 0.6, 0.8);
    private RealParamAnimateable b = new RealParamAnimateable("vmm.surface.implicit.Hyperboloid2.b", 10.0, 10.0, 8.0);

    public static double sqr(double d) {
        return d * d;
    }

    public double heightFunction(double d, double d2, double d3) {
        double d4 = this.a.getValue();
        double d5 = this.b.getValue();
        double d6 = d5 * (ImplicitHyperboloid2Sheet.sqr(d) - ImplicitHyperboloid2Sheet.sqr(d2) - ImplicitHyperboloid2Sheet.sqr(d3 / d4));
        return d6;
    }

    public ImplicitHyperboloid2Sheet() {
        this.addParameter(this.b);
        this.addParameter(this.a);
        this.setDefaultWindow(-1.5, 1.5, -1.5, 1.5);
        this.setDefaultViewpoint(new Vector3D(9.0, 500.0, -1.5));
        this.searchRadius.reset(3.0);
        this.pointCloudCount.reset(12000);
        this.level.reset(1.0, 1.0, 1.0);
        this.heightFunctionType = SurfaceImplicit.equationType.QUADRATIC;
    }
}

