/*
 * Decompiled with CFR 0.152.
 */
package vmm.surface.implicit;

import vmm.core.RealParamAnimateable;
import vmm.core3D.Vector3D;
import vmm.surface.implicit.SurfaceImplicit;

public class ImplicitEllipsoid
extends SurfaceImplicit {
    private RealParamAnimateable xSemiAxis = new RealParamAnimateable("vmm.surface.implicit.Ellipsoid.xSemiaxis", 1.0, 1.0, 1.5);
    private RealParamAnimateable ySemiAxis = new RealParamAnimateable("vmm.surface.implicit.Ellipsoid.ySemiaxis", 1.75, 1.75, 1.0);
    private RealParamAnimateable zSemiAxis = new RealParamAnimateable("vmm.surface.implicit.Ellipsoid.zSemiaxis", 1.25, 1.25, 1.75);

    public static double sqr(double d) {
        return d * d;
    }

    public double heightFunction(double d, double d2, double d3) {
        double d4 = this.xSemiAxis.getValue();
        double d5 = this.ySemiAxis.getValue();
        double d6 = this.zSemiAxis.getValue();
        double d7 = ImplicitEllipsoid.sqr(d / d4) + ImplicitEllipsoid.sqr(d2 / d5) + ImplicitEllipsoid.sqr(d3 / d6);
        return d7;
    }

    public ImplicitEllipsoid() {
        this.addParameter(this.zSemiAxis);
        this.addParameter(this.ySemiAxis);
        this.addParameter(this.xSemiAxis);
        this.setDefaultWindow(-2.0, 2.0, -2.0, 2.0);
        this.setDefaultViewpoint(new Vector3D(10.0, -10.0, 10.0));
        this.searchRadius.reset(3.0);
        this.level.reset(1.0);
        this.pointCloudCount.reset(12000);
        this.heightFunctionType = SurfaceImplicit.equationType.QUADRATIC;
    }
}

