/*
 * Decompiled with CFR 0.152.
 */
package vmm.surface.implicit;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import vmm.actions.ActionList;
import vmm.actions.ToggleAction;
import vmm.core.Decoration;
import vmm.core.I18n;
import vmm.core.Transform;
import vmm.core.VMMSave;
import vmm.core.View;
import vmm.core3D.Transform3D;
import vmm.core3D.Vector3D;
import vmm.core3D.View3D;
import vmm.surface.implicit.SurfaceImplicit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClebschCubic
extends SurfaceImplicit {
    double[][][] TwentySevenLineArray = new double[28][4][3];

    double sqr(double d) {
        return d * d;
    }

    static double sqrt(double d) {
        return Math.sqrt(d);
    }

    static double cube(double d) {
        return d * d * d;
    }

    @Override
    public double heightFunction(double d, double d2, double d3) {
        double d4 = this.sqr(d);
        double d5 = this.sqr(d2);
        double d6 = this.sqr(d3);
        double d7 = d * d4;
        double d8 = d2 * d5;
        double d9 = d3 * d6;
        double d10 = -(81.0 * (d7 + d8 + d9) - 189.0 * (d4 * d2 + d4 * d3 + d5 * d + d5 * d3 + d6 * d + d6 * d2) + 54.0 * d * d2 * d3 + 126.0 * (d * d2 + d * d3 + d2 * d3) - 9.0 * (d4 + d5 + d6) - 9.0 * (d + d2 + d3) + 1.0);
        return d10;
    }

    public ClebschCubic() {
        this.setDefaultWindow(-3.5, 3.5, -3.5, 3.5);
        this.setDefaultViewpoint(new Vector3D(26.5, -7.25, -7.25));
        this.setDefaultViewUp(new Vector3D(0.3608, 0.6595, 0.6595));
        this.searchRadius.reset(3.0);
        this.randomLineCount.reset(60000);
        this.pointCloudCount.reset(12000);
        this.level.reset(0.0);
        this.setFramesForMorphing(11);
        this.InitializeTwentySevenLineArray();
        this.heightFunctionType = SurfaceImplicit.equationType.CUBIC;
    }

    @Override
    public View getDefaultView() {
        return new ClebschView();
    }

    private double implicitFunctionOfSearchSphereAlongRay(int n, double d) {
        Vector3D vector3D = new Vector3D(this.ClebschLine(n, d));
        return this.sqr(vector3D.norm()) - this.sqr(this.searchRadius.getValue());
    }

    private Vector3D[] findVisibleSegmentOfClebschLine(int n, View3D view3D) {
        boolean bl;
        double d = 0.5 * (this.implicitFunctionOfSearchSphereAlongRay(n, 1.0) - this.implicitFunctionOfSearchSphereAlongRay(n, -1.0));
        double d2 = this.implicitFunctionOfSearchSphereAlongRay(n, 0.0);
        double d3 = this.implicitFunctionOfSearchSphereAlongRay(n, 1.0) - d - d2;
        double d4 = d * d - 4.0 * d3 * d2;
        boolean bl2 = bl = d4 > 0.0;
        if (bl) {
            double d5 = (-d - ClebschCubic.sqrt(d4)) / (2.0 * d3);
            double d6 = (-d + ClebschCubic.sqrt(d4)) / (2.0 * d3);
            Vector3D vector3D = new Vector3D(this.ClebschLine(n, d5));
            Vector3D vector3D2 = new Vector3D(this.ClebschLine(n, d6));
            return new Vector3D[]{vector3D, vector3D2};
        }
        return null;
    }

    private void findUnHiddenLineSegments(Vector3D vector3D, Vector3D vector3D2, SurfaceImplicit.ImplicitSurfaceView implicitSurfaceView, Transform3D transform3D, ArrayList<Vector3D[]> arrayList) {
        Vector3D vector3D3 = transform3D.getViewPoint();
        double[] dArray = new double[5];
        double d = transform3D.getPixelWidth();
        Point2D point2D = transform3D.objectToXYWindowCoords(vector3D);
        Point2D point2D2 = transform3D.objectToXYWindowCoords(vector3D2);
        double d2 = ClebschCubic.sqrt(this.sqr(point2D.getX() - point2D2.getX()) + this.sqr(point2D.getY() - point2D2.getY()));
        int n = (int)(d2 / d);
        if (n > 100) {
            n = 100;
        }
        if (n == 0) {
            if (!this.isHidden(vector3D, vector3D3, implicitSurfaceView, transform3D, dArray)) {
                arrayList.add(new Vector3D[]{vector3D, vector3D});
            }
            return;
        }
        double d3 = d2 / (double)n / d;
        Vector3D vector3D4 = vector3D2.minus(vector3D).times(1.0 / (double)n);
        Vector3D vector3D5 = vector3D;
        boolean bl = this.isHidden(vector3D5, vector3D3, implicitSurfaceView, transform3D, dArray);
        Vector3D vector3D6 = bl ? null : vector3D5;
        for (int i = 1; i <= n; ++i) {
            Vector3D vector3D7 = vector3D.plus(vector3D4.times(i));
            boolean bl2 = this.isHidden(vector3D7, vector3D3, implicitSurfaceView, transform3D, dArray);
            if (bl != bl2) {
                Vector3D vector3D8 = vector3D5;
                Vector3D vector3D9 = vector3D7;
                boolean bl3 = bl;
                Vector3D vector3D10 = vector3D8.plus(vector3D9).times(0.5);
                for (double d4 = d3; d4 > 1.0; d4 /= 2.0) {
                    boolean bl4 = this.isHidden(vector3D10, vector3D3, implicitSurfaceView, transform3D, dArray);
                    if (bl4 == bl3) {
                        vector3D8 = vector3D10;
                    } else {
                        vector3D9 = vector3D10;
                    }
                    vector3D10 = vector3D8.plus(vector3D9).times(0.5);
                }
                if (bl2) {
                    arrayList.add(new Vector3D[]{vector3D6, vector3D10});
                    vector3D6 = null;
                } else {
                    vector3D6 = vector3D10;
                }
            }
            if (i == n && !bl2) {
                arrayList.add(new Vector3D[]{vector3D6, vector3D7});
            }
            vector3D5 = vector3D7;
            bl = bl2;
        }
    }

    private boolean isHidden(Vector3D vector3D, Vector3D vector3D2, SurfaceImplicit.ImplicitSurfaceView implicitSurfaceView, Transform3D transform3D, double[] dArray) {
        Vector3D vector3D3 = vector3D.minus(vector3D2).normalized();
        double d = vector3D2.dot(vector3D3);
        Vector3D vector3D4 = vector3D2.minus(vector3D3.times(d));
        SurfaceImplicit.Line3D line3D = new SurfaceImplicit.Line3D(this, vector3D4, vector3D3);
        Vector3D vector3D5 = implicitSurfaceView.GetFirstIntersectionsOfLineWithCubicSurface(line3D, dArray);
        if (vector3D5.x == -12345.0) {
            return false;
        }
        Vector3D vector3D6 = vector3D.minus(vector3D5);
        if (vector3D6.norm() < 0.05) {
            return false;
        }
        return !(vector3D6.dot(vector3D3) < 0.0);
    }

    protected Vector3D ClebschLine(int n, double d) {
        Vector3D vector3D = new Vector3D();
        vector3D.x = this.TwentySevenLineArray[n][1][1] + this.TwentySevenLineArray[n][1][2] * d;
        vector3D.y = this.TwentySevenLineArray[n][2][1] + this.TwentySevenLineArray[n][2][2] * d;
        vector3D.z = this.TwentySevenLineArray[n][3][1] + this.TwentySevenLineArray[n][3][2] * d;
        return vector3D;
    }

    protected void InitializeTwentySevenLineArray() {
        this.TwentySevenLineArray[1][1][1] = -0.3333333333333333;
        this.TwentySevenLineArray[1][1][2] = 0.0;
        this.TwentySevenLineArray[1][2][1] = 0.0;
        this.TwentySevenLineArray[1][2][2] = -1.0;
        this.TwentySevenLineArray[1][3][1] = 0.0;
        this.TwentySevenLineArray[1][3][2] = 1.0;
        this.TwentySevenLineArray[2][1][1] = -0.3333333333333333;
        this.TwentySevenLineArray[2][1][2] = 3.0;
        this.TwentySevenLineArray[2][2][1] = 0.0;
        this.TwentySevenLineArray[2][2][2] = 0.0;
        this.TwentySevenLineArray[2][3][1] = 0.0;
        this.TwentySevenLineArray[2][3][2] = 1.0;
        this.TwentySevenLineArray[3][1][1] = 0.0;
        this.TwentySevenLineArray[3][1][2] = -1.0;
        this.TwentySevenLineArray[3][2][1] = -0.3333333333333333;
        this.TwentySevenLineArray[3][2][2] = 0.0;
        this.TwentySevenLineArray[3][3][1] = 0.0;
        this.TwentySevenLineArray[3][3][2] = 1.0;
        this.TwentySevenLineArray[4][1][1] = 0.0;
        this.TwentySevenLineArray[4][1][2] = 0.0;
        this.TwentySevenLineArray[4][2][1] = -0.3333333333333333;
        this.TwentySevenLineArray[4][2][2] = 3.0;
        this.TwentySevenLineArray[4][3][1] = 0.0;
        this.TwentySevenLineArray[4][3][2] = 1.0;
        this.TwentySevenLineArray[5][1][1] = 0.0;
        this.TwentySevenLineArray[5][1][2] = 0.0;
        this.TwentySevenLineArray[5][2][1] = 0.1111111111111111;
        this.TwentySevenLineArray[5][2][2] = 0.3333333333333333;
        this.TwentySevenLineArray[5][3][1] = 0.0;
        this.TwentySevenLineArray[5][3][2] = 1.0;
        this.TwentySevenLineArray[6][1][1] = 0.0;
        this.TwentySevenLineArray[6][1][2] = 0.0;
        this.TwentySevenLineArray[6][2][1] = 0.3333333333333333;
        this.TwentySevenLineArray[6][2][2] = -1.0;
        this.TwentySevenLineArray[6][3][1] = 0.0;
        this.TwentySevenLineArray[6][3][2] = 1.0;
        this.TwentySevenLineArray[7][1][1] = 0.1111111111111111;
        this.TwentySevenLineArray[7][1][2] = 0.3333333333333333;
        this.TwentySevenLineArray[7][2][1] = 0.0;
        this.TwentySevenLineArray[7][2][2] = 0.0;
        this.TwentySevenLineArray[7][3][1] = 0.0;
        this.TwentySevenLineArray[7][3][2] = 1.0;
        this.TwentySevenLineArray[8][1][1] = 0.3333333333333333;
        this.TwentySevenLineArray[8][1][2] = -1.0;
        this.TwentySevenLineArray[8][2][1] = 0.0;
        this.TwentySevenLineArray[8][2][2] = 0.0;
        this.TwentySevenLineArray[8][3][1] = 0.0;
        this.TwentySevenLineArray[8][3][2] = 1.0;
        this.TwentySevenLineArray[9][1][1] = 0.3333333333333333;
        this.TwentySevenLineArray[9][1][2] = 0.0;
        this.TwentySevenLineArray[9][2][1] = 0.6666666666666666;
        this.TwentySevenLineArray[9][2][2] = -1.0;
        this.TwentySevenLineArray[9][3][1] = 0.0;
        this.TwentySevenLineArray[9][3][2] = 1.0;
        this.TwentySevenLineArray[10][1][1] = 0.6666666666666666;
        this.TwentySevenLineArray[10][1][2] = -1.0;
        this.TwentySevenLineArray[10][2][1] = 0.3333333333333333;
        this.TwentySevenLineArray[10][2][2] = 0.0;
        this.TwentySevenLineArray[10][3][1] = 0.0;
        this.TwentySevenLineArray[10][3][2] = 1.0;
        this.TwentySevenLineArray[11][1][1] = 0.16666666666666666 - ClebschCubic.sqrt(5.0) / 10.0;
        this.TwentySevenLineArray[11][1][2] = ClebschCubic.sqrt(5.0) / 5.0;
        this.TwentySevenLineArray[11][2][1] = 0.16666666666666666 - 1.0 / (6.0 * ClebschCubic.sqrt(5.0));
        this.TwentySevenLineArray[11][2][2] = 1.0 - 3.0 / ClebschCubic.sqrt(5.0);
        this.TwentySevenLineArray[11][3][1] = 0.0;
        this.TwentySevenLineArray[11][3][2] = 1.0;
        this.TwentySevenLineArray[12][1][1] = (7.0 - 3.0 * ClebschCubic.sqrt(5.0)) / 6.0;
        this.TwentySevenLineArray[12][1][2] = -3.0 + ClebschCubic.sqrt(5.0);
        this.TwentySevenLineArray[12][2][1] = 0.5 - ClebschCubic.sqrt(5.0) / 6.0;
        this.TwentySevenLineArray[12][2][2] = ClebschCubic.sqrt(5.0);
        this.TwentySevenLineArray[12][3][1] = 0.0;
        this.TwentySevenLineArray[12][3][2] = 1.0;
        this.TwentySevenLineArray[13][1][1] = (1.0 - ClebschCubic.sqrt(5.0)) / 12.0;
        this.TwentySevenLineArray[13][1][2] = (-5.0 + 3.0 * ClebschCubic.sqrt(5.0)) / 4.0;
        this.TwentySevenLineArray[13][2][1] = (3.0 + ClebschCubic.sqrt(5.0)) / 12.0;
        this.TwentySevenLineArray[13][2][2] = (-3.0 + ClebschCubic.sqrt(5.0)) / 4.0;
        this.TwentySevenLineArray[13][3][1] = 0.0;
        this.TwentySevenLineArray[13][3][2] = 1.0;
        this.TwentySevenLineArray[14][1][1] = (3.0 - ClebschCubic.sqrt(5.0)) / 12.0;
        this.TwentySevenLineArray[14][1][2] = -(3.0 + ClebschCubic.sqrt(5.0)) / 4.0;
        this.TwentySevenLineArray[14][2][1] = (1.0 + ClebschCubic.sqrt(5.0)) / 12.0;
        this.TwentySevenLineArray[14][2][2] = -(5.0 + 3.0 * ClebschCubic.sqrt(5.0)) / 4.0;
        this.TwentySevenLineArray[14][3][1] = 0.0;
        this.TwentySevenLineArray[14][3][2] = 1.0;
        this.TwentySevenLineArray[15][1][1] = 0.5 - ClebschCubic.sqrt(5.0) / 6.0;
        this.TwentySevenLineArray[15][1][2] = ClebschCubic.sqrt(5.0);
        this.TwentySevenLineArray[15][2][1] = (7.0 - 3.0 * ClebschCubic.sqrt(5.0)) / 6.0;
        this.TwentySevenLineArray[15][2][2] = -3.0 + ClebschCubic.sqrt(5.0);
        this.TwentySevenLineArray[15][3][1] = 0.0;
        this.TwentySevenLineArray[15][3][2] = 1.0;
        this.TwentySevenLineArray[16][1][1] = 0.16666666666666666 - 1.0 / (6.0 * ClebschCubic.sqrt(5.0));
        this.TwentySevenLineArray[16][1][2] = 1.0 - 3.0 / ClebschCubic.sqrt(5.0);
        this.TwentySevenLineArray[16][2][1] = 0.16666666666666666 - ClebschCubic.sqrt(5.0) / 10.0;
        this.TwentySevenLineArray[16][2][2] = ClebschCubic.sqrt(5.0) / 5.0;
        this.TwentySevenLineArray[16][3][1] = 0.0;
        this.TwentySevenLineArray[16][3][2] = 1.0;
        this.TwentySevenLineArray[17][1][1] = (1.0 + ClebschCubic.sqrt(5.0)) / 12.0;
        this.TwentySevenLineArray[17][1][2] = -(5.0 + 3.0 * ClebschCubic.sqrt(5.0)) / 4.0;
        this.TwentySevenLineArray[17][2][1] = (3.0 - ClebschCubic.sqrt(5.0)) / 12.0;
        this.TwentySevenLineArray[17][2][2] = -(3.0 + ClebschCubic.sqrt(5.0)) / 4.0;
        this.TwentySevenLineArray[17][3][1] = 0.0;
        this.TwentySevenLineArray[17][3][2] = 1.0;
        this.TwentySevenLineArray[18][1][1] = (3.0 + ClebschCubic.sqrt(5.0)) / 12.0;
        this.TwentySevenLineArray[18][1][2] = (-3.0 + ClebschCubic.sqrt(5.0)) / 4.0;
        this.TwentySevenLineArray[18][2][1] = (1.0 - ClebschCubic.sqrt(5.0)) / 12.0;
        this.TwentySevenLineArray[18][2][2] = (-5.0 + 3.0 * ClebschCubic.sqrt(5.0)) / 4.0;
        this.TwentySevenLineArray[18][3][1] = 0.0;
        this.TwentySevenLineArray[18][3][2] = 1.0;
        this.TwentySevenLineArray[19][1][1] = (3.0 + ClebschCubic.sqrt(5.0)) / 6.0;
        this.TwentySevenLineArray[19][1][2] = -ClebschCubic.sqrt(5.0);
        this.TwentySevenLineArray[19][2][1] = (7.0 + 3.0 * ClebschCubic.sqrt(5.0)) / 6.0;
        this.TwentySevenLineArray[19][2][2] = -(3.0 + ClebschCubic.sqrt(5.0));
        this.TwentySevenLineArray[19][3][1] = 0.0;
        this.TwentySevenLineArray[19][3][2] = 1.0;
        this.TwentySevenLineArray[20][1][1] = (5.0 + ClebschCubic.sqrt(5.0)) / 30.0;
        this.TwentySevenLineArray[20][1][2] = 1.0 + 3.0 / ClebschCubic.sqrt(5.0);
        this.TwentySevenLineArray[20][2][1] = 5.0 + 3.0 * ClebschCubic.sqrt(5.0);
        this.TwentySevenLineArray[20][2][2] = -ClebschCubic.sqrt(5.0) / 5.0;
        this.TwentySevenLineArray[20][3][1] = 0.0;
        this.TwentySevenLineArray[20][3][2] = 1.0;
        this.TwentySevenLineArray[21][1][1] = 0.16666666666666666 + ClebschCubic.sqrt(5.0) / 10.0;
        this.TwentySevenLineArray[21][1][2] = -ClebschCubic.sqrt(5.0) / 5.0;
        this.TwentySevenLineArray[21][2][1] = (5.0 + ClebschCubic.sqrt(5.0)) / 30.0;
        this.TwentySevenLineArray[21][2][2] = 1.0 + 3.0 / ClebschCubic.sqrt(5.0);
        this.TwentySevenLineArray[21][3][1] = 0.0;
        this.TwentySevenLineArray[21][3][2] = 1.0;
        this.TwentySevenLineArray[22][1][1] = (7.0 + 3.0 * ClebschCubic.sqrt(5.0)) / 6.0;
        this.TwentySevenLineArray[22][1][2] = -(3.0 + ClebschCubic.sqrt(5.0));
        this.TwentySevenLineArray[22][2][1] = (3.0 + ClebschCubic.sqrt(5.0)) / 6.0;
        this.TwentySevenLineArray[22][2][2] = -ClebschCubic.sqrt(5.0);
        this.TwentySevenLineArray[22][3][1] = 0.0;
        this.TwentySevenLineArray[22][3][2] = 1.0;
        this.TwentySevenLineArray[23][1][1] = -0.3333333333333333;
        this.TwentySevenLineArray[23][1][2] = 3.0;
        this.TwentySevenLineArray[23][2][1] = 0.0;
        this.TwentySevenLineArray[23][2][2] = 1.0;
        this.TwentySevenLineArray[23][3][1] = 0.0;
        this.TwentySevenLineArray[23][3][2] = 0.0;
        this.TwentySevenLineArray[24][1][1] = 0.0;
        this.TwentySevenLineArray[24][1][2] = -1.0;
        this.TwentySevenLineArray[24][2][1] = 0.0;
        this.TwentySevenLineArray[24][2][2] = 1.0;
        this.TwentySevenLineArray[24][3][1] = -0.3333333333333333;
        this.TwentySevenLineArray[24][3][2] = 0.0;
        this.TwentySevenLineArray[25][1][1] = 0.1111111111111111;
        this.TwentySevenLineArray[25][1][2] = 0.3333333333333333;
        this.TwentySevenLineArray[25][2][1] = 0.0;
        this.TwentySevenLineArray[25][2][2] = 1.0;
        this.TwentySevenLineArray[25][3][1] = 0.0;
        this.TwentySevenLineArray[25][3][2] = 0.0;
        this.TwentySevenLineArray[26][1][1] = 0.3333333333333333;
        this.TwentySevenLineArray[26][1][2] = -1.0;
        this.TwentySevenLineArray[26][2][1] = 0.0;
        this.TwentySevenLineArray[26][2][2] = 1.0;
        this.TwentySevenLineArray[26][3][1] = 0.0;
        this.TwentySevenLineArray[26][3][2] = 0.0;
        this.TwentySevenLineArray[27][1][1] = 0.6666666666666666;
        this.TwentySevenLineArray[27][1][2] = -1.0;
        this.TwentySevenLineArray[27][2][1] = 0.0;
        this.TwentySevenLineArray[27][2][2] = 1.0;
        this.TwentySevenLineArray[27][3][1] = 0.3333333333333333;
        this.TwentySevenLineArray[27][3][2] = 0.0;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ClebschView
    extends SurfaceImplicit.ImplicitSurfaceView {
        @VMMSave
        private boolean drawLines;
        private LinesOnCubic linesDecoration;
        ToggleAction drawLinesToggle;

        public ClebschView() {
            super(ClebschCubic.this);
            this.drawLines = true;
            this.drawLinesToggle = new ToggleAction(I18n.tr("vmm.surface.implicit.ClebschCubic.DrawLines"), true){

                public void actionPerformed(ActionEvent actionEvent) {
                    ClebschView.this.setDrawLines(this.getState());
                }
            };
            this.linesDecoration = new LinesOnCubic();
            this.addDecoration(this.linesDecoration);
        }

        public boolean getDrawLines() {
            return this.drawLines;
        }

        public void setDrawLines(boolean bl) {
            if (this.drawLines == bl) {
                return;
            }
            this.drawLines = bl;
            this.drawLinesToggle.setState(bl);
            if (bl) {
                this.linesDecoration = new LinesOnCubic();
                this.addDecoration(this.linesDecoration);
            } else {
                this.removeDecoration(this.linesDecoration);
                this.linesDecoration = null;
            }
        }

        @Override
        public ActionList getActions() {
            ActionList actionList = super.getActions();
            actionList.add(null);
            actionList.add(this.drawLinesToggle);
            return actionList;
        }

        Transform3D[] getStereoViewingTransforms() {
            this.setUpForLeftEye();
            Transform3D transform3D = (Transform3D)this.getTransform3D().clone();
            this.setUpForRightEye();
            Transform3D transform3D2 = (Transform3D)this.getTransform3D().clone();
            this.finishStereoView();
            return new Transform3D[]{transform3D, transform3D2};
        }

        void drawLinesOnCubic(ArrayList<Vector3D[]> arrayList, ArrayList<Vector3D[]> arrayList2) {
            Point2D.Double double_ = new Point2D.Double();
            Point2D.Double double_2 = new Point2D.Double();
            this.setUpForLeftEye();
            for (Vector3D[] vector3DArray : arrayList) {
                this.currentGraphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                this.transform3D.objectToDrawingCoords(vector3DArray[0], double_);
                this.transform3D.objectToDrawingCoords(vector3DArray[1], double_2);
                this.currentGraphics.draw(new Line2D.Float(double_, double_2));
            }
            this.setUpForRightEye();
            for (Vector3D[] vector3DArray : arrayList2) {
                this.currentGraphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                this.transform3D.objectToDrawingCoords(vector3DArray[0], double_);
                this.transform3D.objectToDrawingCoords(vector3DArray[1], double_2);
                this.currentGraphics.draw(new Line2D.Float(double_, double_2));
            }
            this.finishStereoView();
        }
    }

    private class LinesOnCubic
    extends Decoration {
        Vector3D[][] lines = new Vector3D[27][2];
        ArrayList<Vector3D[]> lineSegmentsToDraw = new ArrayList();
        ArrayList<Vector3D[]> lineSegmentsToDrawForRightStereo = new ArrayList();
        double computedForSearchRadius;
        boolean computedForRayTrace;
        boolean computedForMonocularRayTrace;

        private LinesOnCubic() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void computeDrawData(View view, boolean bl, Transform transform, Transform transform2) {
            View view2 = view;
            synchronized (view2) {
                boolean bl2;
                int n;
                boolean bl3;
                ClebschView clebschView = (ClebschView)view;
                boolean bl4 = bl3 = this.lineSegmentsToDraw.size() == 0;
                if (this.computedForSearchRadius != ClebschCubic.this.searchRadius.getValue()) {
                    this.computedForSearchRadius = ClebschCubic.this.searchRadius.getValue();
                    bl3 = true;
                    for (n = 0; n < 27; ++n) {
                        this.lines[n] = ClebschCubic.this.findVisibleSegmentOfClebschLine(n + 1, (View3D)view);
                    }
                }
                if (this.computedForRayTrace != (n = clebschView.getUseRaytraceRendering())) {
                    this.computedForRayTrace = n;
                    bl3 = true;
                }
                boolean bl5 = bl2 = n != 0 && clebschView.getViewStyle() == 0;
                if (bl2 != this.computedForMonocularRayTrace) {
                    this.computedForMonocularRayTrace = bl2;
                    bl3 = true;
                }
                if (n != 0 && !transform2.equals(transform)) {
                    bl3 = true;
                }
                if (!bl3) {
                    return;
                }
                this.lineSegmentsToDraw.clear();
                this.lineSegmentsToDrawForRightStereo.clear();
                if (n != 0) {
                    if (this.computedForMonocularRayTrace) {
                        for (Vector3D[] vector3DArray : this.lines) {
                            if (vector3DArray == null) continue;
                            ClebschCubic.this.findUnHiddenLineSegments(vector3DArray[0], vector3DArray[1], clebschView, (Transform3D)transform2, this.lineSegmentsToDraw);
                        }
                    } else {
                        Transform3D[] transform3DArray = clebschView.getStereoViewingTransforms();
                        for (Vector3D[] vector3DArray : this.lines) {
                            if (vector3DArray == null) continue;
                            ClebschCubic.this.findUnHiddenLineSegments(vector3DArray[0], vector3DArray[1], clebschView, transform3DArray[0], this.lineSegmentsToDraw);
                            ClebschCubic.this.findUnHiddenLineSegments(vector3DArray[0], vector3DArray[1], clebschView, transform3DArray[1], this.lineSegmentsToDrawForRightStereo);
                        }
                    }
                } else {
                    for (Vector3D[] vector3DArray : this.lines) {
                        if (vector3DArray == null) continue;
                        this.lineSegmentsToDraw.add(vector3DArray);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void doDraw(Graphics2D graphics2D, View view, Transform transform) {
            ClebschView clebschView;
            ClebschView clebschView2 = clebschView = (ClebschView)view;
            synchronized (clebschView2) {
                boolean bl = clebschView.getUseRaytraceRendering();
                if (bl) {
                    clebschView.setColor(Color.BLACK);
                } else if (clebschView.getViewStyle() == 1) {
                    clebschView.setColor(null);
                } else {
                    clebschView.setColor(Color.RED);
                }
                if (bl && !this.computedForMonocularRayTrace) {
                    clebschView.drawLinesOnCubic(this.lineSegmentsToDraw, this.lineSegmentsToDrawForRightStereo);
                } else {
                    graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                    for (Vector3D[] vector3DArray : this.lineSegmentsToDraw) {
                        clebschView.drawLine(vector3DArray[0], vector3DArray[1]);
                    }
                }
            }
        }
    }
}

