/*
 * Decompiled with CFR 0.152.
 */
package vmm.surface.implicit;

import vmm.core3D.Vector3D;
import vmm.surface.implicit.SurfaceImplicit;

public class CayleyCubic
extends SurfaceImplicit {
    public static double sqr(double d) {
        return d * d;
    }

    public double heightFunction(double d, double d2, double d3) {
        double d4 = CayleyCubic.sqr(d);
        double d5 = CayleyCubic.sqr(d2);
        double d6 = CayleyCubic.sqr(d3);
        double d7 = 4.0 * (d4 + d5 + d6) + 16.0 * d * d2 * d3;
        return d7;
    }

    public CayleyCubic() {
        this.setDefaultWindow(-3.25, 3.25, -3.25, 3.25);
        this.setDefaultViewpoint(new Vector3D(-7.0, -10.0, 10.0));
        this.setDefaultViewUp(new Vector3D(0.3634, 0.5192, 0.774));
        this.searchRadius.reset(3.0);
        this.randomLineCount.reset(60000);
        this.pointCloudCount.reset(12000);
        this.level.reset(1.0, 0.0, 1.0);
        this.setFramesForMorphing(12);
        this.heightFunctionType = SurfaceImplicit.equationType.CUBIC;
    }
}

